#include <stdio.h>

extern unsigned char *OP_ROM;
extern unsigned char *OP_RAM;

static unsigned char ___z80_mnemonics[0x40]= {
	0x0C, 0x20, 0x00, 0x20, 0x0E, 0x20, 0x02, 0x20, 
	0x3E, 0x20, 0x32, 0x20, 0x3E, 0x20, 0x32, 0x20, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xF0, 0x23, 0x30, 0x2F, 0xB0, 0x23, 0xB0, 0x27, 
	0x30, 0x23, 0x30, 0x23, 0x30, 0x23, 0x30, 0x27, 
};

static unsigned char ___z80_mnemonicsXX[0x40]= {
	0x0C, 0x20, 0x00, 0x20, 0x0E, 0x20, 0x02, 0x20, 
	0x3E, 0x20, 0x32, 0x20, 0x3E, 0x3A, 0x32, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0xAA, 0x8A, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0xF0, 0x23, 0x70, 0x2F, 0xB0, 0x23, 0xB0, 0x23, 
	0x30, 0x23, 0x30, 0x23, 0x30, 0x23, 0x30, 0x23, 
};

static unsigned char ___z80_mnemonicsXCB[0x40]= {
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 
};


static unsigned ___z80_hack(unsigned i)
{
otra:
	unsigned val=OP_ROM[i++];
	unsigned bts=(val&3)*2;
	unsigned char v=(___z80_mnemonics[val>>2]&(3<<bts))>>bts;
//printf("val=%X b=%i v=%X",val,bts,v);
	switch(v)
	{
		case 2:
//printf(" %.4X=%.2X",i,OP_RAM[i]);
		       	OP_ROM[i]=OP_RAM[i++];
			break;
		case 3:
//printf(" %.4X=%.2X",i,OP_RAM[i]);
			OP_ROM[i]=OP_RAM[i++];
//printf(" %.4X=%.2X",i,OP_RAM[i]);
			OP_ROM[i]=OP_RAM[i++];
			break;
		case 1:
			val=OP_ROM[i++];
//printf(" -> val=%X",val);
			if (val!=0xCB)
			{
				bts=(val&3)*2;
				v=(___z80_mnemonicsXX[val>>2]&(3<<bts))>>bts;
//printf(" b=%i v=%X",bts,v);
			}
			else
			{
				val=OP_ROM[i]=OP_RAM[i++];
				bts=(val&3)*2;
				v=(___z80_mnemonicsXCB[val>>2]&(3<<bts))>>bts;
//printf(" -> val=%X b=%i v=%X",val,bts,v);
			}
			if (v==2)
			{
//printf(" %.4X=%.2X",i,OP_RAM[i]);
				OP_ROM[i]=OP_RAM[i++];
			}
			else if (v==3)
			{
//printf(" %.4X=%.2X",i,OP_RAM[i]);
				OP_ROM[i]=OP_RAM[i++];
//printf(" %.4X=%.2X",i,OP_RAM[i]);
				OP_ROM[i]=OP_RAM[i++];
			}
			break;
		default:
			if (val==0xED)
			{
				val=OP_ROM[i++];
				if ((val&0xC7)==0x43)
				{
//printf(" %.4X=%.2X",i,OP_RAM[i]);
					OP_ROM[i]=OP_RAM[i++];
//printf(" %.4X=%.2X",i,OP_RAM[i]);
					OP_ROM[i]=OP_RAM[i++];
				}
			}
			else if (val==0xFB)
				goto otra;
	}
//puts(".");
return i;
}
