/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2002 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2001 - 2004 John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2004 Brad Jorsch (anomie@users.sourceforge.net),
                            funkyass (funkyass@spam.shaw.ca),
                            Joel Yliluoma (http://iki.fi/bisqwit/)
                            Kris Bleakley (codeviolation@hotmail.com),
                            Matthew Kendora,
                            Nach (n-a-c-h@users.sourceforge.net),
                            Peter Bortas (peter@bortas.org) and
                            zones (kasumitokoduck@yahoo.com)

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and Nach

  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2004 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman, neviksti (neviksti@hotmail.com),
                            Kris Bleakley, Andreas Naive

  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2004 zsKnight, pagefault (pagefault@zsnes.com) and
                            Kris Bleakley
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003 Brad Jorsch with research by
                     Andreas Naive and John Weidman
 
  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  ST010 C++ emulator code
  (c) Copyright 2003 Feather, Kris Bleakley, John Weidman and Matthew Kendora

  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar, Gary Henderson and John Weidman


  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004 Marcus Comstedt (marcus@mc.pp.se) 

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/

// #define DREAMCAST

#include "snes9x.h"
#include "65c816.h"
#include "memmap.h"
#include "ppu.h"
#include "apu.h"
#include "cpuexec.h"
#include "sa1.h"

#ifndef S9xSTREAM
#define S9xSTREAM stdout
#endif

#ifndef DREAMCAST
#define OFFSET(N,F) \
fprintf (S9xSTREAM, "#define " #N " CPU + %d\n", (int) &((struct SCPUState *) 0)->F);
#define OFFSET2(N,F) \
fprintf (S9xSTREAM, "#define " #N " Registers + %d\n", (int) &((struct SRegisters *) 0)->F);
#define OFFSET3(F) \
fprintf (S9xSTREAM, "#define " #F " Memory + %d\n", (int) &((class CMemory *) 0)->F);
#define OFFSET4(N,F) \
fprintf (S9xSTREAM, "#define " #N " APU + %d\n", (int) &((struct SAPU *) 0)->F);
#define OFFSET5(N,F) \
fprintf (S9xSTREAM, "#define " #N " IAPU + %d\n", (int) &((struct SIAPU *) 0)->F);
#define OFFSET6(N,F) \
fprintf (S9xSTREAM, "#define " #N " ICPU + %d\n", (int) &((struct SICPU *) 0)->F);
#define OFFSET7(N,F) \
fprintf (S9xSTREAM, "#define " #N " Settings + %d\n", (int) &((struct SSettings *) 0)->F);
#define OFFSET8(N, F) \
fprintf (S9xSTREAM, "#define " #N " APURegisters + %d\n", (int) &((struct SAPURegisters *) 0)->F);

#define OFFSET9(N, F) \
fprintf (S9xSTREAM, "#define " #N " PPU + %d\n", (int) &((struct SPPU *) 0)->F);
#define OFFSET10(N, F) \
fprintf (S9xSTREAM, "#define " #N " IPPU + %d\n", (int) &((struct InternalPPU *) 0)->F);
#define OFFSET11(N, F) \
fprintf (S9xSTREAM, "#define " #N " SA1 + %d\n", (int) &((struct SSA1 *) 0)->F);
#define OFFSET12(N, F) \
fprintf (S9xSTREAM, "#define " #N " SA1Registers + %d\n", (int) &((struct SSA1Registers *) 0)->F);

#else

#ifdef USE_OFFSET_R12
#define OFFSET(N,F) \
if (((int) &((struct SCPUState *) 0)->F)) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r12)\n", (int) &((struct SCPUState *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r12\n");
#else
#define OFFSET(N,F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r11)\n", 16+((int) &((struct SCPUState *) 0)->F));
#endif

#define OFFSET2(N,F) \
if ((int) &((struct SRegisters *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r11)\n", (int) &((struct SRegisters *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r11\n");

#define OFFSET3(F) \
fprintf (S9xSTREAM, "#define " #F " _Memory + %d\n", (int) &((class CMemory *) 0)->F);

#define OFFSET4(N,F) \
if ((int) &((struct SAPU *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SAPU *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET5(N,F) \
if ((int) &((struct SIAPU *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SIAPU *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET6(N,F) \
if ((int) &((struct SICPU *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SICPU *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET7(N,F) \
if ((int) &((struct SSettings *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SSettings *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET8(N, F) \
if ((int) &((struct SAPURegisters *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SAPURegisters *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET9(N, F) \
if ((int) &((struct SPPU *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct SPPU *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET10(N, F) \
if ((int) &((struct InternalPPU *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r1)\n", (int) &((struct InternalPPU *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r1\n");

#define OFFSET11(N, F) \
if ((int) &((struct SSA1 *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, SA1REG)\n", (int) &((struct SSA1 *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @SA1REG\n");

#define OFFSET12(N, F) \
if ((int) &((struct SSA1Registers *) 0)->F) \
fprintf (S9xSTREAM, "#define " #N " @(%d, r11)\n", (int) &((struct SSA1Registers *) 0)->F); \
else \
fprintf (S9xSTREAM, "#define " #N " @r11\n");

#endif

int main (int /*argc*/, char ** /*argv*/)
{
    OFFSET(Flags,Flags)
    OFFSET(BranchSkip,BranchSkip)
    OFFSET(NMIActive,NMIActive)
    OFFSET(IRQActive,IRQActive)
    OFFSET(WaitingForInterrupt,WaitingForInterrupt)
    OFFSET(InDMA,InDMA)
    OFFSET(WhichEvent,WhichEvent)
    OFFSET(PCS,PC)
    OFFSET(PCBase,PCBase)
    OFFSET(PCAtOpcodeStart,PCAtOpcodeStart)
    OFFSET(WaitAddress,WaitAddress)
    OFFSET(WaitCounter,WaitCounter)
    OFFSET(Cycles,Cycles)
    OFFSET(NextEvent,NextEvent)
    OFFSET(V_Counter,V_Counter)
    OFFSET(MemSpeed,MemSpeed)
    OFFSET(MemSpeedx2,MemSpeedx2)
    OFFSET(FastROMSpeed,FastROMSpeed)
    OFFSET(AutoSaveTimer,AutoSaveTimer)
    OFFSET(SRAMModified,SRAMModified)
    OFFSET(NMITriggerPoint,NMITriggerPoint)
    OFFSET(TriedInterleavedMode2,TriedInterleavedMode2)
    OFFSET(BRKTriggered,BRKTriggered)
    OFFSET(NMICycleCount,NMICycleCount)
    OFFSET(IRQCycleCount,IRQCycleCount)

    OFFSET2(PB,PB)
    OFFSET2(DB,DB)
    OFFSET2(PP,P.W)
    OFFSET2(PL,P.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define PH PL + 1\n");
#else
    fprintf (S9xSTREAM, "#define PH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->P.W)+1);
#endif
    OFFSET2(AA,A.W)
    OFFSET2(AL,A.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define AH AL + 1\n");
#else
    fprintf (S9xSTREAM, "#define AH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->A.W)+1);
#endif
    OFFSET2(DD,D.W)
    OFFSET2(DL,D.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define DH DL + 1\n");
#else
    fprintf (S9xSTREAM, "#define DH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->D.W)+1);
#endif
    OFFSET2(SS,S.W)
    OFFSET2(SL,S.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define SH SL + 1\n");
#else
    fprintf (S9xSTREAM, "#define SH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->S.W)+1);
#endif
    OFFSET2(XX,X.W)
    OFFSET2(XL,X.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define XH XL + 1\n");
#else
    fprintf (S9xSTREAM, "#define XH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->X.W)+1);
#endif
    OFFSET2(YY,Y.W)
    OFFSET2(YL,Y.W)
#ifndef DREAMCAST
    fprintf (S9xSTREAM, "#define YH YL + 1\n");
#else
    fprintf (S9xSTREAM, "#define YH @(%d, r11)\n", ((int) &((struct SRegisters *) 0)->Y.W)+1);
#endif
    OFFSET2(PCR, PC)

    OFFSET3(RAM)
    OFFSET3(ROM)
    OFFSET3(VRAM)
    OFFSET3(SRAM)
    OFFSET3(BWRAM)
    OFFSET3(FillRAM)
    OFFSET3(C4RAM)
    OFFSET3(HiROM)
    OFFSET3(LoROM)
    OFFSET3(SRAMMask)
    OFFSET3(SRAMSize)
    OFFSET3(Map)
    OFFSET3(WriteMap)
    OFFSET3(MemorySpeed)
    OFFSET3(BlockIsRAM)
    OFFSET3(BlockIsROM)
    OFFSET3(ROMFilename)

    OFFSET5(APUPCS,PC)
    OFFSET5(APURAM,RAM)
    OFFSET5(APUExecuting,APUExecuting)
    OFFSET5(APUDirectPage,DirectPage)
    OFFSET5(APUBit,Bit)
    OFFSET5(APUAddress,Address)
    OFFSET5(APUWaitAddress1,WaitAddress1)
    OFFSET5(APUWaitAddress2,WaitAddress2)
    OFFSET5(APUWaitCounter,WaitCounter)
    OFFSET5(APUShadowRAM,ShadowRAM)
    OFFSET5(APUCachedSamples,CachedSamples)
    OFFSET5(APU_Carry,_Carry)
    OFFSET5(APU_Zero,_Zero)
    OFFSET5(APU_Overflow,_Overflow)
    OFFSET5(APUTimerErrorCounter,TimerErrorCounter)
    OFFSET5(NextAPUTimerPos,NextAPUTimerPos)
    OFFSET5(APUTimerCounter,APUTimerCounter)
    
    OFFSET4(APUCycles,Cycles)
    OFFSET4(APUShowROM,ShowROM)
    OFFSET4(APUFlags,Flags)
    OFFSET4(APUKeyedChannels,KeyedChannels)
    OFFSET4(APUOutPorts,OutPorts)
    OFFSET4(APUDSP,DSP)
#ifndef DREAMCAST
    OFFSET4(APUExtraRAM,ExtraRAM)
    OFFSET4(APUTimer,Timer)
    OFFSET4(APUTimerTarget,TimerTarget)
    OFFSET4(APUTimerEnabled,TimerEnabled)
    OFFSET4(TimerValueWritten,TimerValueWritten)
#else
    fprintf (S9xSTREAM, "#define APUExtraRAM %d\n", (int) &((struct SAPU *) 0)->ExtraRAM);
    fprintf (S9xSTREAM, "#define APUTimer %d\n", (int) &((struct SAPU *) 0)->Timer);
    fprintf (S9xSTREAM, "#define APUTimerTarget %d\n", (int) &((struct SAPU *) 0)->TimerTarget);
    fprintf (S9xSTREAM, "#define APUTimerEnabled %d\n", (int) &((struct SAPU *) 0)->TimerEnabled);
    fprintf (S9xSTREAM, "#define TimerValueWritten %d\n", (int) &((struct SAPU *) 0)->TimerValueWritten);
#endif

    OFFSET6(CPUSpeed,Speed)
    OFFSET6(CPUOpcodes,S9xOpcodes)
    OFFSET6(_Carry,_Carry)
    OFFSET6(_Zero,_Zero)
    OFFSET6(_Negative,_Negative)
    OFFSET6(_Overflow,_Overflow)
    OFFSET6(ShiftedDB,ShiftedDB)
    OFFSET6(ShiftedPB,ShiftedPB)
    OFFSET6(CPUExecuting,CPUExecuting)
    OFFSET6(Scanline,Scanline)
    OFFSET6(Frame,Frame)

    OFFSET7(APUEnabled,APUEnabled)
    OFFSET7(Shutdown,Shutdown)
    OFFSET7(H_Max,H_Max)
    OFFSET7(HBlankStart,HBlankStart)
    OFFSET7(CyclesPercentage,CyclesPercentage)
    OFFSET7(DisableIRQ,DisableIRQ)
    OFFSET7(Paused,Paused)
    OFFSET7(PAL,PAL)
    OFFSET7(SA1Enabled,SA1)
    OFFSET7(SuperFXEnabled,SuperFX)

    OFFSET8(ApuP,P)
    OFFSET8(ApuYA,YA.W)
    OFFSET8(ApuA,YA.B.A)
    OFFSET8(ApuY,YA.B.Y)
    OFFSET8(ApuX,X)
    OFFSET8(ApuS,S)
    OFFSET8(ApuPC,PC)
    OFFSET8(APUPCR,PC)

    OFFSET9(BGMode,BGMode)
    OFFSET9(BG3Priority,BG3Priority)
    OFFSET9(Brightness,Brightness)
    OFFSET9(GHight,VMA.High)
    OFFSET9(GInc,VMA.Increment)
    OFFSET9(GAddress,VMA.Address)
    OFFSET9(GMask1,VMA.Mask1)
    OFFSET9(GFullGraphicCount,VMA.FullGraphicCount)
    OFFSET9(GShift,VMA.Shift)
    OFFSET9(CGFLIP,CGFLIP)
    OFFSET9(CGDATA,CGDATA)
    OFFSET9(FirstSprite,FirstSprite)
    OFFSET9(LastSprite,LastSprite)
    OFFSET9(OBJ,OBJ)
    OFFSET9(OAMPriorityRotation,OAMPriorityRotation)
    OFFSET9(OAMAddr,OAMAddr)
    OFFSET9(OAMFlip,OAMFlip)
    OFFSET9(OAMTileAddress,OAMTileAddress)
    OFFSET9(IRQVBeamPos,IRQVBeamPos)
    OFFSET9(IRQHBeamPos,IRQHBeamPos)
    OFFSET9(VBeamPosLatched,VBeamPosLatched)
    OFFSET9(HBeamPosLatched,HBeamPosLatched)
    OFFSET9(HBeamFlip,HBeamFlip)
    OFFSET9(VBeamFlip,VBeamFlip)
    OFFSET9(HVBeamCounterLatched,HVBeamCounterLatched)
    OFFSET9(MatrixA,MatrixA)
    OFFSET9(MatrixB,MatrixB)
    OFFSET9(MatrixC,MatrixC)
    OFFSET9(MatrixD,MatrixD)
    OFFSET9(CentreX,CentreX)
    OFFSET9(CentreY,CentreY)
    OFFSET9(Joypad1ButtonReadPos,Joypad1ButtonReadPos)
    OFFSET9(Joypad2ButtonReadPos,Joypad2ButtonReadPos)
    OFFSET9(CGADD,CGADD)
    OFFSET9(FixedColourGreen,FixedColourGreen)
    OFFSET9(FixedColourRed,FixedColourRed)
    OFFSET9(FixedColourBlue,FixedColourBlue)
    OFFSET9(SavedOAMAddr,SavedOAMAddr)
    OFFSET9(ScreenHeight,ScreenHeight)
    OFFSET9(WRAM,WRAM)
    OFFSET9(BG_Forced,BG_Forced)
    OFFSET9(ForcedBlanking,ForcedBlanking)
    OFFSET9(OBJThroughMain,OBJThroughMain)
    OFFSET9(OBJThroughSub,OBJThroughSub)
    OFFSET9(OBJSizeSelect,OBJSizeSelect)
    OFFSET9(OBJNameBase,OBJNameBase)
    OFFSET9(OAMReadFlip,OAMReadFlip)
    OFFSET9(OAMData,OAMData)
    OFFSET9(VTimerEnabled,VTimerEnabled)
    OFFSET9(HTimerEnabled,HTimerEnabled)
    OFFSET9(HTimerPosition,HTimerPosition)
    OFFSET9(Mosaic,Mosaic)
    OFFSET9(BGMosaic,BGMosaic)
    OFFSET9(Mode7HFlip,Mode7HFlip)
    OFFSET9(Mode7VFlip,Mode7VFlip)
    OFFSET9(Mode7Repeat,Mode7Repeat)
    OFFSET9(Window1Left,Window1Left)
    OFFSET9(Window1Right,Window1Right)
    OFFSET9(Window2Left,Window2Left)
    OFFSET9(Window2Right,Window2Right)
    OFFSET9(ClipWindowOverlapLogic,ClipWindowOverlapLogic)
    OFFSET9(ClipWindow1Enable,ClipWindow1Enable)
    OFFSET9(ClipWindow2Enable,ClipWindow2Enable)
    OFFSET9(ClipWindow1Inside,ClipWindow1Inside)
    OFFSET9(ClipWindow2Inside,ClipWindow2Inside)
    OFFSET9(RecomputeClipWindows,RecomputeClipWindows)
    OFFSET9(CGFLIPRead,CGFLIPRead)
    OFFSET9(OBJNameSelect,OBJNameSelect)
    OFFSET9(Need16x8Mulitply,Need16x8Mulitply)
    OFFSET9(Joypad3ButtonReadPos,Joypad3ButtonReadPos)
    OFFSET9(MouseSpeed,MouseSpeed)
    OFFSET9(RangeTimeOver,RangeTimeOver)

    OFFSET10(ColorsChanged,ColorsChanged)
    OFFSET10(HDMA,HDMA)
    OFFSET10(HDMAStarted,HDMAStarted)
    OFFSET10(MaxBrightness,MaxBrightness)
    OFFSET10(LatchedBlanking,LatchedBlanking)
    OFFSET10(OBJChanged,OBJChanged)
    OFFSET10(RenderThisFrame,RenderThisFrame)
    OFFSET10(SkippedFrames,SkippedFrames)
    OFFSET10(FrameSkip,FrameSkip)
    OFFSET10(TileCache,TileCache)
    OFFSET10(TileCached,TileCached)
#ifdef CORRECT_VRAM_READS
    OFFSET10(VRAMReadBuffer,VRAMReadBuffer)
#else
    OFFSET10(FirstVRAMRead,FirstVRAMRead)
#endif
    OFFSET10(Interlace,Interlace)
    OFFSET10(DoubleWidthPixels,DoubleWidthPixels)
    OFFSET10(RenderedScreenHeight,RenderedScreenHeight)
    OFFSET10(RenderedScreenWidth,RenderedScreenWidth)
    OFFSET10(Red,Red)
    OFFSET10(Green,Green)
    OFFSET10(Blue,Blue)
    OFFSET10(XB,XB)
    OFFSET10(ScreenColors,ScreenColors)
    OFFSET10(PreviousLine,PreviousLine)
    OFFSET10(CurrentLine,CurrentLine)
    OFFSET10(Joypads,Joypads)
    OFFSET10(SuperScope,SuperScope)
    OFFSET10(Mouse,Mouse)
    OFFSET10(PrevMouseX,PrevMouseX)
    OFFSET10(PrevMouseY,PrevMouseY)
    OFFSET10(Clip,Clip)

    OFFSET11(SA1Opcodes,S9xOpcodes)
    OFFSET11(SA1_Carry,_Carry)
    OFFSET11(SA1_Zero,_Zero)
    OFFSET11(SA1_Negative,_Negative)
    OFFSET11(SA1_Overflow,_Overflow)
    OFFSET11(SA1CPUExecuting,CPUExecuting)
    OFFSET11(SA1ShiftedPB,ShiftedPB)
    OFFSET11(SA1ShiftedDB,ShiftedDB)
    OFFSET11(SA1Flags,Flags)
    OFFSET11(SA1Executing,Executing)
    OFFSET11(SA1NMIActive,NMIActive)
    OFFSET11(SA1IRQActive,IRQActive)
    OFFSET11(SA1WaitingForInterrupt,WaitingForInterrupt)
    OFFSET11(SA1PCS,PC)
    OFFSET11(SA1PCBase,PCBase)
    OFFSET11(SA1PCAtOpcodeStart,PCAtOpcodeStart)
    OFFSET11(SA1WaitAddress,WaitAddress)
    OFFSET11(SA1WaitCounter,WaitCounter)
    OFFSET11(SA1WaitByteAddress1,WaitByteAddress1)
    OFFSET11(SA1WaitByteAddress2,WaitByteAddress2)
    OFFSET11(SA1BWRAM,BWRAM)
    OFFSET11(SA1Map,Map)
    OFFSET11(SA1WriteMap,WriteMap)
    OFFSET11(SA1op1,op1)
    OFFSET11(SA1op2,op2)
    OFFSET11(SA1arithmetic_op,arithmetic_op)
    OFFSET11(SA1sum,sum)
    OFFSET11(SA1overflow,overflow)
    OFFSET11(VirtualBitmapFormat,VirtualBitmapFormat)
    OFFSET11(SA1_in_char_dma,in_char_dma)
    OFFSET11(SA1variable_bit_pos,variable_bit_pos)

    OFFSET12(SA1PB,PB)
    OFFSET12(SA1DB,DB)
    OFFSET12(SA1PP,P.W)
    OFFSET12(SA1PL,P.W)
    fprintf (S9xSTREAM, "#define SA1PH SA1PL + 1\n");
    OFFSET12(SA1AA,A.W)
    OFFSET12(SA1AL,A.W)
    fprintf (S9xSTREAM, "#define SA1AH SA1AL + 1\n");
    OFFSET12(SA1DD,D.W)
    OFFSET12(SA1DL,D.W)
    fprintf (S9xSTREAM, "#define SA1DH SA1DL + 1\n");
    OFFSET12(SA1SS,S.W)
    OFFSET12(SA1SL,S.W)
    fprintf (S9xSTREAM, "#define SA1SH SA1SL + 1\n");
    OFFSET12(SA1XX,X.W)
    OFFSET12(SA1XL,X.W)
    fprintf (S9xSTREAM, "#define SA1XH SA1XL + 1\n");
    OFFSET12(SA1YY,Y.W)
    OFFSET12(SA1YL,Y.W)
    fprintf (S9xSTREAM, "#define SA1YH SA1YL + 1\n");
    OFFSET12(SA1PCR, PC)

#ifdef DREAMCAST

    fputs("#define S9xGetByte @(4, r14)\n",S9xSTREAM);
    fputs("#define S9xSetByte @(8, r14)\n",S9xSTREAM);
    fputs("#define S9xGetWord @(12, r14)\n",S9xSTREAM);
    fputs("#define S9xSetWord @(16, r14)\n",S9xSTREAM);
    fputs("#define S9xOpcode_IRQ @(20, r14)\n",S9xSTREAM);
    fputs("#define S9xOpcode_NMI @(24, r14)\n",S9xSTREAM);
    fputs("#define S9xSetPCBase @(28, r14)\n",S9xSTREAM);
    fputs("#define ICPU @(32, r14)\n",S9xSTREAM);
    fputs("#define IAPU @(36, r14)\n",S9xSTREAM);
    fputs("#define APU @(40, r14)\n",S9xSTREAM);
    fputs("#define SA1 @(44, r14)\n",S9xSTREAM);
    fputs("#define APURegisters @(48, r14)\n",S9xSTREAM);
    fputs("#define Settings @(52, r14)\n",S9xSTREAM);
    fputs("#define IPPU @(56, r14)\n",S9xSTREAM);
    fputs("#define PPU @(60, r14)\n",S9xSTREAM);

    fprintf (S9xSTREAM, "#define SA1Map_offs %d\n", (int) &((struct SSA1 *) 0)->Map);
    fprintf (S9xSTREAM, "#define SA1WriteMap_offs %d\n", (int) &((struct SSA1 *) 0)->WriteMap);
    fprintf (S9xSTREAM, "#define NMITriggerPoint_offs %d\n", (int) &((struct SCPUState *) 0)->NMITriggerPoint);
#endif

    return (0);
}

