/*
* Castaway
*  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
*
* $File$ - 68k subtract instructions
*
* This file is distributed under the GPL, version 2 or at your
* option any later version.  See doc/license.txt for details.
*
* revision history
*  23.05.2002  JH  FAST1.0.1 code import: KR -> ANSI, restructuring
*  10.07.2002  JH  Fixed Z-Flag for SUBX
*  08.10.2002  JH  Fixed Z-Flag for ADD.B 0x80+0x80 and Add.W 0x8000+0x8000.
*/
#ifndef PROTOH
static char     sccsid[] = "$Id: op68ksub.c,v 1.3 2002/10/08 00:18:02 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

/*
* Opfuncs.
*/

#define DoSubB(target,source) \
{register int32 tgt, cvnz=0;\
    tgt = target - source;\
	if ((uint32) source > (uint32) target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target = tgt;\
	if (tgt!=target) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoSubW(target,source) \
{register int32 tgt, cvnz=0;\
    tgt = target - source;\
    if ((uint32) source > (uint32) target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target = tgt;\
	if (tgt!=target) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoSubL(target,source) \
    /* Overflow precondition: source has different sign */\
{register int32 precon=(target>>31)-(source>>31), cvnz=0;\
    if ((uint32) source > (uint32) target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target -= source;\
    /* target and source now have same sign: overflow! */\
    if (precon && (target>>31)==(source>>31)) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoSuba(target,source) target -= source;

#define DoSubx(target,source) \
    /* Overflow precondition: source has different sign */\
{register int32 precon=(target>>31)-(source>>31);\
    if (GetX ()) {\
	SetXC ((uint32) source >= (uint32) target);\
	target -= source;\
	target -= 1;\
    } else {\
	SetXC ((uint32) source > (uint32) target);\
	target -= source;\
}\
    /* target and source now have same sign: overflow! */\
    SetV(precon && (target>>31)==(source>>31));\
    ZeroZ(target!=0);\
SetN(target < 0);};
#endif


Oper (Op9000, DoSubB, DB, SdB, ins7, DB, DR, Cd, 0, GRB, SRB, 4)
Oper (Op9010, DoSubB, DB, SainB, ins7, DB, DR, Cd, 0, GRB, SRB, 8)
Oper (Op9018, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 0, GRB, SRB, 8)
Oper (Op9020, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 0, GRB, SRB, 12)
Oper (Op9028, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 0, GRB, SRB, 12)
Oper (Op9030, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 0, GRB, SRB, 16)
Oper (Op9038, DoSubB, DB, SearB, ins7, DB, DR, Cd, 0, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9040, DoSubW, DW, SdW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Op9048, DoSubW, DW, SaW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Op9050, DoSubW, DW, SainW, ins7, DW, DR, Cd, 0, GRW, SRW, 8)
Oper (Op9058, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 0, GRW, SRW, 8)
Oper (Op9060, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 0, GRW, SRW, 12)
Oper (Op9068, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 0, GRW, SRW, 12)
Oper (Op9070, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 0, GRW, SRW, 16)
Oper (Op9078, DoSubW, DW, SearW, ins7, DW, DR, Cd, 0, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9080, DoSubL, DL, SdL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Op9088, DoSubL, DL, SaL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Op9090, DoSubL, DL, SainL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Op9098, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Op90a0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Op90a8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 0, GRL, SRL, 20)
Oper (Op90b0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 0, GRL, SRL, 20)
Oper (Op90b8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 0, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op90c0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Op90c8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Op90d0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 0, GRL, SRL, 12)
Oper (Op90d8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 0, GRL, SRL, 12)
Oper (Op90e0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Op90e8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Op90f0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Op90f8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 0, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9100, DoSubx, DB, SdB, ins7, DB, DR, Cd, 0, GRB, SRB, 4)
Oper (Op9108, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 0, GMB, SMB, 20)
Oper (Op9110, DoSubB, DB, SdB, 0, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9118, DoSubB, DB, SdB, 0, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9120, DoSubB, DB, SdB, 0, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9128, DoSubB, DB, SdB, 0, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9130, DoSubB, DB, SdB, 0, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9138, DoSubB, DB, SdB, 0, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9140, DoSubx, DW, SdW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Op9148, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 0, GMW, SMW, 20)
Oper (Op9150, DoSubW, DW, SdW, 0, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9158, DoSubW, DW, SdW, 0, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9160, DoSubW, DW, SdW, 0, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9168, DoSubW, DW, SdW, 0, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9170, DoSubW, DW, SdW, 0, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9178, DoSubW, DW, SdW, 0, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9180, DoSubx, DL, SdL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Op9188, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 0, GML, SML, 32)
Oper (Op9190, DoSubL, DL, SdL, 0, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9198, DoSubL, DL, SdL, 0, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op91a0, DoSubL, DL, SdL, 0, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op91a8, DoSubL, DL, SdL, 0, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op91b0, DoSubL, DL, SdL, 0, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op91b8, DoSubL, DL, SdL, 0, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op91c0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Op91c8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Op91d0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Op91d8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Op91e0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Op91e8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Op91f0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Op91f8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 0, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9200, DoSubB, DB, SdB, ins7, DB, DR, Cd, 1, GRB, SRB, 4)
Oper (Op9210, DoSubB, DB, SainB, ins7, DB, DR, Cd, 1, GRB, SRB, 8)
Oper (Op9218, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 1, GRB, SRB, 8)
Oper (Op9220, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 1, GRB, SRB, 12)
Oper (Op9228, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 1, GRB, SRB, 12)
Oper (Op9230, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 1, GRB, SRB, 16)
Oper (Op9238, DoSubB, DB, SearB, ins7, DB, DR, Cd, 1, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9240, DoSubW, DW, SdW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Op9248, DoSubW, DW, SaW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Op9250, DoSubW, DW, SainW, ins7, DW, DR, Cd, 1, GRW, SRW, 8)
Oper (Op9258, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 1, GRW, SRW, 8)
Oper (Op9260, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 1, GRW, SRW, 12)
Oper (Op9268, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 1, GRW, SRW, 12)
Oper (Op9270, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 1, GRW, SRW, 16)
Oper (Op9278, DoSubW, DW, SearW, ins7, DW, DR, Cd, 1, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9280, DoSubL, DL, SdL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Op9288, DoSubL, DL, SaL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Op9290, DoSubL, DL, SainL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Op9298, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Op92a0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Op92a8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 1, GRL, SRL, 20)
Oper (Op92b0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 1, GRL, SRL, 20)
Oper (Op92b8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 1, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op92c0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Op92c8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Op92d0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 1, GRL, SRL, 12)
Oper (Op92d8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 1, GRL, SRL, 12)
Oper (Op92e0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Op92e8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Op92f0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Op92f8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 1, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9300, DoSubx, DB, SdB, ins7, DB, DR, Cd, 1, GRB, SRB, 4)
Oper (Op9308, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 1, GMB, SMB, 20)
Oper (Op9310, DoSubB, DB, SdB, 1, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9318, DoSubB, DB, SdB, 1, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9320, DoSubB, DB, SdB, 1, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9328, DoSubB, DB, SdB, 1, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9330, DoSubB, DB, SdB, 1, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9338, DoSubB, DB, SdB, 1, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9340, DoSubx, DW, SdW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Op9348, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 1, GMW, SMW, 20)
Oper (Op9350, DoSubW, DW, SdW, 1, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9358, DoSubW, DW, SdW, 1, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9360, DoSubW, DW, SdW, 1, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9368, DoSubW, DW, SdW, 1, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9370, DoSubW, DW, SdW, 1, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9378, DoSubW, DW, SdW, 1, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9380, DoSubx, DL, SdL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Op9388, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 1, GML, SML, 32)
Oper (Op9390, DoSubL, DL, SdL, 1, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9398, DoSubL, DL, SdL, 1, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op93a0, DoSubL, DL, SdL, 1, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op93a8, DoSubL, DL, SdL, 1, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op93b0, DoSubL, DL, SdL, 1, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op93b8, DoSubL, DL, SdL, 1, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op93c0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Op93c8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Op93d0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Op93d8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Op93e0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Op93e8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Op93f0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Op93f8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 1, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9400, DoSubB, DB, SdB, ins7, DB, DR, Cd, 2, GRB, SRB, 4)
Oper (Op9410, DoSubB, DB, SainB, ins7, DB, DR, Cd, 2, GRB, SRB, 8)
Oper (Op9418, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 2, GRB, SRB, 8)
Oper (Op9420, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 2, GRB, SRB, 12)
Oper (Op9428, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 2, GRB, SRB, 12)
Oper (Op9430, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 2, GRB, SRB, 16)
Oper (Op9438, DoSubB, DB, SearB, ins7, DB, DR, Cd, 2, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9440, DoSubW, DW, SdW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Op9448, DoSubW, DW, SaW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Op9450, DoSubW, DW, SainW, ins7, DW, DR, Cd, 2, GRW, SRW, 8)
Oper (Op9458, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 2, GRW, SRW, 8)
Oper (Op9460, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 2, GRW, SRW, 12)
Oper (Op9468, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 2, GRW, SRW, 12)
Oper (Op9470, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 2, GRW, SRW, 16)
Oper (Op9478, DoSubW, DW, SearW, ins7, DW, DR, Cd, 2, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9480, DoSubL, DL, SdL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Op9488, DoSubL, DL, SaL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Op9490, DoSubL, DL, SainL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Op9498, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Op94a0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Op94a8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 2, GRL, SRL, 20)
Oper (Op94b0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 2, GRL, SRL, 20)
Oper (Op94b8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 2, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op94c0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Op94c8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Op94d0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 2, GRL, SRL, 12)
Oper (Op94d8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 2, GRL, SRL, 12)
Oper (Op94e0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Op94e8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Op94f0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Op94f8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 2, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9500, DoSubx, DB, SdB, ins7, DB, DR, Cd, 2, GRB, SRB, 4)
Oper (Op9508, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 2, GMB, SMB, 20)
Oper (Op9510, DoSubB, DB, SdB, 2, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9518, DoSubB, DB, SdB, 2, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9520, DoSubB, DB, SdB, 2, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9528, DoSubB, DB, SdB, 2, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9530, DoSubB, DB, SdB, 2, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9538, DoSubB, DB, SdB, 2, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9540, DoSubx, DW, SdW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Op9548, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 2, GMW, SMW, 20)
Oper (Op9550, DoSubW, DW, SdW, 2, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9558, DoSubW, DW, SdW, 2, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9560, DoSubW, DW, SdW, 2, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9568, DoSubW, DW, SdW, 2, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9570, DoSubW, DW, SdW, 2, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9578, DoSubW, DW, SdW, 2, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9580, DoSubx, DL, SdL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Op9588, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 2, GML, SML, 32)
Oper (Op9590, DoSubL, DL, SdL, 2, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9598, DoSubL, DL, SdL, 2, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op95a0, DoSubL, DL, SdL, 2, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op95a8, DoSubL, DL, SdL, 2, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op95b0, DoSubL, DL, SdL, 2, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op95b8, DoSubL, DL, SdL, 2, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op95c0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Op95c8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Op95d0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Op95d8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Op95e0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Op95e8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Op95f0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Op95f8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 2, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9600, DoSubB, DB, SdB, ins7, DB, DR, Cd, 3, GRB, SRB, 4)
Oper (Op9610, DoSubB, DB, SainB, ins7, DB, DR, Cd, 3, GRB, SRB, 8)
Oper (Op9618, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 3, GRB, SRB, 8)
Oper (Op9620, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 3, GRB, SRB, 12)
Oper (Op9628, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 3, GRB, SRB, 12)
Oper (Op9630, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 3, GRB, SRB, 16)
Oper (Op9638, DoSubB, DB, SearB, ins7, DB, DR, Cd, 3, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9640, DoSubW, DW, SdW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Op9648, DoSubW, DW, SaW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Op9650, DoSubW, DW, SainW, ins7, DW, DR, Cd, 3, GRW, SRW, 8)
Oper (Op9658, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 3, GRW, SRW, 8)
Oper (Op9660, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 3, GRW, SRW, 12)
Oper (Op9668, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 3, GRW, SRW, 12)
Oper (Op9670, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 3, GRW, SRW, 16)
Oper (Op9678, DoSubW, DW, SearW, ins7, DW, DR, Cd, 3, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9680, DoSubL, DL, SdL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Op9688, DoSubL, DL, SaL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Op9690, DoSubL, DL, SainL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Op9698, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Op96a0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Op96a8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 3, GRL, SRL, 20)
Oper (Op96b0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 3, GRL, SRL, 20)
Oper (Op96b8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 3, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op96c0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Op96c8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Op96d0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 3, GRL, SRL, 12)
Oper (Op96d8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 3, GRL, SRL, 12)
Oper (Op96e0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Op96e8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Op96f0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Op96f8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 3, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9700, DoSubx, DB, SdB, ins7, DB, DR, Cd, 3, GRB, SRB, 4)
Oper (Op9708, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 3, GMB, SMB, 20)
Oper (Op9710, DoSubB, DB, SdB, 3, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9718, DoSubB, DB, SdB, 3, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9720, DoSubB, DB, SdB, 3, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9728, DoSubB, DB, SdB, 3, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9730, DoSubB, DB, SdB, 3, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9738, DoSubB, DB, SdB, 3, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9740, DoSubx, DW, SdW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Op9748, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 3, GMW, SMW, 20)
Oper (Op9750, DoSubW, DW, SdW, 3, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9758, DoSubW, DW, SdW, 3, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9760, DoSubW, DW, SdW, 3, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9768, DoSubW, DW, SdW, 3, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9770, DoSubW, DW, SdW, 3, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9778, DoSubW, DW, SdW, 3, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9780, DoSubx, DL, SdL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Op9788, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 3, GML, SML, 32)
Oper (Op9790, DoSubL, DL, SdL, 3, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9798, DoSubL, DL, SdL, 3, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op97a0, DoSubL, DL, SdL, 3, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op97a8, DoSubL, DL, SdL, 3, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op97b0, DoSubL, DL, SdL, 3, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op97b8, DoSubL, DL, SdL, 3, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op97c0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Op97c8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Op97d0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Op97d8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Op97e0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Op97e8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Op97f0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Op97f8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 3, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9800, DoSubB, DB, SdB, ins7, DB, DR, Cd, 4, GRB, SRB, 4)
Oper (Op9810, DoSubB, DB, SainB, ins7, DB, DR, Cd, 4, GRB, SRB, 8)
Oper (Op9818, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 4, GRB, SRB, 8)
Oper (Op9820, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 4, GRB, SRB, 12)
Oper (Op9828, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 4, GRB, SRB, 12)
Oper (Op9830, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 4, GRB, SRB, 16)
Oper (Op9838, DoSubB, DB, SearB, ins7, DB, DR, Cd, 4, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9840, DoSubW, DW, SdW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Op9848, DoSubW, DW, SaW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Op9850, DoSubW, DW, SainW, ins7, DW, DR, Cd, 4, GRW, SRW, 8)
Oper (Op9858, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 4, GRW, SRW, 8)
Oper (Op9860, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 4, GRW, SRW, 12)
Oper (Op9868, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 4, GRW, SRW, 12)
Oper (Op9870, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 4, GRW, SRW, 16)
Oper (Op9878, DoSubW, DW, SearW, ins7, DW, DR, Cd, 4, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9880, DoSubL, DL, SdL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Op9888, DoSubL, DL, SaL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Op9890, DoSubL, DL, SainL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Op9898, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Op98a0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Op98a8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 4, GRL, SRL, 20)
Oper (Op98b0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 4, GRL, SRL, 20)
Oper (Op98b8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 4, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op98c0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Op98c8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Op98d0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 4, GRL, SRL, 12)
Oper (Op98d8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 4, GRL, SRL, 12)
Oper (Op98e0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Op98e8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Op98f0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Op98f8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 4, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9900, DoSubx, DB, SdB, ins7, DB, DR, Cd, 4, GRB, SRB, 4)
Oper (Op9908, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 4, GMB, SMB, 20)
Oper (Op9910, DoSubB, DB, SdB, 4, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9918, DoSubB, DB, SdB, 4, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9920, DoSubB, DB, SdB, 4, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9928, DoSubB, DB, SdB, 4, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9930, DoSubB, DB, SdB, 4, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9938, DoSubB, DB, SdB, 4, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9940, DoSubx, DW, SdW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Op9948, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 4, GMW, SMW, 20)
Oper (Op9950, DoSubW, DW, SdW, 4, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9958, DoSubW, DW, SdW, 4, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9960, DoSubW, DW, SdW, 4, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9968, DoSubW, DW, SdW, 4, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9970, DoSubW, DW, SdW, 4, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9978, DoSubW, DW, SdW, 4, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9980, DoSubx, DL, SdL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Op9988, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 4, GML, SML, 32)
Oper (Op9990, DoSubL, DL, SdL, 4, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9998, DoSubL, DL, SdL, 4, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op99a0, DoSubL, DL, SdL, 4, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op99a8, DoSubL, DL, SdL, 4, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op99b0, DoSubL, DL, SdL, 4, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op99b8, DoSubL, DL, SdL, 4, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op99c0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Op99c8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Op99d0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Op99d8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Op99e0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Op99e8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Op99f0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Op99f8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 4, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9a00, DoSubB, DB, SdB, ins7, DB, DR, Cd, 5, GRB, SRB, 4)
Oper (Op9a10, DoSubB, DB, SainB, ins7, DB, DR, Cd, 5, GRB, SRB, 8)
Oper (Op9a18, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 5, GRB, SRB, 8)
Oper (Op9a20, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 5, GRB, SRB, 12)
Oper (Op9a28, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 5, GRB, SRB, 12)
Oper (Op9a30, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 5, GRB, SRB, 16)
Oper (Op9a38, DoSubB, DB, SearB, ins7, DB, DR, Cd, 5, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9a40, DoSubW, DW, SdW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Op9a48, DoSubW, DW, SaW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Op9a50, DoSubW, DW, SainW, ins7, DW, DR, Cd, 5, GRW, SRW, 8)
Oper (Op9a58, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 5, GRW, SRW, 8)
Oper (Op9a60, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 5, GRW, SRW, 12)
Oper (Op9a68, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 5, GRW, SRW, 12)
Oper (Op9a70, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 5, GRW, SRW, 16)
Oper (Op9a78, DoSubW, DW, SearW, ins7, DW, DR, Cd, 5, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9a80, DoSubL, DL, SdL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Op9a88, DoSubL, DL, SaL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Op9a90, DoSubL, DL, SainL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Op9a98, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Op9aa0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Op9aa8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 5, GRL, SRL, 20)
Oper (Op9ab0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 5, GRL, SRL, 20)
Oper (Op9ab8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 5, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op9ac0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Op9ac8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Op9ad0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 5, GRL, SRL, 12)
Oper (Op9ad8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 5, GRL, SRL, 12)
Oper (Op9ae0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Op9ae8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Op9af0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Op9af8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 5, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9b00, DoSubx, DB, SdB, ins7, DB, DR, Cd, 5, GRB, SRB, 4)
Oper (Op9b08, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 5, GMB, SMB, 20)
Oper (Op9b10, DoSubB, DB, SdB, 5, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9b18, DoSubB, DB, SdB, 5, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9b20, DoSubB, DB, SdB, 5, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9b28, DoSubB, DB, SdB, 5, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9b30, DoSubB, DB, SdB, 5, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9b38, DoSubB, DB, SdB, 5, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9b40, DoSubx, DW, SdW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Op9b48, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 5, GMW, SMW, 20)
Oper (Op9b50, DoSubW, DW, SdW, 5, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9b58, DoSubW, DW, SdW, 5, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9b60, DoSubW, DW, SdW, 5, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9b68, DoSubW, DW, SdW, 5, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9b70, DoSubW, DW, SdW, 5, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9b78, DoSubW, DW, SdW, 5, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9b80, DoSubx, DL, SdL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Op9b88, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 5, GML, SML, 32)
Oper (Op9b90, DoSubL, DL, SdL, 5, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9b98, DoSubL, DL, SdL, 5, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op9ba0, DoSubL, DL, SdL, 5, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op9ba8, DoSubL, DL, SdL, 5, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op9bb0, DoSubL, DL, SdL, 5, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op9bb8, DoSubL, DL, SdL, 5, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op9bc0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Op9bc8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Op9bd0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Op9bd8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Op9be0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Op9be8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Op9bf0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Op9bf8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 5, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9c00, DoSubB, DB, SdB, ins7, DB, DR, Cd, 6, GRB, SRB, 4)
Oper (Op9c10, DoSubB, DB, SainB, ins7, DB, DR, Cd, 6, GRB, SRB, 8)
Oper (Op9c18, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 6, GRB, SRB, 8)
Oper (Op9c20, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 6, GRB, SRB, 12)
Oper (Op9c28, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 6, GRB, SRB, 12)
Oper (Op9c30, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 6, GRB, SRB, 16)
Oper (Op9c38, DoSubB, DB, SearB, ins7, DB, DR, Cd, 6, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9c40, DoSubW, DW, SdW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Op9c48, DoSubW, DW, SaW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Op9c50, DoSubW, DW, SainW, ins7, DW, DR, Cd, 6, GRW, SRW, 8)
Oper (Op9c58, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 6, GRW, SRW, 8)
Oper (Op9c60, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 6, GRW, SRW, 12)
Oper (Op9c68, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 6, GRW, SRW, 12)
Oper (Op9c70, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 6, GRW, SRW, 16)
Oper (Op9c78, DoSubW, DW, SearW, ins7, DW, DR, Cd, 6, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9c80, DoSubL, DL, SdL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Op9c88, DoSubL, DL, SaL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Op9c90, DoSubL, DL, SainL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Op9c98, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Op9ca0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Op9ca8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 6, GRL, SRL, 20)
Oper (Op9cb0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 6, GRL, SRL, 20)
Oper (Op9cb8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 6, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op9cc0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Op9cc8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Op9cd0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 6, GRL, SRL, 12)
Oper (Op9cd8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 6, GRL, SRL, 12)
Oper (Op9ce0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Op9ce8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Op9cf0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Op9cf8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 6, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9d00, DoSubx, DB, SdB, ins7, DB, DR, Cd, 6, GRB, SRB, 4)
Oper (Op9d08, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB, 6, GMB, SMB, 20)
Oper (Op9d10, DoSubB, DB, SdB, 6, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9d18, DoSubB, DB, SdB, 6, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9d20, DoSubB, DB, SdB, 6, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9d28, DoSubB, DB, SdB, 6, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9d30, DoSubB, DB, SdB, 6, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9d38, DoSubB, DB, SdB, 6, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9d40, DoSubx, DW, SdW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Op9d48, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 6, GMW, SMW, 20)
Oper (Op9d50, DoSubW, DW, SdW, 6, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9d58, DoSubW, DW, SdW, 6, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9d60, DoSubW, DW, SdW, 6, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9d68, DoSubW, DW, SdW, 6, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9d70, DoSubW, DW, SdW, 6, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9d78, DoSubW, DW, SdW, 6, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9d80, DoSubx, DL, SdL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Op9d88, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 6, GML, SML, 32)
Oper (Op9d90, DoSubL, DL, SdL, 6, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9d98, DoSubL, DL, SdL, 6, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op9da0, DoSubL, DL, SdL, 6, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op9da8, DoSubL, DL, SdL, 6, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op9db0, DoSubL, DL, SdL, 6, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op9db8, DoSubL, DL, SdL, 6, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op9dc0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Op9dc8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Op9dd0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Op9dd8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Op9de0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Op9de8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Op9df0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Op9df8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 6, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op9e00, DoSubB, DB, SdB, ins7, DB, DR, Cd, 7, GRB, SRB, 4)
Oper (Op9e10, DoSubB, DB, SainB, ins7, DB, DR, Cd, 7, GRB, SRB, 8)
Oper (Op9e18, DoSubB, DB, SaipB, ins7, DB, DR, Cd, 7, GRB, SRB, 8)
Oper (Op9e20, DoSubB, DB, SmaiB, ins7, DB, DR, Cd, 7, GRB, SRB, 12)
Oper (Op9e28, DoSubB, DB, SdaiB, ins7, DB, DR, Cd, 7, GRB, SRB, 12)
Oper (Op9e30, DoSubB, DB, SaixB, ins7, DB, DR, Cd, 7, GRB, SRB, 16)
Oper (Op9e38, DoSubB, DB, SearB, ins7, DB, DR, Cd, 7, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Op9e40, DoSubW, DW, SdW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Op9e48, DoSubW, DW, SaW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Op9e50, DoSubW, DW, SainW, ins7, DW, DR, Cd, 7, GRW, SRW, 8)
Oper (Op9e58, DoSubW, DW, SaipW, ins7, DW, DR, Cd, 7, GRW, SRW, 8)
Oper (Op9e60, DoSubW, DW, SmaiW, ins7, DW, DR, Cd, 7, GRW, SRW, 12)
Oper (Op9e68, DoSubW, DW, SdaiW, ins7, DW, DR, Cd, 7, GRW, SRW, 12)
Oper (Op9e70, DoSubW, DW, SaixW, ins7, DW, DR, Cd, 7, GRW, SRW, 16)
Oper (Op9e78, DoSubW, DW, SearW, ins7, DW, DR, Cd, 7, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Op9e80, DoSubL, DL, SdL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Op9e88, DoSubL, DL, SaL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Op9e90, DoSubL, DL, SainL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Op9e98, DoSubL, DL, SaipL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Op9ea0, DoSubL, DL, SmaiL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Op9ea8, DoSubL, DL, SdaiL, ins7, DL, DR, Cd, 7, GRL, SRL, 20)
Oper (Op9eb0, DoSubL, DL, SaixL, ins7, DL, DR, Cd, 7, GRL, SRL, 20)
Oper (Op9eb8, DoSubL, DL, SearL, ins7, DL, DR, Cd, 7, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Op9ec0, DoSuba, DL, SdW, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Op9ec8, DoSuba, DL, SaW, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Op9ed0, DoSuba, DL, SainW, ins7, DL, DR, Ca, 7, GRL, SRL, 12)
Oper (Op9ed8, DoSuba, DL, SaipW, ins7, DL, DR, Ca, 7, GRL, SRL, 12)
Oper (Op9ee0, DoSuba, DL, SmaiW, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Op9ee8, DoSuba, DL, SdaiW, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Op9ef0, DoSuba, DL, SaixW, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Op9ef8, DoSuba, DL, SearW, ins7, DL, DR, Ca, 7, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Op9f00, DoSubx, DB, SdB, ins7, DB, DR, Cd, 7, GRB, SRB, 4)
Oper (Op9f08, DoSubx, DB, SmaiB, ins7, DB, DA, CmaiB15, 7, GMB, SMB, 20)
Oper (Op9f10, DoSubB, DB, SdB, 7, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op9f18, DoSubB, DB, SdB, 7, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op9f20, DoSubB, DB, SdB, 7, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op9f28, DoSubB, DB, SdB, 7, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op9f30, DoSubB, DB, SdB, 7, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op9f38, DoSubB, DB, SdB, 7, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op9f40, DoSubx, DW, SdW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Op9f48, DoSubx, DW, SmaiW, ins7, DW, DA, CmaiW, 7, GMW, SMW, 20)
Oper (Op9f50, DoSubW, DW, SdW, 7, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op9f58, DoSubW, DW, SdW, 7, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op9f60, DoSubW, DW, SdW, 7, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op9f68, DoSubW, DW, SdW, 7, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op9f70, DoSubW, DW, SdW, 7, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op9f78, DoSubW, DW, SdW, 7, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op9f80, DoSubx, DL, SdL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Op9f88, DoSubx, DL, SmaiL, ins7, DL, DA, CmaiL, 7, GML, SML, 32)
Oper (Op9f90, DoSubL, DL, SdL, 7, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op9f98, DoSubL, DL, SdL, 7, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op9fa0, DoSubL, DL, SdL, 7, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op9fa8, DoSubL, DL, SdL, 7, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op9fb0, DoSubL, DL, SdL, 7, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op9fb8, DoSubL, DL, SdL, 7, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Op9fc0, DoSuba, DL, SdL, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Op9fc8, DoSuba, DL, SaL, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Op9fd0, DoSuba, DL, SainL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Op9fd8, DoSuba, DL, SaipL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Op9fe0, DoSuba, DL, SmaiL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Op9fe8, DoSuba, DL, SdaiL, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Op9ff0, DoSuba, DL, SaixL, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Op9ff8, DoSuba, DL, SearL, ins7, DL, DR, Ca, 7, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op0400, DoSubB, DB, SimmB, 0, DB, DR, Cd, ins7, GRB, SRB, 8)
Oper (Op0410, DoSubB, DB, SimmB, 0, DB, DA, Cain, ins7, GMB, SMB, 16)
Oper (Op0418, DoSubB, DB, SimmB, 0, DB, DA, CaipB, ins7, GMB, SMB, 16)
Oper (Op0420, DoSubB, DB, SimmB, 0, DB, DA, CmaiB, ins7, GMB, SMB, 20)
Oper (Op0428, DoSubB, DB, SimmB, 0, DB, DA, Cdai, ins7, GMB, SMB, 20)
Oper (Op0430, DoSubB, DB, SimmB, 0, DB, DA, Caix, ins7, GMB, SMB, 24)
Oper (Op0438, DoSubB, DB, SimmB, 0, DB, DA, Ceaw, ins7, GMB, SMB, (cycles+23)&0xfffffffc)
Oper (Op0440, DoSubW, DW, SimmW, 0, DW, DR, Cd, ins7, GRW, SRW, 8)
Oper (Op0450, DoSubW, DW, SimmW, 0, DW, DA, Cain, ins7, GMW, SMW, 16)
Oper (Op0458, DoSubW, DW, SimmW, 0, DW, DA, CaipW, ins7, GMW, SMW, 16)
Oper (Op0460, DoSubW, DW, SimmW, 0, DW, DA, CmaiW, ins7, GMW, SMW, 20)
Oper (Op0468, DoSubW, DW, SimmW, 0, DW, DA, Cdai, ins7, GMW, SMW, 20)
Oper (Op0470, DoSubW, DW, SimmW, 0, DW, DA, Caix, ins7, GMW, SMW, 24)
Oper (Op0478, DoSubW, DW, SimmW, 0, DW, DA, Ceaw, ins7, GMW, SMW, (cycles+23)&0xfffffffc)
Oper (Op0480, DoSubL, DL, SimmL, 0, DL, DR, Cd, ins7, GRL, SRL, 16)
Oper (Op0490, DoSubL, DL, SimmL, 0, DL, DA, Cain, ins7, GML, SML, 28)
Oper (Op0498, DoSubL, DL, SimmL, 0, DL, DA, CaipL, ins7, GML, SML, 28)
Oper (Op04a0, DoSubL, DL, SimmL, 0, DL, DA, CmaiL, ins7, GML, SML, 32)
Oper (Op04a8, DoSubL, DL, SimmL, 0, DL, DA, Cdai, ins7, GML, SML, 32)
Oper (Op04b0, DoSubL, DL, SimmL, 0, DL, DA, Caix, ins7, GML, SML, 36)
Oper (Op04b8, DoSubL, DL, SimmL, 0, DL, DA, Ceaw, ins7, GML, SML, (cycles+35)&0xfffffffc)

Oper (Op5100, DoSubB, DB, Ss, 8, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5110, DoSubB, DB, Ss, 8, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5118, DoSubB, DB, Ss, 8, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5120, DoSubB, DB, Ss, 8, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5128, DoSubB, DB, Ss, 8, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5130, DoSubB, DB, Ss, 8, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5138, DoSubB, DB, Ss, 8, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5140, DoSubW, DW, Ss, 8, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5148, DoSuba, DL, Ss, 8, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5150, DoSubW, DW, Ss, 8, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5158, DoSubW, DW, Ss, 8, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5160, DoSubW, DW, Ss, 8, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5168, DoSubW, DW, Ss, 8, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5170, DoSubW, DW, Ss, 8, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5178, DoSubW, DW, Ss, 8, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5180, DoSubL, DL, Ss, 8, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5188, DoSuba, DL, Ss, 8, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5190, DoSubL, DL, Ss, 8, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5198, DoSubL, DL, Ss, 8, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op51a0, DoSubL, DL, Ss, 8, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op51a8, DoSubL, DL, Ss, 8, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op51b0, DoSubL, DL, Ss, 8, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op51b8, DoSubL, DL, Ss, 8, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5300, DoSubB, DB, Ss, 1, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5310, DoSubB, DB, Ss, 1, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5318, DoSubB, DB, Ss, 1, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5320, DoSubB, DB, Ss, 1, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5328, DoSubB, DB, Ss, 1, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5330, DoSubB, DB, Ss, 1, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5338, DoSubB, DB, Ss, 1, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5340, DoSubW, DW, Ss, 1, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5348, DoSuba, DL, Ss, 1, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5350, DoSubW, DW, Ss, 1, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5358, DoSubW, DW, Ss, 1, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5360, DoSubW, DW, Ss, 1, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5368, DoSubW, DW, Ss, 1, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5370, DoSubW, DW, Ss, 1, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5378, DoSubW, DW, Ss, 1, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5380, DoSubL, DL, Ss, 1, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5388, DoSuba, DL, Ss, 1, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5390, DoSubL, DL, Ss, 1, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5398, DoSubL, DL, Ss, 1, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op53a0, DoSubL, DL, Ss, 1, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op53a8, DoSubL, DL, Ss, 1, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op53b0, DoSubL, DL, Ss, 1, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op53b8, DoSubL, DL, Ss, 1, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5500, DoSubB, DB, Ss, 2, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5510, DoSubB, DB, Ss, 2, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5518, DoSubB, DB, Ss, 2, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5520, DoSubB, DB, Ss, 2, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5528, DoSubB, DB, Ss, 2, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5530, DoSubB, DB, Ss, 2, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5538, DoSubB, DB, Ss, 2, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5540, DoSubW, DW, Ss, 2, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5548, DoSuba, DL, Ss, 2, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5550, DoSubW, DW, Ss, 2, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5558, DoSubW, DW, Ss, 2, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5560, DoSubW, DW, Ss, 2, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5568, DoSubW, DW, Ss, 2, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5570, DoSubW, DW, Ss, 2, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5578, DoSubW, DW, Ss, 2, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5580, DoSubL, DL, Ss, 2, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5588, DoSuba, DL, Ss, 2, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5590, DoSubL, DL, Ss, 2, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5598, DoSubL, DL, Ss, 2, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op55a0, DoSubL, DL, Ss, 2, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op55a8, DoSubL, DL, Ss, 2, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op55b0, DoSubL, DL, Ss, 2, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op55b8, DoSubL, DL, Ss, 2, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5700, DoSubB, DB, Ss, 3, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5710, DoSubB, DB, Ss, 3, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5718, DoSubB, DB, Ss, 3, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5720, DoSubB, DB, Ss, 3, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5728, DoSubB, DB, Ss, 3, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5730, DoSubB, DB, Ss, 3, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5738, DoSubB, DB, Ss, 3, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5740, DoSubW, DW, Ss, 3, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5748, DoSuba, DL, Ss, 3, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5750, DoSubW, DW, Ss, 3, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5758, DoSubW, DW, Ss, 3, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5760, DoSubW, DW, Ss, 3, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5768, DoSubW, DW, Ss, 3, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5770, DoSubW, DW, Ss, 3, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5778, DoSubW, DW, Ss, 3, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5780, DoSubL, DL, Ss, 3, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5788, DoSuba, DL, Ss, 3, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5790, DoSubL, DL, Ss, 3, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5798, DoSubL, DL, Ss, 3, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op57a0, DoSubL, DL, Ss, 3, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op57a8, DoSubL, DL, Ss, 3, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op57b0, DoSubL, DL, Ss, 3, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op57b8, DoSubL, DL, Ss, 3, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5900, DoSubB, DB, Ss, 4, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5910, DoSubB, DB, Ss, 4, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5918, DoSubB, DB, Ss, 4, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5920, DoSubB, DB, Ss, 4, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5928, DoSubB, DB, Ss, 4, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5930, DoSubB, DB, Ss, 4, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5938, DoSubB, DB, Ss, 4, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5940, DoSubW, DW, Ss, 4, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5948, DoSuba, DL, Ss, 4, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5950, DoSubW, DW, Ss, 4, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5958, DoSubW, DW, Ss, 4, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5960, DoSubW, DW, Ss, 4, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5968, DoSubW, DW, Ss, 4, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5970, DoSubW, DW, Ss, 4, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5978, DoSubW, DW, Ss, 4, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5980, DoSubL, DL, Ss, 4, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5988, DoSuba, DL, Ss, 4, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5990, DoSubL, DL, Ss, 4, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5998, DoSubL, DL, Ss, 4, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op59a0, DoSubL, DL, Ss, 4, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op59a8, DoSubL, DL, Ss, 4, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op59b0, DoSubL, DL, Ss, 4, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op59b8, DoSubL, DL, Ss, 4, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5b00, DoSubB, DB, Ss, 5, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5b10, DoSubB, DB, Ss, 5, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5b18, DoSubB, DB, Ss, 5, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5b20, DoSubB, DB, Ss, 5, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5b28, DoSubB, DB, Ss, 5, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5b30, DoSubB, DB, Ss, 5, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5b38, DoSubB, DB, Ss, 5, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5b40, DoSubW, DW, Ss, 5, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5b48, DoSuba, DL, Ss, 5, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5b50, DoSubW, DW, Ss, 5, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5b58, DoSubW, DW, Ss, 5, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5b60, DoSubW, DW, Ss, 5, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5b68, DoSubW, DW, Ss, 5, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5b70, DoSubW, DW, Ss, 5, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5b78, DoSubW, DW, Ss, 5, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5b80, DoSubL, DL, Ss, 5, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5b88, DoSuba, DL, Ss, 5, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5b90, DoSubL, DL, Ss, 5, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5b98, DoSubL, DL, Ss, 5, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5ba0, DoSubL, DL, Ss, 5, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5ba8, DoSubL, DL, Ss, 5, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5bb0, DoSubL, DL, Ss, 5, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5bb8, DoSubL, DL, Ss, 5, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5d00, DoSubB, DB, Ss, 6, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5d10, DoSubB, DB, Ss, 6, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5d18, DoSubB, DB, Ss, 6, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5d20, DoSubB, DB, Ss, 6, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5d28, DoSubB, DB, Ss, 6, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5d30, DoSubB, DB, Ss, 6, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5d38, DoSubB, DB, Ss, 6, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5d40, DoSubW, DW, Ss, 6, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5d48, DoSuba, DL, Ss, 6, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5d50, DoSubW, DW, Ss, 6, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5d58, DoSubW, DW, Ss, 6, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5d60, DoSubW, DW, Ss, 6, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5d68, DoSubW, DW, Ss, 6, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5d70, DoSubW, DW, Ss, 6, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5d78, DoSubW, DW, Ss, 6, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5d80, DoSubL, DL, Ss, 6, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5d88, DoSuba, DL, Ss, 6, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5d90, DoSubL, DL, Ss, 6, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5d98, DoSubL, DL, Ss, 6, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5da0, DoSubL, DL, Ss, 6, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5da8, DoSubL, DL, Ss, 6, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5db0, DoSubL, DL, Ss, 6, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5db8, DoSubL, DL, Ss, 6, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5f00, DoSubB, DB, Ss, 7, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5f10, DoSubB, DB, Ss, 7, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5f18, DoSubB, DB, Ss, 7, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5f20, DoSubB, DB, Ss, 7, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5f28, DoSubB, DB, Ss, 7, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5f30, DoSubB, DB, Ss, 7, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5f38, DoSubB, DB, Ss, 7, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5f40, DoSubW, DW, Ss, 7, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5f48, DoSuba, DL, Ss, 7, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5f50, DoSubW, DW, Ss, 7, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5f58, DoSubW, DW, Ss, 7, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5f60, DoSubW, DW, Ss, 7, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5f68, DoSubW, DW, Ss, 7, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5f70, DoSubW, DW, Ss, 7, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5f78, DoSubW, DW, Ss, 7, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5f80, DoSubL, DL, Ss, 7, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5f88, DoSuba, DL, Ss, 7, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5f90, DoSubL, DL, Ss, 7, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5f98, DoSubL, DL, Ss, 7, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5fa0, DoSubL, DL, Ss, 7, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5fa8, DoSubL, DL, Ss, 7, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5fb0, DoSubL, DL, Ss, 7, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5fb8, DoSubL, DL, Ss, 7, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
