/*
* Castaway
*  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
*
* $File$ - 68k move instructions
*
* This file is distributed under the GPL, version 2 or at your
* option any later version.  See doc/license.txt for details.
*
* revision history
*  23.05.2002  0.02.00 JH  FAST1.0.1 code import: KR -> ANSI, restructuring
*/
#ifndef PROTOH
static char     sccsid[] = "$Id: op68kmove.c,v 1.1.1.1 2002/05/25 23:04:30 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

#define DoMoveB(target,source) target = source; ClrCVSetNZ(target);
#define DoMoveW(target,source) target = source; ClrCVSetNZ(target);
#define DoMoveL(target,source) target = source; ClrCVSetNZ(target);

#define DoMovea(target,source) target = source;

#endif

Oper (Op1000, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 0, GN, SRB, 4)
Oper (Op1010, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 0, GN, SRB, 8)
Oper (Op1018, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 0, GN, SRB, 8)
Oper (Op1020, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 0, GN, SRB, 12)
Oper (Op1028, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 0, GN, SRB, 12)
Oper (Op1030, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 0, GN, SRB, 16)
Oper (Op1038, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 0, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1080, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 0, GN, SMB, 8)
Oper (Op1090, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 0, GN, SMB, 12)
Oper (Op1098, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 0, GN, SMB, 12)
Oper (Op10a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 0, GN, SMB, 16)
Oper (Op10a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 0, GN, SMB, 16)
Oper (Op10b0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 0, GN, SMB, 20)
Oper (Op10b8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 0, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op10c0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 0, GN, SMB, 8)
Oper (Op10d0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 0, GN, SMB, 12)
Oper (Op10d8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 0, GN, SMB, 12)
Oper (Op10e0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 0, GN, SMB, 16)
Oper (Op10e8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 0, GN, SMB, 16)
Oper (Op10f0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 0, GN, SMB, 20)
Oper (Op10f8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 0, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1100, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 0, GN, SMB, 12)
Oper (Op1110, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 0, GN, SMB, 16)
Oper (Op1118, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 0, GN, SMB, 16)
Oper (Op1120, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 0, GN, SMB, 16)
Oper (Op1128, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 0, GN, SMB, 20)
Oper (Op1130, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 0, GN, SMB, 20)
Oper (Op1138, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 0, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1140, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 0, GN, SMB, 12)
Oper (Op1150, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 0, GN, SMB, 16)
Oper (Op1158, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 0, GN, SMB, 16)
Oper (Op1160, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 0, GN, SMB, 20)
Oper (Op1168, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 0, GN, SMB, 20)
Oper (Op1170, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 0, GN, SMB, 24)
Oper (Op1178, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 0, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1180, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 0, GN, SMB, 16)
Oper (Op1190, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 0, GN, SMB, 20)
Oper (Op1198, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 0, GN, SMB, 20)
Oper (Op11a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 0, GN, SMB, 20)
Oper (Op11a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 0, GN, SMB, 24)
Oper (Op11b0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 0, GN, SMB, 24)
Oper (Op11b8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 0, GN, SMB, (cycles+21)&0xfffffffc)
Oper (Op11c0, DoMoveB, DB, SdB, ins7, DB, DA, Feaw, 0, GN, SMB, 12)
Oper (Op11d0, DoMoveB, DB, SainB, ins7, DB, DA, Feaw, 0, GN, SMB, 16)
Oper (Op11d8, DoMoveB, DB, SaipB, ins7, DB, DA, Feaw, 0, GN, SMB, 16)
Oper (Op11e0, DoMoveB, DB, SmaiB, ins7, DB, DA, Feaw, 0, GN, SMB, 20)
Oper (Op11e8, DoMoveB, DB, SdaiB, ins7, DB, DA, Ceaw, 0, GN, SMB, 20)
Oper (Op11f0, DoMoveB, DB, SaixB, ins7, DB, DA, Ceaw, 0, GN, SMB, 24)
Oper (Op11f8, DoMoveB, DB, SearB, ins7, DB, DA, Ceaw, 0, GN, SMB, (cycles+19)&0xfffffffc)

Oper (Op1200, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 1, GN, SRB, 4)
Oper (Op1210, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 1, GN, SRB, 8)
Oper (Op1218, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 1, GN, SRB, 8)
Oper (Op1220, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 1, GN, SRB, 12)
Oper (Op1228, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 1, GN, SRB, 12)
Oper (Op1230, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 1, GN, SRB, 16)
Oper (Op1238, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 1, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1280, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 1, GN, SMB, 8)
Oper (Op1290, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 1, GN, SMB, 12)
Oper (Op1298, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 1, GN, SMB, 12)
Oper (Op12a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 1, GN, SMB, 16)
Oper (Op12a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 1, GN, SMB, 16)
Oper (Op12b0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 1, GN, SMB, 20)
Oper (Op12b8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 1, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op12c0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 1, GN, SMB, 8)
Oper (Op12d0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 1, GN, SMB, 12)
Oper (Op12d8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 1, GN, SMB, 12)
Oper (Op12e0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 1, GN, SMB, 16)
Oper (Op12e8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 1, GN, SMB, 16)
Oper (Op12f0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 1, GN, SMB, 20)
Oper (Op12f8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 1, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1300, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 1, GN, SMB, 12)
Oper (Op1310, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 1, GN, SMB, 16)
Oper (Op1318, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 1, GN, SMB, 16)
Oper (Op1320, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 1, GN, SMB, 16)
Oper (Op1328, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 1, GN, SMB, 20)
Oper (Op1330, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 1, GN, SMB, 20)
Oper (Op1338, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 1, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1340, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 1, GN, SMB, 12)
Oper (Op1350, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 1, GN, SMB, 16)
Oper (Op1358, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 1, GN, SMB, 16)
Oper (Op1360, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 1, GN, SMB, 20)
Oper (Op1368, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 1, GN, SMB, 20)
Oper (Op1370, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 1, GN, SMB, 24)
Oper (Op1378, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 1, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1380, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 1, GN, SMB, 16)
Oper (Op1390, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 1, GN, SMB, 20)
Oper (Op1398, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 1, GN, SMB, 20)
Oper (Op13a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 1, GN, SMB, 20)
Oper (Op13a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 1, GN, SMB, 24)
Oper (Op13b0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 1, GN, SMB, 24)
Oper (Op13b8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 1, GN, SMB, (cycles+21)&0xfffffffc)
Oper (Op13c0, DoMoveB, DB, SdB, ins7, DB, DA, Feaw, 1, GN, SMB, 16)
Oper (Op13d0, DoMoveB, DB, SainB, ins7, DB, DA, Feaw, 1, GN, SMB, 20)
Oper (Op13d8, DoMoveB, DB, SaipB, ins7, DB, DA, Feaw, 1, GN, SMB, 20)
Oper (Op13e0, DoMoveB, DB, SmaiB, ins7, DB, DA, Feaw, 1, GN, SMB, 24)
Oper (Op13e8, DoMoveB, DB, SdaiB, ins7, DB, DA, Ceaw, 1, GN, SMB, 24)
Oper (Op13f0, DoMoveB, DB, SaixB, ins7, DB, DA, Ceaw, 1, GN, SMB, 28)
Oper (Op13f8, DoMoveB, DB, SearB, ins7, DB, DA, Ceaw, 1, GN, SMB, (cycles+23)&0xfffffffc)

Oper (Op1400, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 2, GN, SRB, 4)
Oper (Op1410, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 2, GN, SRB, 8)
Oper (Op1418, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 2, GN, SRB, 8)
Oper (Op1420, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 2, GN, SRB, 12)
Oper (Op1428, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 2, GN, SRB, 12)
Oper (Op1430, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 2, GN, SRB, 16)
Oper (Op1438, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 2, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1480, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 2, GN, SMB, 8)
Oper (Op1490, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 2, GN, SMB, 12)
Oper (Op1498, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 2, GN, SMB, 12)
Oper (Op14a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 2, GN, SMB, 16)
Oper (Op14a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 2, GN, SMB, 16)
Oper (Op14b0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 2, GN, SMB, 20)
Oper (Op14b8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 2, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op14c0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 2, GN, SMB, 8)
Oper (Op14d0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 2, GN, SMB, 12)
Oper (Op14d8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 2, GN, SMB, 12)
Oper (Op14e0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 2, GN, SMB, 16)
Oper (Op14e8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 2, GN, SMB, 16)
Oper (Op14f0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 2, GN, SMB, 20)
Oper (Op14f8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 2, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1500, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 2, GN, SMB, 12)
Oper (Op1510, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 2, GN, SMB, 16)
Oper (Op1518, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 2, GN, SMB, 16)
Oper (Op1520, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 2, GN, SMB, 16)
Oper (Op1528, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 2, GN, SMB, 20)
Oper (Op1530, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 2, GN, SMB, 20)
Oper (Op1538, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 2, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1540, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 2, GN, SMB, 12)
Oper (Op1550, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 2, GN, SMB, 16)
Oper (Op1558, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 2, GN, SMB, 16)
Oper (Op1560, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 2, GN, SMB, 20)
Oper (Op1568, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 2, GN, SMB, 20)
Oper (Op1570, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 2, GN, SMB, 24)
Oper (Op1578, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 2, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1580, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 2, GN, SMB, 16)
Oper (Op1590, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 2, GN, SMB, 20)
Oper (Op1598, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 2, GN, SMB, 20)
Oper (Op15a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 2, GN, SMB, 20)
Oper (Op15a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 2, GN, SMB, 24)
Oper (Op15b0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 2, GN, SMB, 24)
Oper (Op15b8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 2, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op1600, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 3, GN, SRB, 4)
Oper (Op1610, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 3, GN, SRB, 8)
Oper (Op1618, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 3, GN, SRB, 8)
Oper (Op1620, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 3, GN, SRB, 12)
Oper (Op1628, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 3, GN, SRB, 12)
Oper (Op1630, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 3, GN, SRB, 16)
Oper (Op1638, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 3, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1680, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 3, GN, SMB, 8)
Oper (Op1690, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 3, GN, SMB, 12)
Oper (Op1698, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 3, GN, SMB, 12)
Oper (Op16a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 3, GN, SMB, 16)
Oper (Op16a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 3, GN, SMB, 16)
Oper (Op16b0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 3, GN, SMB, 20)
Oper (Op16b8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 3, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op16c0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 3, GN, SMB, 8)
Oper (Op16d0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 3, GN, SMB, 12)
Oper (Op16d8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 3, GN, SMB, 12)
Oper (Op16e0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 3, GN, SMB, 16)
Oper (Op16e8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 3, GN, SMB, 16)
Oper (Op16f0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 3, GN, SMB, 20)
Oper (Op16f8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 3, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1700, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 3, GN, SMB, 12)
Oper (Op1710, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 3, GN, SMB, 16)
Oper (Op1718, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 3, GN, SMB, 16)
Oper (Op1720, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 3, GN, SMB, 16)
Oper (Op1728, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 3, GN, SMB, 20)
Oper (Op1730, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 3, GN, SMB, 20)
Oper (Op1738, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 3, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1740, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 3, GN, SMB, 12)
Oper (Op1750, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 3, GN, SMB, 16)
Oper (Op1758, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 3, GN, SMB, 16)
Oper (Op1760, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 3, GN, SMB, 20)
Oper (Op1768, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 3, GN, SMB, 20)
Oper (Op1770, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 3, GN, SMB, 24)
Oper (Op1778, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 3, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1780, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 3, GN, SMB, 16)
Oper (Op1790, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 3, GN, SMB, 20)
Oper (Op1798, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 3, GN, SMB, 20)
Oper (Op17a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 3, GN, SMB, 20)
Oper (Op17a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 3, GN, SMB, 24)
Oper (Op17b0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 3, GN, SMB, 24)
Oper (Op17b8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 3, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op1800, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 4, GN, SRB, 4)
Oper (Op1810, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 4, GN, SRB, 8)
Oper (Op1818, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 4, GN, SRB, 8)
Oper (Op1820, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 4, GN, SRB, 12)
Oper (Op1828, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 4, GN, SRB, 12)
Oper (Op1830, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 4, GN, SRB, 16)
Oper (Op1838, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 4, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1880, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 4, GN, SMB, 8)
Oper (Op1890, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 4, GN, SMB, 12)
Oper (Op1898, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 4, GN, SMB, 12)
Oper (Op18a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 4, GN, SMB, 16)
Oper (Op18a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 4, GN, SMB, 16)
Oper (Op18b0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 4, GN, SMB, 20)
Oper (Op18b8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 4, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op18c0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 4, GN, SMB, 8)
Oper (Op18d0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 4, GN, SMB, 12)
Oper (Op18d8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 4, GN, SMB, 12)
Oper (Op18e0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 4, GN, SMB, 16)
Oper (Op18e8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 4, GN, SMB, 16)
Oper (Op18f0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 4, GN, SMB, 20)
Oper (Op18f8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 4, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1900, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 4, GN, SMB, 12)
Oper (Op1910, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 4, GN, SMB, 16)
Oper (Op1918, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 4, GN, SMB, 16)
Oper (Op1920, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 4, GN, SMB, 16)
Oper (Op1928, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 4, GN, SMB, 20)
Oper (Op1930, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 4, GN, SMB, 20)
Oper (Op1938, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 4, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1940, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 4, GN, SMB, 12)
Oper (Op1950, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 4, GN, SMB, 16)
Oper (Op1958, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 4, GN, SMB, 16)
Oper (Op1960, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 4, GN, SMB, 20)
Oper (Op1968, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 4, GN, SMB, 20)
Oper (Op1970, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 4, GN, SMB, 24)
Oper (Op1978, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 4, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1980, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 4, GN, SMB, 16)
Oper (Op1990, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 4, GN, SMB, 20)
Oper (Op1998, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 4, GN, SMB, 20)
Oper (Op19a0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 4, GN, SMB, 20)
Oper (Op19a8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 4, GN, SMB, 24)
Oper (Op19b0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 4, GN, SMB, 24)
Oper (Op19b8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 4, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op1a00, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 5, GN, SRB, 4)
Oper (Op1a10, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 5, GN, SRB, 8)
Oper (Op1a18, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 5, GN, SRB, 8)
Oper (Op1a20, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 5, GN, SRB, 12)
Oper (Op1a28, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 5, GN, SRB, 12)
Oper (Op1a30, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 5, GN, SRB, 16)
Oper (Op1a38, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 5, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1a80, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 5, GN, SMB, 8)
Oper (Op1a90, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 5, GN, SMB, 12)
Oper (Op1a98, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 5, GN, SMB, 12)
Oper (Op1aa0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 5, GN, SMB, 16)
Oper (Op1aa8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 5, GN, SMB, 16)
Oper (Op1ab0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 5, GN, SMB, 20)
Oper (Op1ab8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 5, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1ac0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 5, GN, SMB, 8)
Oper (Op1ad0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 5, GN, SMB, 12)
Oper (Op1ad8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 5, GN, SMB, 12)
Oper (Op1ae0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 5, GN, SMB, 16)
Oper (Op1ae8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 5, GN, SMB, 16)
Oper (Op1af0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 5, GN, SMB, 20)
Oper (Op1af8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 5, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1b00, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 5, GN, SMB, 12)
Oper (Op1b10, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 5, GN, SMB, 16)
Oper (Op1b18, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 5, GN, SMB, 16)
Oper (Op1b20, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 5, GN, SMB, 16)
Oper (Op1b28, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 5, GN, SMB, 20)
Oper (Op1b30, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 5, GN, SMB, 20)
Oper (Op1b38, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 5, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1b40, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 5, GN, SMB, 12)
Oper (Op1b50, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 5, GN, SMB, 16)
Oper (Op1b58, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 5, GN, SMB, 16)
Oper (Op1b60, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 5, GN, SMB, 20)
Oper (Op1b68, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 5, GN, SMB, 20)
Oper (Op1b70, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 5, GN, SMB, 24)
Oper (Op1b78, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 5, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1b80, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 5, GN, SMB, 16)
Oper (Op1b90, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 5, GN, SMB, 20)
Oper (Op1b98, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 5, GN, SMB, 20)
Oper (Op1ba0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 5, GN, SMB, 20)
Oper (Op1ba8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 5, GN, SMB, 24)
Oper (Op1bb0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 5, GN, SMB, 24)
Oper (Op1bb8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 5, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op1c00, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 6, GN, SRB, 4)
Oper (Op1c10, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 6, GN, SRB, 8)
Oper (Op1c18, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 6, GN, SRB, 8)
Oper (Op1c20, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 6, GN, SRB, 12)
Oper (Op1c28, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 6, GN, SRB, 12)
Oper (Op1c30, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 6, GN, SRB, 16)
Oper (Op1c38, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 6, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1c80, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 6, GN, SMB, 8)
Oper (Op1c90, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 6, GN, SMB, 12)
Oper (Op1c98, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 6, GN, SMB, 12)
Oper (Op1ca0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 6, GN, SMB, 16)
Oper (Op1ca8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 6, GN, SMB, 16)
Oper (Op1cb0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 6, GN, SMB, 20)
Oper (Op1cb8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 6, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1cc0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB, 6, GN, SMB, 8)
Oper (Op1cd0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB, 6, GN, SMB, 12)
Oper (Op1cd8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB, 6, GN, SMB, 12)
Oper (Op1ce0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB, 6, GN, SMB, 16)
Oper (Op1ce8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB, 6, GN, SMB, 16)
Oper (Op1cf0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB, 6, GN, SMB, 20)
Oper (Op1cf8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB, 6, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1d00, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB, 6, GN, SMB, 12)
Oper (Op1d10, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB, 6, GN, SMB, 16)
Oper (Op1d18, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB, 6, GN, SMB, 16)
Oper (Op1d20, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB, 6, GN, SMB, 16)
Oper (Op1d28, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB, 6, GN, SMB, 20)
Oper (Op1d30, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB, 6, GN, SMB, 20)
Oper (Op1d38, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB, 6, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1d40, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 6, GN, SMB, 12)
Oper (Op1d50, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 6, GN, SMB, 16)
Oper (Op1d58, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 6, GN, SMB, 16)
Oper (Op1d60, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 6, GN, SMB, 20)
Oper (Op1d68, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 6, GN, SMB, 20)
Oper (Op1d70, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 6, GN, SMB, 24)
Oper (Op1d78, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 6, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1d80, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 6, GN, SMB, 16)
Oper (Op1d90, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 6, GN, SMB, 20)
Oper (Op1d98, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 6, GN, SMB, 20)
Oper (Op1da0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 6, GN, SMB, 20)
Oper (Op1da8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 6, GN, SMB, 24)
Oper (Op1db0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 6, GN, SMB, 24)
Oper (Op1db8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 6, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op1e00, DoMoveB, DB, SdB, ins7, DB, DR, Cd, 7, GN, SRB, 4)
Oper (Op1e10, DoMoveB, DB, SainB, ins7, DB, DR, Cd, 7, GN, SRB, 8)
Oper (Op1e18, DoMoveB, DB, SaipB, ins7, DB, DR, Cd, 7, GN, SRB, 8)
Oper (Op1e20, DoMoveB, DB, SmaiB, ins7, DB, DR, Cd, 7, GN, SRB, 12)
Oper (Op1e28, DoMoveB, DB, SdaiB, ins7, DB, DR, Cd, 7, GN, SRB, 12)
Oper (Op1e30, DoMoveB, DB, SaixB, ins7, DB, DR, Cd, 7, GN, SRB, 16)
Oper (Op1e38, DoMoveB, DB, SearB, ins7, DB, DR, Cd, 7, GN, SRB, (cycles+11)&0xfffffffc)
Oper (Op1e80, DoMoveB, DB, SdB, ins7, DB, DA, Cain, 7, GN, SMB, 8)
Oper (Op1e90, DoMoveB, DB, SainB, ins7, DB, DA, Cain, 7, GN, SMB, 12)
Oper (Op1e98, DoMoveB, DB, SaipB, ins7, DB, DA, Cain, 7, GN, SMB, 12)
Oper (Op1ea0, DoMoveB, DB, SmaiB, ins7, DB, DA, Cain, 7, GN, SMB, 16)
Oper (Op1ea8, DoMoveB, DB, SdaiB, ins7, DB, DA, Cain, 7, GN, SMB, 16)
Oper (Op1eb0, DoMoveB, DB, SaixB, ins7, DB, DA, Cain, 7, GN, SMB, 20)
Oper (Op1eb8, DoMoveB, DB, SearB, ins7, DB, DA, Cain, 7, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1ec0, DoMoveB, DB, SdB, ins7, DB, DA, CaipB15, 7, GN, SMB, 8)
Oper (Op1ed0, DoMoveB, DB, SainB, ins7, DB, DA, CaipB15, 7, GN, SMB, 12)
Oper (Op1ed8, DoMoveB, DB, SaipB, ins7, DB, DA, CaipB15, 7, GN, SMB, 12)
Oper (Op1ee0, DoMoveB, DB, SmaiB, ins7, DB, DA, CaipB15, 7, GN, SMB, 16)
Oper (Op1ee8, DoMoveB, DB, SdaiB, ins7, DB, DA, CaipB15, 7, GN, SMB, 16)
Oper (Op1ef0, DoMoveB, DB, SaixB, ins7, DB, DA, CaipB15, 7, GN, SMB, 20)
Oper (Op1ef8, DoMoveB, DB, SearB, ins7, DB, DA, CaipB15, 7, GN, SMB, (cycles+15)&0xfffffffc)
Oper (Op1f00, DoMoveB, DB, SdB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 12)
Oper (Op1f10, DoMoveB, DB, SainB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 16)
Oper (Op1f18, DoMoveB, DB, SaipB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 16)
Oper (Op1f20, DoMoveB, DB, SmaiB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 16)
Oper (Op1f28, DoMoveB, DB, SdaiB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 20)
Oper (Op1f30, DoMoveB, DB, SaixB, ins7, DB, DA, CmaiB15, 7, GN, SMB, 20)
Oper (Op1f38, DoMoveB, DB, SearB, ins7, DB, DA, CmaiB15, 7, GN, SMB, (cycles+17)&0xfffffffc)
Oper (Op1f40, DoMoveB, DB, SdB, ins7, DB, DA, Fdai, 7, GN, SMB, 12)
Oper (Op1f50, DoMoveB, DB, SainB, ins7, DB, DA, Fdai, 7, GN, SMB, 16)
Oper (Op1f58, DoMoveB, DB, SaipB, ins7, DB, DA, Fdai, 7, GN, SMB, 16)
Oper (Op1f60, DoMoveB, DB, SmaiB, ins7, DB, DA, Fdai, 7, GN, SMB, 20)
Oper (Op1f68, DoMoveB, DB, SdaiB, ins7, DB, DA, Cdai, 7, GN, SMB, 20)
Oper (Op1f70, DoMoveB, DB, SaixB, ins7, DB, DA, Cdai, 7, GN, SMB, 24)
Oper (Op1f78, DoMoveB, DB, SearB, ins7, DB, DA, Cdai, 7, GN, SMB, (cycles+19)&0xfffffffc)
Oper (Op1f80, DoMoveB, DB, SdB, ins7, DB, DA, Faix, 7, GN, SMB, 16)
Oper (Op1f90, DoMoveB, DB, SainB, ins7, DB, DA, Faix, 7, GN, SMB, 20)
Oper (Op1f98, DoMoveB, DB, SaipB, ins7, DB, DA, Faix, 7, GN, SMB, 20)
Oper (Op1fa0, DoMoveB, DB, SmaiB, ins7, DB, DA, Faix, 7, GN, SMB, 20)
Oper (Op1fa8, DoMoveB, DB, SdaiB, ins7, DB, DA, Caix, 7, GN, SMB, 24)
Oper (Op1fb0, DoMoveB, DB, SaixB, ins7, DB, DA, Caix, 7, GN, SMB, 24)
Oper (Op1fb8, DoMoveB, DB, SearB, ins7, DB, DA, Caix, 7, GN, SMB, (cycles+21)&0xfffffffc)

Oper (Op2000, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 0, GN, SRL, 4)
Oper (Op2008, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 0, GN, SRL, 4)
Oper (Op2010, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 0, GN, SRL, 12)
Oper (Op2018, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 0, GN, SRL, 12)
Oper (Op2020, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 0, GN, SRL, 16)
Oper (Op2028, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 0, GN, SRL, 16)
Oper (Op2030, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 0, GN, SRL, 20)
Oper (Op2038, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 0, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2040, DoMovea, DL, SdL, ins7, DL, DR, Ca, 0, GN, SRL, 4)
Oper (Op2048, DoMovea, DL, SaL, ins7, DL, DR, Ca, 0, GN, SRL, 4)
Oper (Op2050, DoMovea, DL, SainL, ins7, DL, DR, Ca, 0, GN, SRL, 12)
Oper (Op2058, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 0, GN, SRL, 12)
Oper (Op2060, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 0, GN, SRL, 16)
Oper (Op2068, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 0, GN, SRL, 16)
Oper (Op2070, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 0, GN, SRL, 20)
Oper (Op2078, DoMovea, DL, SearL, ins7, DL, DR, Ca, 0, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2080, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 0, GN, SML, 12)
Oper (Op2088, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 0, GN, SML, 12)
Oper (Op2090, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 0, GN, SML, 20)
Oper (Op2098, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 0, GN, SML, 20)
Oper (Op20a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 0, GN, SML, 24)
Oper (Op20a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 0, GN, SML, 24)
Oper (Op20b0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 0, GN, SML, 28)
Oper (Op20b8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 0, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op20c0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 0, GN, SML, 12)
Oper (Op20c8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 0, GN, SML, 12)
Oper (Op20d0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 0, GN, SML, 20)
Oper (Op20d8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 0, GN, SML, 20)
Oper (Op20e0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 0, GN, SML, 24)
Oper (Op20e8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 0, GN, SML, 24)
Oper (Op20f0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 0, GN, SML, 28)
Oper (Op20f8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 0, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2100, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 0, GN, SML, 16)
Oper (Op2108, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 0, GN, SML, 16)
Oper (Op2110, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 0, GN, SML, 24)
Oper (Op2118, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 0, GN, SML, 24)
Oper (Op2120, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 0, GN, SML, 24)
Oper (Op2128, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 0, GN, SML, 28)
Oper (Op2130, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 0, GN, SML, 28)
Oper (Op2138, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 0, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2140, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 0, GN, SML, 16)
Oper (Op2148, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 0, GN, SML, 16)
Oper (Op2150, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 0, GN, SML, 24)
Oper (Op2158, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 0, GN, SML, 24)
Oper (Op2160, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 0, GN, SML, 28)
Oper (Op2168, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 0, GN, SML, 28)
Oper (Op2170, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 0, GN, SML, 32)
Oper (Op2178, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 0, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2180, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 0, GN, SML, 20)
Oper (Op2188, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 0, GN, SML, 20)
Oper (Op2190, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 0, GN, SML, 28)
Oper (Op2198, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 0, GN, SML, 28)
Oper (Op21a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 0, GN, SML, 28)
Oper (Op21a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 0, GN, SML, 32)
Oper (Op21b0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 0, GN, SML, 32)
Oper (Op21b8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 0, GN, SML, (cycles+29)&0xfffffffc)
Oper (Op21c0, DoMoveL, DL, SdL, ins7, DL, DA, Feaw, 0, GN, SML, 16)
Oper (Op21c8, DoMoveL, DL, SaL, ins7, DL, DA, Feaw, 0, GN, SML, 16)
Oper (Op21d0, DoMoveL, DL, SainL, ins7, DL, DA, Feaw, 0, GN, SML, 24)
Oper (Op21d8, DoMoveL, DL, SaipL, ins7, DL, DA, Feaw, 0, GN, SML, 24)
Oper (Op21e0, DoMoveL, DL, SmaiL, ins7, DL, DA, Feaw, 0, GN, SML, 28)
Oper (Op21e8, DoMoveL, DL, SdaiL, ins7, DL, DA, Ceaw, 0, GN, SML, 28)
Oper (Op21f0, DoMoveL, DL, SaixL, ins7, DL, DA, Ceaw, 0, GN, SML, 32)
Oper (Op21f8, DoMoveL, DL, SearL, ins7, DL, DA, Ceaw, 0, GN, SML, (cycles+27)&0xfffffffc)

Oper (Op2200, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 1, GN, SRL, 4)
Oper (Op2208, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 1, GN, SRL, 4)
Oper (Op2210, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 1, GN, SRL, 12)
Oper (Op2218, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 1, GN, SRL, 12)
Oper (Op2220, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 1, GN, SRL, 16)
Oper (Op2228, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 1, GN, SRL, 16)
Oper (Op2230, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 1, GN, SRL, 20)
Oper (Op2238, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 1, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2240, DoMovea, DL, SdL, ins7, DL, DR, Ca, 1, GN, SRL, 4)
Oper (Op2248, DoMovea, DL, SaL, ins7, DL, DR, Ca, 1, GN, SRL, 4)
Oper (Op2250, DoMovea, DL, SainL, ins7, DL, DR, Ca, 1, GN, SRL, 12)
Oper (Op2258, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 1, GN, SRL, 12)
Oper (Op2260, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 1, GN, SRL, 16)
Oper (Op2268, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 1, GN, SRL, 16)
Oper (Op2270, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 1, GN, SRL, 20)
Oper (Op2278, DoMovea, DL, SearL, ins7, DL, DR, Ca, 1, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2280, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 1, GN, SML, 12)
Oper (Op2288, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 1, GN, SML, 12)
Oper (Op2290, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 1, GN, SML, 20)
Oper (Op2298, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 1, GN, SML, 20)
Oper (Op22a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 1, GN, SML, 24)
Oper (Op22a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 1, GN, SML, 24)
Oper (Op22b0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 1, GN, SML, 28)
Oper (Op22b8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 1, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op22c0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 1, GN, SML, 12)
Oper (Op22c8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 1, GN, SML, 12)
Oper (Op22d0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 1, GN, SML, 20)
Oper (Op22d8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 1, GN, SML, 20)
Oper (Op22e0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 1, GN, SML, 24)
Oper (Op22e8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 1, GN, SML, 24)
Oper (Op22f0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 1, GN, SML, 28)
Oper (Op22f8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 1, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2300, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 1, GN, SML, 16)
Oper (Op2308, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 1, GN, SML, 16)
Oper (Op2310, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 1, GN, SML, 24)
Oper (Op2318, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 1, GN, SML, 24)
Oper (Op2320, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 1, GN, SML, 24)
Oper (Op2328, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 1, GN, SML, 28)
Oper (Op2330, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 1, GN, SML, 28)
Oper (Op2338, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 1, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2340, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 1, GN, SML, 16)
Oper (Op2348, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 1, GN, SML, 16)
Oper (Op2350, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 1, GN, SML, 24)
Oper (Op2358, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 1, GN, SML, 24)
Oper (Op2360, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 1, GN, SML, 28)
Oper (Op2368, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 1, GN, SML, 28)
Oper (Op2370, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 1, GN, SML, 32)
Oper (Op2378, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 1, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2380, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 1, GN, SML, 20)
Oper (Op2388, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 1, GN, SML, 20)
Oper (Op2390, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 1, GN, SML, 28)
Oper (Op2398, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 1, GN, SML, 28)
Oper (Op23a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 1, GN, SML, 28)
Oper (Op23a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 1, GN, SML, 32)
Oper (Op23b0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 1, GN, SML, 32)
Oper (Op23b8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 1, GN, SML, (cycles+29)&0xfffffffc)
Oper (Op23c0, DoMoveL, DL, SdL, ins7, DL, DA, Feaw, 1, GN, SML, 20)
Oper (Op23c8, DoMoveL, DL, SaL, ins7, DL, DA, Feaw, 1, GN, SML, 20)
Oper (Op23d0, DoMoveL, DL, SainL, ins7, DL, DA, Feaw, 1, GN, SML, 28)
Oper (Op23d8, DoMoveL, DL, SaipL, ins7, DL, DA, Feaw, 1, GN, SML, 28)
Oper (Op23e0, DoMoveL, DL, SmaiL, ins7, DL, DA, Feaw, 1, GN, SML, 32)
Oper (Op23e8, DoMoveL, DL, SdaiL, ins7, DL, DA, Ceaw, 1, GN, SML, 32)
Oper (Op23f0, DoMoveL, DL, SaixL, ins7, DL, DA, Ceaw, 1, GN, SML, 36)
Oper (Op23f8, DoMoveL, DL, SearL, ins7, DL, DA, Ceaw, 1, GN, SML, (cycles+31)&0xfffffffc)

Oper (Op2400, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 2, GN, SRL, 4)
Oper (Op2408, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 2, GN, SRL, 4)
Oper (Op2410, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 2, GN, SRL, 12)
Oper (Op2418, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 2, GN, SRL, 12)
Oper (Op2420, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 2, GN, SRL, 16)
Oper (Op2428, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 2, GN, SRL, 16)
Oper (Op2430, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 2, GN, SRL, 20)
Oper (Op2438, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 2, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2440, DoMovea, DL, SdL, ins7, DL, DR, Ca, 2, GN, SRL, 4)
Oper (Op2448, DoMovea, DL, SaL, ins7, DL, DR, Ca, 2, GN, SRL, 4)
Oper (Op2450, DoMovea, DL, SainL, ins7, DL, DR, Ca, 2, GN, SRL, 12)
Oper (Op2458, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 2, GN, SRL, 12)
Oper (Op2460, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 2, GN, SRL, 16)
Oper (Op2468, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 2, GN, SRL, 16)
Oper (Op2470, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 2, GN, SRL, 20)
Oper (Op2478, DoMovea, DL, SearL, ins7, DL, DR, Ca, 2, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2480, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 2, GN, SML, 12)
Oper (Op2488, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 2, GN, SML, 12)
Oper (Op2490, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 2, GN, SML, 20)
Oper (Op2498, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 2, GN, SML, 20)
Oper (Op24a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 2, GN, SML, 24)
Oper (Op24a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 2, GN, SML, 24)
Oper (Op24b0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 2, GN, SML, 28)
Oper (Op24b8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 2, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op24c0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 2, GN, SML, 12)
Oper (Op24c8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 2, GN, SML, 12)
Oper (Op24d0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 2, GN, SML, 20)
Oper (Op24d8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 2, GN, SML, 20)
Oper (Op24e0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 2, GN, SML, 24)
Oper (Op24e8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 2, GN, SML, 24)
Oper (Op24f0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 2, GN, SML, 28)
Oper (Op24f8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 2, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2500, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 2, GN, SML, 16)
Oper (Op2508, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 2, GN, SML, 16)
Oper (Op2510, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 2, GN, SML, 24)
Oper (Op2518, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 2, GN, SML, 24)
Oper (Op2520, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 2, GN, SML, 24)
Oper (Op2528, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 2, GN, SML, 28)
Oper (Op2530, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 2, GN, SML, 28)
Oper (Op2538, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 2, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2540, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 2, GN, SML, 16)
Oper (Op2548, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 2, GN, SML, 16)
Oper (Op2550, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 2, GN, SML, 24)
Oper (Op2558, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 2, GN, SML, 24)
Oper (Op2560, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 2, GN, SML, 28)
Oper (Op2568, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 2, GN, SML, 28)
Oper (Op2570, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 2, GN, SML, 32)
Oper (Op2578, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 2, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2580, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 2, GN, SML, 20)
Oper (Op2588, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 2, GN, SML, 20)
Oper (Op2590, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 2, GN, SML, 28)
Oper (Op2598, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 2, GN, SML, 28)
Oper (Op25a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 2, GN, SML, 28)
Oper (Op25a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 2, GN, SML, 32)
Oper (Op25b0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 2, GN, SML, 32)
Oper (Op25b8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 2, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op2600, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 3, GN, SRL, 4)
Oper (Op2608, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 3, GN, SRL, 4)
Oper (Op2610, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 3, GN, SRL, 12)
Oper (Op2618, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 3, GN, SRL, 12)
Oper (Op2620, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 3, GN, SRL, 16)
Oper (Op2628, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 3, GN, SRL, 16)
Oper (Op2630, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 3, GN, SRL, 20)
Oper (Op2638, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 3, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2640, DoMovea, DL, SdL, ins7, DL, DR, Ca, 3, GN, SRL, 4)
Oper (Op2648, DoMovea, DL, SaL, ins7, DL, DR, Ca, 3, GN, SRL, 4)
Oper (Op2650, DoMovea, DL, SainL, ins7, DL, DR, Ca, 3, GN, SRL, 12)
Oper (Op2658, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 3, GN, SRL, 12)
Oper (Op2660, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 3, GN, SRL, 16)
Oper (Op2668, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 3, GN, SRL, 16)
Oper (Op2670, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 3, GN, SRL, 20)
Oper (Op2678, DoMovea, DL, SearL, ins7, DL, DR, Ca, 3, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2680, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 3, GN, SML, 12)
Oper (Op2688, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 3, GN, SML, 12)
Oper (Op2690, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 3, GN, SML, 20)
Oper (Op2698, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 3, GN, SML, 20)
Oper (Op26a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 3, GN, SML, 24)
Oper (Op26a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 3, GN, SML, 24)
Oper (Op26b0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 3, GN, SML, 28)
Oper (Op26b8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 3, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op26c0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 3, GN, SML, 12)
Oper (Op26c8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 3, GN, SML, 12)
Oper (Op26d0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 3, GN, SML, 20)
Oper (Op26d8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 3, GN, SML, 20)
Oper (Op26e0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 3, GN, SML, 24)
Oper (Op26e8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 3, GN, SML, 24)
Oper (Op26f0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 3, GN, SML, 28)
Oper (Op26f8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 3, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2700, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 3, GN, SML, 16)
Oper (Op2708, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 3, GN, SML, 16)
Oper (Op2710, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 3, GN, SML, 24)
Oper (Op2718, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 3, GN, SML, 24)
Oper (Op2720, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 3, GN, SML, 24)
Oper (Op2728, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 3, GN, SML, 28)
Oper (Op2730, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 3, GN, SML, 28)
Oper (Op2738, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 3, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2740, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 3, GN, SML, 16)
Oper (Op2748, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 3, GN, SML, 16)
Oper (Op2750, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 3, GN, SML, 24)
Oper (Op2758, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 3, GN, SML, 24)
Oper (Op2760, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 3, GN, SML, 28)
Oper (Op2768, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 3, GN, SML, 28)
Oper (Op2770, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 3, GN, SML, 32)
Oper (Op2778, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 3, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2780, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 3, GN, SML, 20)
Oper (Op2788, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 3, GN, SML, 20)
Oper (Op2790, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 3, GN, SML, 28)
Oper (Op2798, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 3, GN, SML, 28)
Oper (Op27a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 3, GN, SML, 28)
Oper (Op27a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 3, GN, SML, 32)
Oper (Op27b0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 3, GN, SML, 32)
Oper (Op27b8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 3, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op2800, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 4, GN, SRL, 4)
Oper (Op2808, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 4, GN, SRL, 4)
Oper (Op2810, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 4, GN, SRL, 12)
Oper (Op2818, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 4, GN, SRL, 12)
Oper (Op2820, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 4, GN, SRL, 16)
Oper (Op2828, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 4, GN, SRL, 16)
Oper (Op2830, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 4, GN, SRL, 20)
Oper (Op2838, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 4, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2840, DoMovea, DL, SdL, ins7, DL, DR, Ca, 4, GN, SRL, 4)
Oper (Op2848, DoMovea, DL, SaL, ins7, DL, DR, Ca, 4, GN, SRL, 4)
Oper (Op2850, DoMovea, DL, SainL, ins7, DL, DR, Ca, 4, GN, SRL, 12)
Oper (Op2858, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 4, GN, SRL, 12)
Oper (Op2860, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 4, GN, SRL, 16)
Oper (Op2868, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 4, GN, SRL, 16)
Oper (Op2870, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 4, GN, SRL, 20)
Oper (Op2878, DoMovea, DL, SearL, ins7, DL, DR, Ca, 4, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2880, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 4, GN, SML, 12)
Oper (Op2888, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 4, GN, SML, 12)
Oper (Op2890, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 4, GN, SML, 20)
Oper (Op2898, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 4, GN, SML, 20)
Oper (Op28a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 4, GN, SML, 24)
Oper (Op28a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 4, GN, SML, 24)
Oper (Op28b0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 4, GN, SML, 28)
Oper (Op28b8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 4, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op28c0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 4, GN, SML, 12)
Oper (Op28c8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 4, GN, SML, 12)
Oper (Op28d0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 4, GN, SML, 20)
Oper (Op28d8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 4, GN, SML, 20)
Oper (Op28e0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 4, GN, SML, 24)
Oper (Op28e8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 4, GN, SML, 24)
Oper (Op28f0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 4, GN, SML, 28)
Oper (Op28f8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 4, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2900, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 4, GN, SML, 16)
Oper (Op2908, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 4, GN, SML, 16)
Oper (Op2910, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 4, GN, SML, 24)
Oper (Op2918, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 4, GN, SML, 24)
Oper (Op2920, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 4, GN, SML, 24)
Oper (Op2928, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 4, GN, SML, 28)
Oper (Op2930, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 4, GN, SML, 28)
Oper (Op2938, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 4, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2940, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 4, GN, SML, 16)
Oper (Op2948, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 4, GN, SML, 16)
Oper (Op2950, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 4, GN, SML, 24)
Oper (Op2958, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 4, GN, SML, 24)
Oper (Op2960, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 4, GN, SML, 28)
Oper (Op2968, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 4, GN, SML, 28)
Oper (Op2970, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 4, GN, SML, 32)
Oper (Op2978, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 4, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2980, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 4, GN, SML, 20)
Oper (Op2988, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 4, GN, SML, 20)
Oper (Op2990, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 4, GN, SML, 28)
Oper (Op2998, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 4, GN, SML, 28)
Oper (Op29a0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 4, GN, SML, 28)
Oper (Op29a8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 4, GN, SML, 32)
Oper (Op29b0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 4, GN, SML, 32)
Oper (Op29b8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 4, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op2a00, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 5, GN, SRL, 4)
Oper (Op2a08, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 5, GN, SRL, 4)
Oper (Op2a10, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 5, GN, SRL, 12)
Oper (Op2a18, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 5, GN, SRL, 12)
Oper (Op2a20, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 5, GN, SRL, 16)
Oper (Op2a28, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 5, GN, SRL, 16)
Oper (Op2a30, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 5, GN, SRL, 20)
Oper (Op2a38, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 5, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2a40, DoMovea, DL, SdL, ins7, DL, DR, Ca, 5, GN, SRL, 4)
Oper (Op2a48, DoMovea, DL, SaL, ins7, DL, DR, Ca, 5, GN, SRL, 4)
Oper (Op2a50, DoMovea, DL, SainL, ins7, DL, DR, Ca, 5, GN, SRL, 12)
Oper (Op2a58, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 5, GN, SRL, 12)
Oper (Op2a60, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 5, GN, SRL, 16)
Oper (Op2a68, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 5, GN, SRL, 16)
Oper (Op2a70, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 5, GN, SRL, 20)
Oper (Op2a78, DoMovea, DL, SearL, ins7, DL, DR, Ca, 5, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2a80, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 5, GN, SML, 12)
Oper (Op2a88, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 5, GN, SML, 12)
Oper (Op2a90, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 5, GN, SML, 20)
Oper (Op2a98, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 5, GN, SML, 20)
Oper (Op2aa0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 5, GN, SML, 24)
Oper (Op2aa8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 5, GN, SML, 24)
Oper (Op2ab0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 5, GN, SML, 28)
Oper (Op2ab8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 5, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2ac0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 5, GN, SML, 12)
Oper (Op2ac8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 5, GN, SML, 12)
Oper (Op2ad0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 5, GN, SML, 20)
Oper (Op2ad8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 5, GN, SML, 20)
Oper (Op2ae0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 5, GN, SML, 24)
Oper (Op2ae8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 5, GN, SML, 24)
Oper (Op2af0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 5, GN, SML, 28)
Oper (Op2af8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 5, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2b00, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 5, GN, SML, 16)
Oper (Op2b08, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 5, GN, SML, 16)
Oper (Op2b10, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 5, GN, SML, 24)
Oper (Op2b18, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 5, GN, SML, 24)
Oper (Op2b20, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 5, GN, SML, 24)
Oper (Op2b28, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 5, GN, SML, 28)
Oper (Op2b30, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 5, GN, SML, 28)
Oper (Op2b38, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 5, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2b40, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 5, GN, SML, 16)
Oper (Op2b48, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 5, GN, SML, 16)
Oper (Op2b50, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 5, GN, SML, 24)
Oper (Op2b58, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 5, GN, SML, 24)
Oper (Op2b60, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 5, GN, SML, 28)
Oper (Op2b68, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 5, GN, SML, 28)
Oper (Op2b70, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 5, GN, SML, 32)
Oper (Op2b78, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 5, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2b80, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 5, GN, SML, 20)
Oper (Op2b88, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 5, GN, SML, 20)
Oper (Op2b90, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 5, GN, SML, 28)
Oper (Op2b98, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 5, GN, SML, 28)
Oper (Op2ba0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 5, GN, SML, 28)
Oper (Op2ba8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 5, GN, SML, 32)
Oper (Op2bb0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 5, GN, SML, 32)
Oper (Op2bb8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 5, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op2c00, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 6, GN, SRL, 4)
Oper (Op2c08, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 6, GN, SRL, 4)
Oper (Op2c10, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 6, GN, SRL, 12)
Oper (Op2c18, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 6, GN, SRL, 12)
Oper (Op2c20, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 6, GN, SRL, 16)
Oper (Op2c28, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 6, GN, SRL, 16)
Oper (Op2c30, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 6, GN, SRL, 20)
Oper (Op2c38, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 6, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2c40, DoMovea, DL, SdL, ins7, DL, DR, Ca, 6, GN, SRL, 4)
Oper (Op2c48, DoMovea, DL, SaL, ins7, DL, DR, Ca, 6, GN, SRL, 4)
Oper (Op2c50, DoMovea, DL, SainL, ins7, DL, DR, Ca, 6, GN, SRL, 12)
Oper (Op2c58, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 6, GN, SRL, 12)
Oper (Op2c60, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 6, GN, SRL, 16)
Oper (Op2c68, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 6, GN, SRL, 16)
Oper (Op2c70, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 6, GN, SRL, 20)
Oper (Op2c78, DoMovea, DL, SearL, ins7, DL, DR, Ca, 6, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2c80, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 6, GN, SML, 12)
Oper (Op2c88, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 6, GN, SML, 12)
Oper (Op2c90, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 6, GN, SML, 20)
Oper (Op2c98, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 6, GN, SML, 20)
Oper (Op2ca0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 6, GN, SML, 24)
Oper (Op2ca8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 6, GN, SML, 24)
Oper (Op2cb0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 6, GN, SML, 28)
Oper (Op2cb8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 6, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2cc0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 6, GN, SML, 12)
Oper (Op2cc8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 6, GN, SML, 12)
Oper (Op2cd0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 6, GN, SML, 20)
Oper (Op2cd8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 6, GN, SML, 20)
Oper (Op2ce0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 6, GN, SML, 24)
Oper (Op2ce8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 6, GN, SML, 24)
Oper (Op2cf0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 6, GN, SML, 28)
Oper (Op2cf8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 6, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2d00, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 6, GN, SML, 16)
Oper (Op2d08, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 6, GN, SML, 16)
Oper (Op2d10, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 6, GN, SML, 24)
Oper (Op2d18, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 6, GN, SML, 24)
Oper (Op2d20, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 6, GN, SML, 24)
Oper (Op2d28, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 6, GN, SML, 28)
Oper (Op2d30, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 6, GN, SML, 28)
Oper (Op2d38, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 6, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2d40, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 6, GN, SML, 16)
Oper (Op2d48, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 6, GN, SML, 16)
Oper (Op2d50, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 6, GN, SML, 24)
Oper (Op2d58, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 6, GN, SML, 24)
Oper (Op2d60, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 6, GN, SML, 28)
Oper (Op2d68, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 6, GN, SML, 28)
Oper (Op2d70, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 6, GN, SML, 32)
Oper (Op2d78, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 6, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2d80, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 6, GN, SML, 20)
Oper (Op2d88, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 6, GN, SML, 20)
Oper (Op2d90, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 6, GN, SML, 28)
Oper (Op2d98, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 6, GN, SML, 28)
Oper (Op2da0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 6, GN, SML, 28)
Oper (Op2da8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 6, GN, SML, 32)
Oper (Op2db0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 6, GN, SML, 32)
Oper (Op2db8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 6, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op2e00, DoMoveL, DL, SdL, ins7, DL, DR, Cd, 7, GN, SRL, 4)
Oper (Op2e08, DoMoveL, DL, SaL, ins7, DL, DR, Cd, 7, GN, SRL, 4)
Oper (Op2e10, DoMoveL, DL, SainL, ins7, DL, DR, Cd, 7, GN, SRL, 12)
Oper (Op2e18, DoMoveL, DL, SaipL, ins7, DL, DR, Cd, 7, GN, SRL, 12)
Oper (Op2e20, DoMoveL, DL, SmaiL, ins7, DL, DR, Cd, 7, GN, SRL, 16)
Oper (Op2e28, DoMoveL, DL, SdaiL, ins7, DL, DR, Cd, 7, GN, SRL, 16)
Oper (Op2e30, DoMoveL, DL, SaixL, ins7, DL, DR, Cd, 7, GN, SRL, 20)
Oper (Op2e38, DoMoveL, DL, SearL, ins7, DL, DR, Cd, 7, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2e40, DoMovea, DL, SdL, ins7, DL, DR, Ca, 7, GN, SRL, 4)
Oper (Op2e48, DoMovea, DL, SaL, ins7, DL, DR, Ca, 7, GN, SRL, 4)
Oper (Op2e50, DoMovea, DL, SainL, ins7, DL, DR, Ca, 7, GN, SRL, 12)
Oper (Op2e58, DoMovea, DL, SaipL, ins7, DL, DR, Ca, 7, GN, SRL, 12)
Oper (Op2e60, DoMovea, DL, SmaiL, ins7, DL, DR, Ca, 7, GN, SRL, 16)
Oper (Op2e68, DoMovea, DL, SdaiL, ins7, DL, DR, Ca, 7, GN, SRL, 16)
Oper (Op2e70, DoMovea, DL, SaixL, ins7, DL, DR, Ca, 7, GN, SRL, 20)
Oper (Op2e78, DoMovea, DL, SearL, ins7, DL, DR, Ca, 7, GN, SRL, (cycles+15)&0xfffffffc)
Oper (Op2e80, DoMoveL, DL, SdL, ins7, DL, DA, Cain, 7, GN, SML, 12)
Oper (Op2e88, DoMoveL, DL, SaL, ins7, DL, DA, Cain, 7, GN, SML, 12)
Oper (Op2e90, DoMoveL, DL, SainL, ins7, DL, DA, Cain, 7, GN, SML, 20)
Oper (Op2e98, DoMoveL, DL, SaipL, ins7, DL, DA, Cain, 7, GN, SML, 20)
Oper (Op2ea0, DoMoveL, DL, SmaiL, ins7, DL, DA, Cain, 7, GN, SML, 24)
Oper (Op2ea8, DoMoveL, DL, SdaiL, ins7, DL, DA, Cain, 7, GN, SML, 24)
Oper (Op2eb0, DoMoveL, DL, SaixL, ins7, DL, DA, Cain, 7, GN, SML, 28)
Oper (Op2eb8, DoMoveL, DL, SearL, ins7, DL, DA, Cain, 7, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2ec0, DoMoveL, DL, SdL, ins7, DL, DA, CaipL, 7, GN, SML, 12)
Oper (Op2ec8, DoMoveL, DL, SaL, ins7, DL, DA, CaipL, 7, GN, SML, 12)
Oper (Op2ed0, DoMoveL, DL, SainL, ins7, DL, DA, CaipL, 7, GN, SML, 20)
Oper (Op2ed8, DoMoveL, DL, SaipL, ins7, DL, DA, CaipL, 7, GN, SML, 20)
Oper (Op2ee0, DoMoveL, DL, SmaiL, ins7, DL, DA, CaipL, 7, GN, SML, 24)
Oper (Op2ee8, DoMoveL, DL, SdaiL, ins7, DL, DA, CaipL, 7, GN, SML, 24)
Oper (Op2ef0, DoMoveL, DL, SaixL, ins7, DL, DA, CaipL, 7, GN, SML, 28)
Oper (Op2ef8, DoMoveL, DL, SearL, ins7, DL, DA, CaipL, 7, GN, SML, (cycles+23)&0xfffffffc)
Oper (Op2f00, DoMoveL, DL, SdL, ins7, DL, DA, CmaiL, 7, GN, SML, 16)
Oper (Op2f08, DoMoveL, DL, SaL, ins7, DL, DA, CmaiL, 7, GN, SML, 16)
Oper (Op2f10, DoMoveL, DL, SainL, ins7, DL, DA, CmaiL, 7, GN, SML, 24)
Oper (Op2f18, DoMoveL, DL, SaipL, ins7, DL, DA, CmaiL, 7, GN, SML, 24)
Oper (Op2f20, DoMoveL, DL, SmaiL, ins7, DL, DA, CmaiL, 7, GN, SML, 24)
Oper (Op2f28, DoMoveL, DL, SdaiL, ins7, DL, DA, CmaiL, 7, GN, SML, 28)
Oper (Op2f30, DoMoveL, DL, SaixL, ins7, DL, DA, CmaiL, 7, GN, SML, 28)
Oper (Op2f38, DoMoveL, DL, SearL, ins7, DL, DA, CmaiL, 7, GN, SML, (cycles+25)&0xfffffffc)
Oper (Op2f40, DoMoveL, DL, SdL, ins7, DL, DA, Fdai, 7, GN, SML, 16)
Oper (Op2f48, DoMoveL, DL, SaL, ins7, DL, DA, Fdai, 7, GN, SML, 16)
Oper (Op2f50, DoMoveL, DL, SainL, ins7, DL, DA, Fdai, 7, GN, SML, 24)
Oper (Op2f58, DoMoveL, DL, SaipL, ins7, DL, DA, Fdai, 7, GN, SML, 24)
Oper (Op2f60, DoMoveL, DL, SmaiL, ins7, DL, DA, Fdai, 7, GN, SML, 28)
Oper (Op2f68, DoMoveL, DL, SdaiL, ins7, DL, DA, Cdai, 7, GN, SML, 28)
Oper (Op2f70, DoMoveL, DL, SaixL, ins7, DL, DA, Cdai, 7, GN, SML, 32)
Oper (Op2f78, DoMoveL, DL, SearL, ins7, DL, DA, Cdai, 7, GN, SML, (cycles+27)&0xfffffffc)
Oper (Op2f80, DoMoveL, DL, SdL, ins7, DL, DA, Faix, 7, GN, SML, 20)
Oper (Op2f88, DoMoveL, DL, SaL, ins7, DL, DA, Faix, 7, GN, SML, 20)
Oper (Op2f90, DoMoveL, DL, SainL, ins7, DL, DA, Faix, 7, GN, SML, 28)
Oper (Op2f98, DoMoveL, DL, SaipL, ins7, DL, DA, Faix, 7, GN, SML, 28)
Oper (Op2fa0, DoMoveL, DL, SmaiL, ins7, DL, DA, Faix, 7, GN, SML, 28)
Oper (Op2fa8, DoMoveL, DL, SdaiL, ins7, DL, DA, Caix, 7, GN, SML, 32)
Oper (Op2fb0, DoMoveL, DL, SaixL, ins7, DL, DA, Caix, 7, GN, SML, 32)
Oper (Op2fb8, DoMoveL, DL, SearL, ins7, DL, DA, Caix, 7, GN, SML, (cycles+29)&0xfffffffc)

Oper (Op3000, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 0, GN, SRW, 4)
Oper (Op3008, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 0, GN, SRW, 4)
Oper (Op3010, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 0, GN, SRW, 8)
Oper (Op3018, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 0, GN, SRW, 8)
Oper (Op3020, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 0, GN, SRW, 12)
Oper (Op3028, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 0, GN, SRW, 12)
Oper (Op3030, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 0, GN, SRW, 16)
Oper (Op3038, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 0, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3040, DoMovea, DW, SdW, ins7, DL, DR, Ca, 0, GN, SRL, 4)
Oper (Op3048, DoMovea, DW, SaW, ins7, DL, DR, Ca, 0, GN, SRL, 4)
Oper (Op3050, DoMovea, DW, SainW, ins7, DL, DR, Ca, 0, GN, SRL, 8)
Oper (Op3058, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 0, GN, SRL, 8)
Oper (Op3060, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 0, GN, SRL, 12)
Oper (Op3068, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 0, GN, SRL, 12)
Oper (Op3070, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 0, GN, SRL, 16)
Oper (Op3078, DoMovea, DW, SearW, ins7, DL, DR, Ca, 0, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3080, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 0, GN, SMW, 8)
Oper (Op3088, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 0, GN, SMW, 8)
Oper (Op3090, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 0, GN, SMW, 12)
Oper (Op3098, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 0, GN, SMW, 12)
Oper (Op30a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 0, GN, SMW, 16)
Oper (Op30a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 0, GN, SMW, 16)
Oper (Op30b0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 0, GN, SMW, 20)
Oper (Op30b8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 0, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op30c0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 0, GN, SMW, 8)
Oper (Op30c8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 0, GN, SMW, 8)
Oper (Op30d0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 0, GN, SMW, 12)
Oper (Op30d8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 0, GN, SMW, 12)
Oper (Op30e0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 0, GN, SMW, 16)
Oper (Op30e8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 0, GN, SMW, 16)
Oper (Op30f0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 0, GN, SMW, 20)
Oper (Op30f8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 0, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3100, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 0, GN, SMW, 12)
Oper (Op3108, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 0, GN, SMW, 12)
Oper (Op3110, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 0, GN, SMW, 16)
Oper (Op3118, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 0, GN, SMW, 16)
Oper (Op3120, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 0, GN, SMW, 16)
Oper (Op3128, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 0, GN, SMW, 20)
Oper (Op3130, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 0, GN, SMW, 20)
Oper (Op3138, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 0, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3140, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 0, GN, SMW, 12)
Oper (Op3148, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 0, GN, SMW, 12)
Oper (Op3150, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 0, GN, SMW, 16)
Oper (Op3158, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 0, GN, SMW, 16)
Oper (Op3160, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 0, GN, SMW, 20)
Oper (Op3168, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 0, GN, SMW, 20)
Oper (Op3170, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 0, GN, SMW, 24)
Oper (Op3178, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 0, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3180, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 0, GN, SMW, 16)
Oper (Op3188, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 0, GN, SMW, 16)
Oper (Op3190, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 0, GN, SMW, 20)
Oper (Op3198, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 0, GN, SMW, 20)
Oper (Op31a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 0, GN, SMW, 20)
Oper (Op31a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 0, GN, SMW, 24)
Oper (Op31b0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 0, GN, SMW, 24)
Oper (Op31b8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 0, GN, SMW, (cycles+21)&0xfffffffc)
Oper (Op31c0, DoMoveW, DW, SdW, ins7, DW, DA, Feaw, 0, GN, SMW, 12)
Oper (Op31c8, DoMoveW, DW, SaW, ins7, DW, DA, Feaw, 0, GN, SMW, 12)
Oper (Op31d0, DoMoveW, DW, SainW, ins7, DW, DA, Feaw, 0, GN, SMW, 16)
Oper (Op31d8, DoMoveW, DW, SaipW, ins7, DW, DA, Feaw, 0, GN, SMW, 16)
Oper (Op31e0, DoMoveW, DW, SmaiW, ins7, DW, DA, Feaw, 0, GN, SMW, 20)
Oper (Op31e8, DoMoveW, DW, SdaiW, ins7, DW, DA, Ceaw, 0, GN, SMW, 20)
Oper (Op31f0, DoMoveW, DW, SaixW, ins7, DW, DA, Ceaw, 0, GN, SMW, 24)
Oper (Op31f8, DoMoveW, DW, SearW, ins7, DW, DA, Ceaw, 0, GN, SMW, (cycles+19)&0xfffffffc)

Oper (Op3200, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 1, GN, SRW, 4)
Oper (Op3208, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 1, GN, SRW, 4)
Oper (Op3210, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 1, GN, SRW, 8)
Oper (Op3218, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 1, GN, SRW, 8)
Oper (Op3220, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 1, GN, SRW, 12)
Oper (Op3228, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 1, GN, SRW, 12)
Oper (Op3230, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 1, GN, SRW, 16)
Oper (Op3238, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 1, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3240, DoMovea, DW, SdW, ins7, DL, DR, Ca, 1, GN, SRL, 4)
Oper (Op3248, DoMovea, DW, SaW, ins7, DL, DR, Ca, 1, GN, SRL, 4)
Oper (Op3250, DoMovea, DW, SainW, ins7, DL, DR, Ca, 1, GN, SRL, 8)
Oper (Op3258, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 1, GN, SRL, 8)
Oper (Op3260, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 1, GN, SRL, 12)
Oper (Op3268, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 1, GN, SRL, 12)
Oper (Op3270, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 1, GN, SRL, 16)
Oper (Op3278, DoMovea, DW, SearW, ins7, DL, DR, Ca, 1, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3280, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 1, GN, SMW, 8)
Oper (Op3288, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 1, GN, SMW, 8)
Oper (Op3290, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 1, GN, SMW, 12)
Oper (Op3298, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 1, GN, SMW, 12)
Oper (Op32a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 1, GN, SMW, 16)
Oper (Op32a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 1, GN, SMW, 16)
Oper (Op32b0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 1, GN, SMW, 20)
Oper (Op32b8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 1, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op32c0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 1, GN, SMW, 8)
Oper (Op32c8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 1, GN, SMW, 8)
Oper (Op32d0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 1, GN, SMW, 12)
Oper (Op32d8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 1, GN, SMW, 12)
Oper (Op32e0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 1, GN, SMW, 16)
Oper (Op32e8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 1, GN, SMW, 16)
Oper (Op32f0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 1, GN, SMW, 20)
Oper (Op32f8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 1, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3300, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 1, GN, SMW, 12)
Oper (Op3308, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 1, GN, SMW, 12)
Oper (Op3310, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 1, GN, SMW, 16)
Oper (Op3318, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 1, GN, SMW, 16)
Oper (Op3320, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 1, GN, SMW, 16)
Oper (Op3328, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 1, GN, SMW, 20)
Oper (Op3330, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 1, GN, SMW, 20)
Oper (Op3338, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 1, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3340, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 1, GN, SMW, 12)
Oper (Op3348, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 1, GN, SMW, 12)
Oper (Op3350, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 1, GN, SMW, 16)
Oper (Op3358, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 1, GN, SMW, 16)
Oper (Op3360, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 1, GN, SMW, 20)
Oper (Op3368, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 1, GN, SMW, 20)
Oper (Op3370, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 1, GN, SMW, 24)
Oper (Op3378, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 1, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3380, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 1, GN, SMW, 16)
Oper (Op3388, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 1, GN, SMW, 16)
Oper (Op3390, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 1, GN, SMW, 20)
Oper (Op3398, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 1, GN, SMW, 20)
Oper (Op33a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 1, GN, SMW, 20)
Oper (Op33a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 1, GN, SMW, 24)
Oper (Op33b0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 1, GN, SMW, 24)
Oper (Op33b8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 1, GN, SMW, (cycles+21)&0xfffffffc)
Oper (Op33c0, DoMoveW, DW, SdW, ins7, DW, DA, Feaw, 1, GN, SMW, 16)
Oper (Op33c8, DoMoveW, DW, SaW, ins7, DW, DA, Feaw, 1, GN, SMW, 16)
Oper (Op33d0, DoMoveW, DW, SainW, ins7, DW, DA, Feaw, 1, GN, SMW, 20)
Oper (Op33d8, DoMoveW, DW, SaipW, ins7, DW, DA, Feaw, 1, GN, SMW, 20)
Oper (Op33e0, DoMoveW, DW, SmaiW, ins7, DW, DA, Feaw, 1, GN, SMW, 24)
Oper (Op33e8, DoMoveW, DW, SdaiW, ins7, DW, DA, Ceaw, 1, GN, SMW, 24)
Oper (Op33f0, DoMoveW, DW, SaixW, ins7, DW, DA, Ceaw, 1, GN, SMW, 28)
Oper (Op33f8, DoMoveW, DW, SearW, ins7, DW, DA, Ceaw, 1, GN, SMW, (cycles+23)&0xfffffffc)

Oper (Op3400, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 2, GN, SRW, 4)
Oper (Op3408, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 2, GN, SRW, 4)
Oper (Op3410, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 2, GN, SRW, 8)
Oper (Op3418, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 2, GN, SRW, 8)
Oper (Op3420, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 2, GN, SRW, 12)
Oper (Op3428, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 2, GN, SRW, 12)
Oper (Op3430, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 2, GN, SRW, 16)
Oper (Op3438, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 2, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3440, DoMovea, DW, SdW, ins7, DL, DR, Ca, 2, GN, SRL, 4)
Oper (Op3448, DoMovea, DW, SaW, ins7, DL, DR, Ca, 2, GN, SRL, 4)
Oper (Op3450, DoMovea, DW, SainW, ins7, DL, DR, Ca, 2, GN, SRL, 8)
Oper (Op3458, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 2, GN, SRL, 8)
Oper (Op3460, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 2, GN, SRL, 12)
Oper (Op3468, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 2, GN, SRL, 12)
Oper (Op3470, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 2, GN, SRL, 16)
Oper (Op3478, DoMovea, DW, SearW, ins7, DL, DR, Ca, 2, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3480, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 2, GN, SMW, 8)
Oper (Op3488, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 2, GN, SMW, 8)
Oper (Op3490, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 2, GN, SMW, 12)
Oper (Op3498, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 2, GN, SMW, 12)
Oper (Op34a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 2, GN, SMW, 16)
Oper (Op34a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 2, GN, SMW, 16)
Oper (Op34b0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 2, GN, SMW, 20)
Oper (Op34b8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 2, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op34c0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 2, GN, SMW, 8)
Oper (Op34c8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 2, GN, SMW, 8)
Oper (Op34d0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 2, GN, SMW, 12)
Oper (Op34d8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 2, GN, SMW, 12)
Oper (Op34e0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 2, GN, SMW, 16)
Oper (Op34e8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 2, GN, SMW, 16)
Oper (Op34f0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 2, GN, SMW, 20)
Oper (Op34f8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 2, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3500, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 2, GN, SMW, 12)
Oper (Op3508, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 2, GN, SMW, 12)
Oper (Op3510, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 2, GN, SMW, 16)
Oper (Op3518, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 2, GN, SMW, 16)
Oper (Op3520, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 2, GN, SMW, 16)
Oper (Op3528, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 2, GN, SMW, 20)
Oper (Op3530, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 2, GN, SMW, 20)
Oper (Op3538, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 2, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3540, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 2, GN, SMW, 12)
Oper (Op3548, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 2, GN, SMW, 12)
Oper (Op3550, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 2, GN, SMW, 16)
Oper (Op3558, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 2, GN, SMW, 16)
Oper (Op3560, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 2, GN, SMW, 20)
Oper (Op3568, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 2, GN, SMW, 20)
Oper (Op3570, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 2, GN, SMW, 24)
Oper (Op3578, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 2, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3580, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 2, GN, SMW, 16)
Oper (Op3588, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 2, GN, SMW, 16)
Oper (Op3590, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 2, GN, SMW, 20)
Oper (Op3598, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 2, GN, SMW, 20)
Oper (Op35a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 2, GN, SMW, 20)
Oper (Op35a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 2, GN, SMW, 24)
Oper (Op35b0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 2, GN, SMW, 24)
Oper (Op35b8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 2, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op3600, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 3, GN, SRW, 4)
Oper (Op3608, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 3, GN, SRW, 4)
Oper (Op3610, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 3, GN, SRW, 8)
Oper (Op3618, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 3, GN, SRW, 8)
Oper (Op3620, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 3, GN, SRW, 12)
Oper (Op3628, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 3, GN, SRW, 12)
Oper (Op3630, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 3, GN, SRW, 16)
Oper (Op3638, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 3, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3640, DoMovea, DW, SdW, ins7, DL, DR, Ca, 3, GN, SRL, 4)
Oper (Op3648, DoMovea, DW, SaW, ins7, DL, DR, Ca, 3, GN, SRL, 4)
Oper (Op3650, DoMovea, DW, SainW, ins7, DL, DR, Ca, 3, GN, SRL, 8)
Oper (Op3658, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 3, GN, SRL, 8)
Oper (Op3660, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 3, GN, SRL, 12)
Oper (Op3668, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 3, GN, SRL, 12)
Oper (Op3670, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 3, GN, SRL, 16)
Oper (Op3678, DoMovea, DW, SearW, ins7, DL, DR, Ca, 3, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3680, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 3, GN, SMW, 8)
Oper (Op3688, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 3, GN, SMW, 8)
Oper (Op3690, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 3, GN, SMW, 12)
Oper (Op3698, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 3, GN, SMW, 12)
Oper (Op36a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 3, GN, SMW, 16)
Oper (Op36a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 3, GN, SMW, 16)
Oper (Op36b0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 3, GN, SMW, 20)
Oper (Op36b8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 3, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op36c0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 3, GN, SMW, 8)
Oper (Op36c8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 3, GN, SMW, 8)
Oper (Op36d0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 3, GN, SMW, 12)
Oper (Op36d8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 3, GN, SMW, 12)
Oper (Op36e0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 3, GN, SMW, 16)
Oper (Op36e8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 3, GN, SMW, 16)
Oper (Op36f0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 3, GN, SMW, 20)
Oper (Op36f8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 3, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3700, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 3, GN, SMW, 12)
Oper (Op3708, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 3, GN, SMW, 12)
Oper (Op3710, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 3, GN, SMW, 16)
Oper (Op3718, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 3, GN, SMW, 16)
Oper (Op3720, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 3, GN, SMW, 16)
Oper (Op3728, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 3, GN, SMW, 20)
Oper (Op3730, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 3, GN, SMW, 20)
Oper (Op3738, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 3, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3740, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 3, GN, SMW, 12)
Oper (Op3748, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 3, GN, SMW, 12)
Oper (Op3750, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 3, GN, SMW, 16)
Oper (Op3758, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 3, GN, SMW, 16)
Oper (Op3760, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 3, GN, SMW, 20)
Oper (Op3768, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 3, GN, SMW, 20)
Oper (Op3770, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 3, GN, SMW, 24)
Oper (Op3778, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 3, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3780, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 3, GN, SMW, 16)
Oper (Op3788, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 3, GN, SMW, 16)
Oper (Op3790, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 3, GN, SMW, 20)
Oper (Op3798, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 3, GN, SMW, 20)
Oper (Op37a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 3, GN, SMW, 20)
Oper (Op37a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 3, GN, SMW, 24)
Oper (Op37b0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 3, GN, SMW, 24)
Oper (Op37b8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 3, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op3800, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 4, GN, SRW, 4)
Oper (Op3808, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 4, GN, SRW, 4)
Oper (Op3810, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 4, GN, SRW, 8)
Oper (Op3818, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 4, GN, SRW, 8)
Oper (Op3820, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 4, GN, SRW, 12)
Oper (Op3828, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 4, GN, SRW, 12)
Oper (Op3830, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 4, GN, SRW, 16)
Oper (Op3838, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 4, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3840, DoMovea, DW, SdW, ins7, DL, DR, Ca, 4, GN, SRL, 4)
Oper (Op3848, DoMovea, DW, SaW, ins7, DL, DR, Ca, 4, GN, SRL, 4)
Oper (Op3850, DoMovea, DW, SainW, ins7, DL, DR, Ca, 4, GN, SRL, 8)
Oper (Op3858, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 4, GN, SRL, 8)
Oper (Op3860, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 4, GN, SRL, 12)
Oper (Op3868, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 4, GN, SRL, 12)
Oper (Op3870, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 4, GN, SRL, 16)
Oper (Op3878, DoMovea, DW, SearW, ins7, DL, DR, Ca, 4, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3880, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 4, GN, SMW, 8)
Oper (Op3888, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 4, GN, SMW, 8)
Oper (Op3890, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 4, GN, SMW, 12)
Oper (Op3898, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 4, GN, SMW, 12)
Oper (Op38a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 4, GN, SMW, 16)
Oper (Op38a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 4, GN, SMW, 16)
Oper (Op38b0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 4, GN, SMW, 20)
Oper (Op38b8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 4, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op38c0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 4, GN, SMW, 8)
Oper (Op38c8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 4, GN, SMW, 8)
Oper (Op38d0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 4, GN, SMW, 12)
Oper (Op38d8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 4, GN, SMW, 12)
Oper (Op38e0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 4, GN, SMW, 16)
Oper (Op38e8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 4, GN, SMW, 16)
Oper (Op38f0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 4, GN, SMW, 20)
Oper (Op38f8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 4, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3900, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 4, GN, SMW, 12)
Oper (Op3908, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 4, GN, SMW, 12)
Oper (Op3910, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 4, GN, SMW, 16)
Oper (Op3918, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 4, GN, SMW, 16)
Oper (Op3920, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 4, GN, SMW, 16)
Oper (Op3928, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 4, GN, SMW, 20)
Oper (Op3930, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 4, GN, SMW, 20)
Oper (Op3938, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 4, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3940, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 4, GN, SMW, 12)
Oper (Op3948, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 4, GN, SMW, 12)
Oper (Op3950, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 4, GN, SMW, 16)
Oper (Op3958, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 4, GN, SMW, 16)
Oper (Op3960, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 4, GN, SMW, 20)
Oper (Op3968, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 4, GN, SMW, 20)
Oper (Op3970, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 4, GN, SMW, 24)
Oper (Op3978, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 4, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3980, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 4, GN, SMW, 16)
Oper (Op3988, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 4, GN, SMW, 16)
Oper (Op3990, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 4, GN, SMW, 20)
Oper (Op3998, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 4, GN, SMW, 20)
Oper (Op39a0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 4, GN, SMW, 20)
Oper (Op39a8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 4, GN, SMW, 24)
Oper (Op39b0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 4, GN, SMW, 24)
Oper (Op39b8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 4, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op3a00, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 5, GN, SRW, 4)
Oper (Op3a08, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 5, GN, SRW, 4)
Oper (Op3a10, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 5, GN, SRW, 8)
Oper (Op3a18, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 5, GN, SRW, 8)
Oper (Op3a20, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 5, GN, SRW, 12)
Oper (Op3a28, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 5, GN, SRW, 12)
Oper (Op3a30, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 5, GN, SRW, 16)
Oper (Op3a38, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 5, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3a40, DoMovea, DW, SdW, ins7, DL, DR, Ca, 5, GN, SRL, 4)
Oper (Op3a48, DoMovea, DW, SaW, ins7, DL, DR, Ca, 5, GN, SRL, 4)
Oper (Op3a50, DoMovea, DW, SainW, ins7, DL, DR, Ca, 5, GN, SRL, 8)
Oper (Op3a58, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 5, GN, SRL, 8)
Oper (Op3a60, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 5, GN, SRL, 12)
Oper (Op3a68, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 5, GN, SRL, 12)
Oper (Op3a70, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 5, GN, SRL, 16)
Oper (Op3a78, DoMovea, DW, SearW, ins7, DL, DR, Ca, 5, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3a80, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 5, GN, SMW, 8)
Oper (Op3a88, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 5, GN, SMW, 8)
Oper (Op3a90, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 5, GN, SMW, 12)
Oper (Op3a98, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 5, GN, SMW, 12)
Oper (Op3aa0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 5, GN, SMW, 16)
Oper (Op3aa8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 5, GN, SMW, 16)
Oper (Op3ab0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 5, GN, SMW, 20)
Oper (Op3ab8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 5, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3ac0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 5, GN, SMW, 8)
Oper (Op3ac8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 5, GN, SMW, 8)
Oper (Op3ad0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 5, GN, SMW, 12)
Oper (Op3ad8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 5, GN, SMW, 12)
Oper (Op3ae0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 5, GN, SMW, 16)
Oper (Op3ae8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 5, GN, SMW, 16)
Oper (Op3af0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 5, GN, SMW, 20)
Oper (Op3af8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 5, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3b00, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 5, GN, SMW, 12)
Oper (Op3b08, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 5, GN, SMW, 12)
Oper (Op3b10, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 5, GN, SMW, 16)
Oper (Op3b18, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 5, GN, SMW, 16)
Oper (Op3b20, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 5, GN, SMW, 16)
Oper (Op3b28, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 5, GN, SMW, 20)
Oper (Op3b30, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 5, GN, SMW, 20)
Oper (Op3b38, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 5, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3b40, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 5, GN, SMW, 12)
Oper (Op3b48, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 5, GN, SMW, 12)
Oper (Op3b50, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 5, GN, SMW, 16)
Oper (Op3b58, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 5, GN, SMW, 16)
Oper (Op3b60, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 5, GN, SMW, 20)
Oper (Op3b68, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 5, GN, SMW, 20)
Oper (Op3b70, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 5, GN, SMW, 24)
Oper (Op3b78, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 5, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3b80, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 5, GN, SMW, 16)
Oper (Op3b88, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 5, GN, SMW, 16)
Oper (Op3b90, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 5, GN, SMW, 20)
Oper (Op3b98, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 5, GN, SMW, 20)
Oper (Op3ba0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 5, GN, SMW, 20)
Oper (Op3ba8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 5, GN, SMW, 24)
Oper (Op3bb0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 5, GN, SMW, 24)
Oper (Op3bb8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 5, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op3c00, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 6, GN, SRW, 4)
Oper (Op3c08, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 6, GN, SRW, 4)
Oper (Op3c10, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 6, GN, SRW, 8)
Oper (Op3c18, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 6, GN, SRW, 8)
Oper (Op3c20, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 6, GN, SRW, 12)
Oper (Op3c28, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 6, GN, SRW, 12)
Oper (Op3c30, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 6, GN, SRW, 16)
Oper (Op3c38, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 6, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3c40, DoMovea, DW, SdW, ins7, DL, DR, Ca, 6, GN, SRL, 4)
Oper (Op3c48, DoMovea, DW, SaW, ins7, DL, DR, Ca, 6, GN, SRL, 4)
Oper (Op3c50, DoMovea, DW, SainW, ins7, DL, DR, Ca, 6, GN, SRL, 8)
Oper (Op3c58, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 6, GN, SRL, 8)
Oper (Op3c60, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 6, GN, SRL, 12)
Oper (Op3c68, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 6, GN, SRL, 12)
Oper (Op3c70, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 6, GN, SRL, 16)
Oper (Op3c78, DoMovea, DW, SearW, ins7, DL, DR, Ca, 6, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3c80, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 6, GN, SMW, 8)
Oper (Op3c88, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 6, GN, SMW, 8)
Oper (Op3c90, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 6, GN, SMW, 12)
Oper (Op3c98, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 6, GN, SMW, 12)
Oper (Op3ca0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 6, GN, SMW, 16)
Oper (Op3ca8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 6, GN, SMW, 16)
Oper (Op3cb0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 6, GN, SMW, 20)
Oper (Op3cb8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 6, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3cc0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 6, GN, SMW, 8)
Oper (Op3cc8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 6, GN, SMW, 8)
Oper (Op3cd0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 6, GN, SMW, 12)
Oper (Op3cd8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 6, GN, SMW, 12)
Oper (Op3ce0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 6, GN, SMW, 16)
Oper (Op3ce8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 6, GN, SMW, 16)
Oper (Op3cf0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 6, GN, SMW, 20)
Oper (Op3cf8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 6, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3d00, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 6, GN, SMW, 12)
Oper (Op3d08, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 6, GN, SMW, 12)
Oper (Op3d10, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 6, GN, SMW, 16)
Oper (Op3d18, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 6, GN, SMW, 16)
Oper (Op3d20, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 6, GN, SMW, 16)
Oper (Op3d28, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 6, GN, SMW, 20)
Oper (Op3d30, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 6, GN, SMW, 20)
Oper (Op3d38, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 6, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3d40, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 6, GN, SMW, 12)
Oper (Op3d48, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 6, GN, SMW, 12)
Oper (Op3d50, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 6, GN, SMW, 16)
Oper (Op3d58, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 6, GN, SMW, 16)
Oper (Op3d60, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 6, GN, SMW, 20)
Oper (Op3d68, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 6, GN, SMW, 20)
Oper (Op3d70, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 6, GN, SMW, 24)
Oper (Op3d78, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 6, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3d80, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 6, GN, SMW, 16)
Oper (Op3d88, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 6, GN, SMW, 16)
Oper (Op3d90, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 6, GN, SMW, 20)
Oper (Op3d98, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 6, GN, SMW, 20)
Oper (Op3da0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 6, GN, SMW, 20)
Oper (Op3da8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 6, GN, SMW, 24)
Oper (Op3db0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 6, GN, SMW, 24)
Oper (Op3db8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 6, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op3e00, DoMoveW, DW, SdW, ins7, DW, DR, Cd, 7, GN, SRW, 4)
Oper (Op3e08, DoMoveW, DW, SaW, ins7, DW, DR, Cd, 7, GN, SRW, 4)
Oper (Op3e10, DoMoveW, DW, SainW, ins7, DW, DR, Cd, 7, GN, SRW, 8)
Oper (Op3e18, DoMoveW, DW, SaipW, ins7, DW, DR, Cd, 7, GN, SRW, 8)
Oper (Op3e20, DoMoveW, DW, SmaiW, ins7, DW, DR, Cd, 7, GN, SRW, 12)
Oper (Op3e28, DoMoveW, DW, SdaiW, ins7, DW, DR, Cd, 7, GN, SRW, 12)
Oper (Op3e30, DoMoveW, DW, SaixW, ins7, DW, DR, Cd, 7, GN, SRW, 16)
Oper (Op3e38, DoMoveW, DW, SearW, ins7, DW, DR, Cd, 7, GN, SRW, (cycles+11)&0xfffffffc)
Oper (Op3e40, DoMovea, DW, SdW, ins7, DL, DR, Ca, 7, GN, SRL, 4)
Oper (Op3e48, DoMovea, DW, SaW, ins7, DL, DR, Ca, 7, GN, SRL, 4)
Oper (Op3e50, DoMovea, DW, SainW, ins7, DL, DR, Ca, 7, GN, SRL, 8)
Oper (Op3e58, DoMovea, DW, SaipW, ins7, DL, DR, Ca, 7, GN, SRL, 8)
Oper (Op3e60, DoMovea, DW, SmaiW, ins7, DL, DR, Ca, 7, GN, SRL, 12)
Oper (Op3e68, DoMovea, DW, SdaiW, ins7, DL, DR, Ca, 7, GN, SRL, 12)
Oper (Op3e70, DoMovea, DW, SaixW, ins7, DL, DR, Ca, 7, GN, SRL, 16)
Oper (Op3e78, DoMovea, DW, SearW, ins7, DL, DR, Ca, 7, GN, SRL, (cycles+11)&0xfffffffc)
Oper (Op3e80, DoMoveW, DW, SdW, ins7, DW, DA, Cain, 7, GN, SMW, 8)
Oper (Op3e88, DoMoveW, DW, SaW, ins7, DW, DA, Cain, 7, GN, SMW, 8)
Oper (Op3e90, DoMoveW, DW, SainW, ins7, DW, DA, Cain, 7, GN, SMW, 12)
Oper (Op3e98, DoMoveW, DW, SaipW, ins7, DW, DA, Cain, 7, GN, SMW, 12)
Oper (Op3ea0, DoMoveW, DW, SmaiW, ins7, DW, DA, Cain, 7, GN, SMW, 16)
Oper (Op3ea8, DoMoveW, DW, SdaiW, ins7, DW, DA, Cain, 7, GN, SMW, 16)
Oper (Op3eb0, DoMoveW, DW, SaixW, ins7, DW, DA, Cain, 7, GN, SMW, 20)
Oper (Op3eb8, DoMoveW, DW, SearW, ins7, DW, DA, Cain, 7, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3ec0, DoMoveW, DW, SdW, ins7, DW, DA, CaipW, 7, GN, SMW, 8)
Oper (Op3ec8, DoMoveW, DW, SaW, ins7, DW, DA, CaipW, 7, GN, SMW, 8)
Oper (Op3ed0, DoMoveW, DW, SainW, ins7, DW, DA, CaipW, 7, GN, SMW, 12)
Oper (Op3ed8, DoMoveW, DW, SaipW, ins7, DW, DA, CaipW, 7, GN, SMW, 12)
Oper (Op3ee0, DoMoveW, DW, SmaiW, ins7, DW, DA, CaipW, 7, GN, SMW, 16)
Oper (Op3ee8, DoMoveW, DW, SdaiW, ins7, DW, DA, CaipW, 7, GN, SMW, 16)
Oper (Op3ef0, DoMoveW, DW, SaixW, ins7, DW, DA, CaipW, 7, GN, SMW, 20)
Oper (Op3ef8, DoMoveW, DW, SearW, ins7, DW, DA, CaipW, 7, GN, SMW, (cycles+15)&0xfffffffc)
Oper (Op3f00, DoMoveW, DW, SdW, ins7, DW, DA, CmaiW, 7, GN, SMW, 12)
Oper (Op3f08, DoMoveW, DW, SaW, ins7, DW, DA, CmaiW, 7, GN, SMW, 12)
Oper (Op3f10, DoMoveW, DW, SainW, ins7, DW, DA, CmaiW, 7, GN, SMW, 16)
Oper (Op3f18, DoMoveW, DW, SaipW, ins7, DW, DA, CmaiW, 7, GN, SMW, 16)
Oper (Op3f20, DoMoveW, DW, SmaiW, ins7, DW, DA, CmaiW, 7, GN, SMW, 16)
Oper (Op3f28, DoMoveW, DW, SdaiW, ins7, DW, DA, CmaiW, 7, GN, SMW, 20)
Oper (Op3f30, DoMoveW, DW, SaixW, ins7, DW, DA, CmaiW, 7, GN, SMW, 20)
Oper (Op3f38, DoMoveW, DW, SearW, ins7, DW, DA, CmaiW, 7, GN, SMW, (cycles+17)&0xfffffffc)
Oper (Op3f40, DoMoveW, DW, SdW, ins7, DW, DA, Fdai, 7, GN, SMW, 12)
Oper (Op3f48, DoMoveW, DW, SaW, ins7, DW, DA, Fdai, 7, GN, SMW, 12)
Oper (Op3f50, DoMoveW, DW, SainW, ins7, DW, DA, Fdai, 7, GN, SMW, 16)
Oper (Op3f58, DoMoveW, DW, SaipW, ins7, DW, DA, Fdai, 7, GN, SMW, 16)
Oper (Op3f60, DoMoveW, DW, SmaiW, ins7, DW, DA, Fdai, 7, GN, SMW, 20)
Oper (Op3f68, DoMoveW, DW, SdaiW, ins7, DW, DA, Cdai, 7, GN, SMW, 20)
Oper (Op3f70, DoMoveW, DW, SaixW, ins7, DW, DA, Cdai, 7, GN, SMW, 24)
Oper (Op3f78, DoMoveW, DW, SearW, ins7, DW, DA, Cdai, 7, GN, SMW, (cycles+19)&0xfffffffc)
Oper (Op3f80, DoMoveW, DW, SdW, ins7, DW, DA, Faix, 7, GN, SMW, 16)
Oper (Op3f88, DoMoveW, DW, SaW, ins7, DW, DA, Faix, 7, GN, SMW, 16)
Oper (Op3f90, DoMoveW, DW, SainW, ins7, DW, DA, Faix, 7, GN, SMW, 20)
Oper (Op3f98, DoMoveW, DW, SaipW, ins7, DW, DA, Faix, 7, GN, SMW, 20)
Oper (Op3fa0, DoMoveW, DW, SmaiW, ins7, DW, DA, Faix, 7, GN, SMW, 20)
Oper (Op3fa8, DoMoveW, DW, SdaiW, ins7, DW, DA, Caix, 7, GN, SMW, 24)
Oper (Op3fb0, DoMoveW, DW, SaixW, ins7, DW, DA, Caix, 7, GN, SMW, 24)
Oper (Op3fb8, DoMoveW, DW, SearW, ins7, DW, DA, Caix, 7, GN, SMW, (cycles+21)&0xfffffffc)

Oper (Op7000, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 0, GN, SRL, 4)
Oper (Op7200, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 1, GN, SRL, 4)
Oper (Op7400, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 2, GN, SRL, 4)
Oper (Op7600, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 3, GN, SRL, 4)
Oper (Op7800, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 4, GN, SRL, 4)
Oper (Op7a00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 5, GN, SRL, 4)
Oper (Op7c00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 6, GN, SRL, 4)
Oper (Op7e00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 7, GN, SRL, 4)
