/*
* Castaway
*  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
*
* $File$ - 68k add instructions
*
* This file is distributed under the GPL, version 2 or at your
* option any later version.  See doc/license.txt for details.
*
* revision history
*  23.05.2002  JH  FAST1.0.1 code import: KR -> ANSI, restructuring
*  10.07.2002  JH  Fixed Z-Flag for ADDX
*  08.10.2002  JH  Fixed Z-Flag for ADD.B 0x80+0x80 and Add.W 0x8000+0x8000.
*/
#ifndef PROTOH
static char     sccsid[] = "$Id: op68kadd.c,v 1.3 2002/10/08 00:18:02 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

/*
* Opfuncs.
*/

#define DoAddB(target,source) \
{register int32 tgt,cvnz=0;\
    tgt = target + source;\
	if ((uint32) source > (uint32) ~target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target = tgt;\
	if (tgt!=target) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoAddW(target,source) \
{register int32 tgt,cvnz=0;\
    tgt = target + source;\
	if ((uint32) source > (uint32) ~target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target = tgt;\
	if (tgt!=target) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoAddL(target,source) \
    /* Overflow precondition: source has same sign */\
{register int32 precon=(target>>31)-(source>>31),cvnz=0;\
    if ((uint32) source > (uint32) ~target) {ForceX(1); cvnz+=Cflag;} else ForceX(0);\
    target += source;\
    /* target and source now have different sign: overflow! */\
    if (precon==0 && (target>>31)!=(source>>31)) cvnz+=Vflag;\
	if (target==0) cvnz+=Zflag;\
	else if (target<0) cvnz+=Nflag;\
	ForceCVNZ(cvnz);\
};

#define DoAdda(target,source) target += source;

#define DoAddx(target,source) \
    /* Overflow precondition: source has same sign */\
{register int32 precon=(target>>31)-(source>>31);\
    if (GetX ()) {\
	SetXC ((uint32) source >= (uint32) ~target);\
	target += source + 1;\
    } else {\
	SetXC ((uint32) source > (uint32) ~target);\
	target += source;\
}\
    /* target and source now have different sign: overflow! */\
    SetV(precon==0 && (target>>31)!=(source>>31));\
    ZeroZ(target!=0);\
SetN(target < 0);};

#endif

Oper (Opd000, DoAddB, DB, SdB, ins7, DB, DR, Cd, 0, GRB, SRB, 4)
Oper (Opd010, DoAddB, DB, SainB, ins7, DB, DR, Cd, 0, GRB, SRB, 8)
Oper (Opd018, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 0, GRB, SRB, 8)
Oper (Opd020, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 0, GRB, SRB, 12)
Oper (Opd028, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 0, GRB, SRB, 12)
Oper (Opd030, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 0, GRB, SRB, 16)
Oper (Opd038, DoAddB, DB, SearB, ins7, DB, DR, Cd, 0, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opd040, DoAddW, DW, SdW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Opd048, DoAddW, DW, SaW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Opd050, DoAddW, DW, SainW, ins7, DW, DR, Cd, 0, GRW, SRW, 8)
Oper (Opd058, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 0, GRW, SRW, 8)
Oper (Opd060, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 0, GRW, SRW, 12)
Oper (Opd068, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 0, GRW, SRW, 12)
Oper (Opd070, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 0, GRW, SRW, 16)
Oper (Opd078, DoAddW, DW, SearW, ins7, DW, DR, Cd, 0, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opd080, DoAddL, DL, SdL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Opd088, DoAddL, DL, SaL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Opd090, DoAddL, DL, SainL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Opd098, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Opd0a0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 0, GRL, SRL, 16)
Oper (Opd0a8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 0, GRL, SRL, 20)
Oper (Opd0b0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 0, GRL, SRL, 20)
Oper (Opd0b8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 0, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opd0c0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Opd0c8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Opd0d0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 0, GRL, SRL, 12)
Oper (Opd0d8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 0, GRL, SRL, 12)
Oper (Opd0e0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Opd0e8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Opd0f0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Opd0f8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 0, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opd100, DoAddx, DB, SdB, ins7, DB, DR, Cd, 0, GRB, SRB, 4)
Oper (Opd108, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 0, GMB, SMB, 20)
Oper (Opd110, DoAddB, DB, SdB, 0, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opd118, DoAddB, DB, SdB, 0, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opd120, DoAddB, DB, SdB, 0, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opd128, DoAddB, DB, SdB, 0, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opd130, DoAddB, DB, SdB, 0, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opd138, DoAddB, DB, SdB, 0, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opd140, DoAddx, DW, SdW, ins7, DW, DR, Cd, 0, GRW, SRW, 4)
Oper (Opd148, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 0, GMW, SMW, 20)
Oper (Opd150, DoAddW, DW, SdW, 0, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opd158, DoAddW, DW, SdW, 0, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opd160, DoAddW, DW, SdW, 0, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opd168, DoAddW, DW, SdW, 0, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opd170, DoAddW, DW, SdW, 0, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opd178, DoAddW, DW, SdW, 0, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opd180, DoAddx, DL, SdL, ins7, DL, DR, Cd, 0, GRL, SRL, 8)
Oper (Opd188, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 0, GML, SML, 32)
Oper (Opd190, DoAddL, DL, SdL, 0, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opd198, DoAddL, DL, SdL, 0, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opd1a0, DoAddL, DL, SdL, 0, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opd1a8, DoAddL, DL, SdL, 0, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opd1b0, DoAddL, DL, SdL, 0, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opd1b8, DoAddL, DL, SdL, 0, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opd1c0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Opd1c8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 0, GRL, SRL, 8)
Oper (Opd1d0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Opd1d8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Opd1e0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 0, GRL, SRL, 16)
Oper (Opd1e8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Opd1f0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 0, GRL, SRL, 20)
Oper (Opd1f8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 0, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opd200, DoAddB, DB, SdB, ins7, DB, DR, Cd, 1, GRB, SRB, 4)
Oper (Opd210, DoAddB, DB, SainB, ins7, DB, DR, Cd, 1, GRB, SRB, 8)
Oper (Opd218, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 1, GRB, SRB, 8)
Oper (Opd220, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 1, GRB, SRB, 12)
Oper (Opd228, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 1, GRB, SRB, 12)
Oper (Opd230, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 1, GRB, SRB, 16)
Oper (Opd238, DoAddB, DB, SearB, ins7, DB, DR, Cd, 1, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opd240, DoAddW, DW, SdW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Opd248, DoAddW, DW, SaW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Opd250, DoAddW, DW, SainW, ins7, DW, DR, Cd, 1, GRW, SRW, 8)
Oper (Opd258, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 1, GRW, SRW, 8)
Oper (Opd260, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 1, GRW, SRW, 12)
Oper (Opd268, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 1, GRW, SRW, 12)
Oper (Opd270, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 1, GRW, SRW, 16)
Oper (Opd278, DoAddW, DW, SearW, ins7, DW, DR, Cd, 1, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opd280, DoAddL, DL, SdL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Opd288, DoAddL, DL, SaL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Opd290, DoAddL, DL, SainL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Opd298, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Opd2a0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 1, GRL, SRL, 16)
Oper (Opd2a8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 1, GRL, SRL, 20)
Oper (Opd2b0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 1, GRL, SRL, 20)
Oper (Opd2b8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 1, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opd2c0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Opd2c8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Opd2d0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 1, GRL, SRL, 12)
Oper (Opd2d8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 1, GRL, SRL, 12)
Oper (Opd2e0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Opd2e8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Opd2f0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Opd2f8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 1, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opd300, DoAddx, DB, SdB, ins7, DB, DR, Cd, 1, GRB, SRB, 4)
Oper (Opd308, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 1, GMB, SMB, 20)
Oper (Opd310, DoAddB, DB, SdB, 1, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opd318, DoAddB, DB, SdB, 1, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opd320, DoAddB, DB, SdB, 1, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opd328, DoAddB, DB, SdB, 1, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opd330, DoAddB, DB, SdB, 1, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opd338, DoAddB, DB, SdB, 1, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opd340, DoAddx, DW, SdW, ins7, DW, DR, Cd, 1, GRW, SRW, 4)
Oper (Opd348, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 1, GMW, SMW, 20)
Oper (Opd350, DoAddW, DW, SdW, 1, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opd358, DoAddW, DW, SdW, 1, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opd360, DoAddW, DW, SdW, 1, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opd368, DoAddW, DW, SdW, 1, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opd370, DoAddW, DW, SdW, 1, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opd378, DoAddW, DW, SdW, 1, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opd380, DoAddx, DL, SdL, ins7, DL, DR, Cd, 1, GRL, SRL, 8)
Oper (Opd388, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 1, GML, SML, 32)
Oper (Opd390, DoAddL, DL, SdL, 1, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opd398, DoAddL, DL, SdL, 1, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opd3a0, DoAddL, DL, SdL, 1, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opd3a8, DoAddL, DL, SdL, 1, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opd3b0, DoAddL, DL, SdL, 1, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opd3b8, DoAddL, DL, SdL, 1, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opd3c0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Opd3c8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 1, GRL, SRL, 8)
Oper (Opd3d0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Opd3d8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Opd3e0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 1, GRL, SRL, 16)
Oper (Opd3e8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Opd3f0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 1, GRL, SRL, 20)
Oper (Opd3f8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 1, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opd400, DoAddB, DB, SdB, ins7, DB, DR, Cd, 2, GRB, SRB, 4)
Oper (Opd410, DoAddB, DB, SainB, ins7, DB, DR, Cd, 2, GRB, SRB, 8)
Oper (Opd418, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 2, GRB, SRB, 8)
Oper (Opd420, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 2, GRB, SRB, 12)
Oper (Opd428, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 2, GRB, SRB, 12)
Oper (Opd430, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 2, GRB, SRB, 16)
Oper (Opd438, DoAddB, DB, SearB, ins7, DB, DR, Cd, 2, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opd440, DoAddW, DW, SdW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Opd448, DoAddW, DW, SaW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Opd450, DoAddW, DW, SainW, ins7, DW, DR, Cd, 2, GRW, SRW, 8)
Oper (Opd458, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 2, GRW, SRW, 8)
Oper (Opd460, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 2, GRW, SRW, 12)
Oper (Opd468, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 2, GRW, SRW, 12)
Oper (Opd470, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 2, GRW, SRW, 16)
Oper (Opd478, DoAddW, DW, SearW, ins7, DW, DR, Cd, 2, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opd480, DoAddL, DL, SdL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Opd488, DoAddL, DL, SaL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Opd490, DoAddL, DL, SainL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Opd498, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Opd4a0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 2, GRL, SRL, 16)
Oper (Opd4a8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 2, GRL, SRL, 20)
Oper (Opd4b0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 2, GRL, SRL, 20)
Oper (Opd4b8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 2, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opd4c0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Opd4c8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Opd4d0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 2, GRL, SRL, 12)
Oper (Opd4d8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 2, GRL, SRL, 12)
Oper (Opd4e0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Opd4e8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Opd4f0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Opd4f8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 2, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opd500, DoAddx, DB, SdB, ins7, DB, DR, Cd, 2, GRB, SRB, 4)
Oper (Opd508, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 2, GMB, SMB, 20)
Oper (Opd510, DoAddB, DB, SdB, 2, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opd518, DoAddB, DB, SdB, 2, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opd520, DoAddB, DB, SdB, 2, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opd528, DoAddB, DB, SdB, 2, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opd530, DoAddB, DB, SdB, 2, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opd538, DoAddB, DB, SdB, 2, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opd540, DoAddx, DW, SdW, ins7, DW, DR, Cd, 2, GRW, SRW, 4)
Oper (Opd548, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 2, GMW, SMW, 20)
Oper (Opd550, DoAddW, DW, SdW, 2, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opd558, DoAddW, DW, SdW, 2, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opd560, DoAddW, DW, SdW, 2, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opd568, DoAddW, DW, SdW, 2, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opd570, DoAddW, DW, SdW, 2, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opd578, DoAddW, DW, SdW, 2, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opd580, DoAddx, DL, SdL, ins7, DL, DR, Cd, 2, GRL, SRL, 8)
Oper (Opd588, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 2, GML, SML, 32)
Oper (Opd590, DoAddL, DL, SdL, 2, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opd598, DoAddL, DL, SdL, 2, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opd5a0, DoAddL, DL, SdL, 2, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opd5a8, DoAddL, DL, SdL, 2, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opd5b0, DoAddL, DL, SdL, 2, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opd5b8, DoAddL, DL, SdL, 2, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opd5c0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Opd5c8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 2, GRL, SRL, 8)
Oper (Opd5d0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Opd5d8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Opd5e0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 2, GRL, SRL, 16)
Oper (Opd5e8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Opd5f0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 2, GRL, SRL, 20)
Oper (Opd5f8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 2, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opd600, DoAddB, DB, SdB, ins7, DB, DR, Cd, 3, GRB, SRB, 4)
Oper (Opd610, DoAddB, DB, SainB, ins7, DB, DR, Cd, 3, GRB, SRB, 8)
Oper (Opd618, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 3, GRB, SRB, 8)
Oper (Opd620, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 3, GRB, SRB, 12)
Oper (Opd628, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 3, GRB, SRB, 12)
Oper (Opd630, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 3, GRB, SRB, 16)
Oper (Opd638, DoAddB, DB, SearB, ins7, DB, DR, Cd, 3, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opd640, DoAddW, DW, SdW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Opd648, DoAddW, DW, SaW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Opd650, DoAddW, DW, SainW, ins7, DW, DR, Cd, 3, GRW, SRW, 8)
Oper (Opd658, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 3, GRW, SRW, 8)
Oper (Opd660, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 3, GRW, SRW, 12)
Oper (Opd668, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 3, GRW, SRW, 12)
Oper (Opd670, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 3, GRW, SRW, 16)
Oper (Opd678, DoAddW, DW, SearW, ins7, DW, DR, Cd, 3, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opd680, DoAddL, DL, SdL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Opd688, DoAddL, DL, SaL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Opd690, DoAddL, DL, SainL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Opd698, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Opd6a0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 3, GRL, SRL, 16)
Oper (Opd6a8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 3, GRL, SRL, 20)
Oper (Opd6b0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 3, GRL, SRL, 20)
Oper (Opd6b8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 3, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opd6c0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Opd6c8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Opd6d0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 3, GRL, SRL, 12)
Oper (Opd6d8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 3, GRL, SRL, 12)
Oper (Opd6e0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Opd6e8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Opd6f0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Opd6f8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 3, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opd700, DoAddx, DB, SdB, ins7, DB, DR, Cd, 3, GRB, SRB, 4)
Oper (Opd708, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 3, GMB, SMB, 20)
Oper (Opd710, DoAddB, DB, SdB, 3, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opd718, DoAddB, DB, SdB, 3, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opd720, DoAddB, DB, SdB, 3, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opd728, DoAddB, DB, SdB, 3, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opd730, DoAddB, DB, SdB, 3, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opd738, DoAddB, DB, SdB, 3, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opd740, DoAddx, DW, SdW, ins7, DW, DR, Cd, 3, GRW, SRW, 4)
Oper (Opd748, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 3, GMW, SMW, 20)
Oper (Opd750, DoAddW, DW, SdW, 3, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opd758, DoAddW, DW, SdW, 3, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opd760, DoAddW, DW, SdW, 3, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opd768, DoAddW, DW, SdW, 3, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opd770, DoAddW, DW, SdW, 3, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opd778, DoAddW, DW, SdW, 3, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opd780, DoAddx, DL, SdL, ins7, DL, DR, Cd, 3, GRL, SRL, 8)
Oper (Opd788, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 3, GML, SML, 32)
Oper (Opd790, DoAddL, DL, SdL, 3, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opd798, DoAddL, DL, SdL, 3, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opd7a0, DoAddL, DL, SdL, 3, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opd7a8, DoAddL, DL, SdL, 3, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opd7b0, DoAddL, DL, SdL, 3, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opd7b8, DoAddL, DL, SdL, 3, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opd7c0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Opd7c8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 3, GRL, SRL, 8)
Oper (Opd7d0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Opd7d8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Opd7e0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 3, GRL, SRL, 16)
Oper (Opd7e8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Opd7f0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 3, GRL, SRL, 20)
Oper (Opd7f8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 3, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opd800, DoAddB, DB, SdB, ins7, DB, DR, Cd, 4, GRB, SRB, 4)
Oper (Opd810, DoAddB, DB, SainB, ins7, DB, DR, Cd, 4, GRB, SRB, 8)
Oper (Opd818, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 4, GRB, SRB, 8)
Oper (Opd820, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 4, GRB, SRB, 12)
Oper (Opd828, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 4, GRB, SRB, 12)
Oper (Opd830, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 4, GRB, SRB, 16)
Oper (Opd838, DoAddB, DB, SearB, ins7, DB, DR, Cd, 4, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opd840, DoAddW, DW, SdW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Opd848, DoAddW, DW, SaW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Opd850, DoAddW, DW, SainW, ins7, DW, DR, Cd, 4, GRW, SRW, 8)
Oper (Opd858, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 4, GRW, SRW, 8)
Oper (Opd860, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 4, GRW, SRW, 12)
Oper (Opd868, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 4, GRW, SRW, 12)
Oper (Opd870, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 4, GRW, SRW, 16)
Oper (Opd878, DoAddW, DW, SearW, ins7, DW, DR, Cd, 4, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opd880, DoAddL, DL, SdL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Opd888, DoAddL, DL, SaL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Opd890, DoAddL, DL, SainL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Opd898, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Opd8a0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 4, GRL, SRL, 16)
Oper (Opd8a8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 4, GRL, SRL, 20)
Oper (Opd8b0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 4, GRL, SRL, 20)
Oper (Opd8b8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 4, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opd8c0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Opd8c8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Opd8d0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 4, GRL, SRL, 12)
Oper (Opd8d8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 4, GRL, SRL, 12)
Oper (Opd8e0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Opd8e8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Opd8f0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Opd8f8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 4, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opd900, DoAddx, DB, SdB, ins7, DB, DR, Cd, 4, GRB, SRB, 4)
Oper (Opd908, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 4, GMB, SMB, 20)
Oper (Opd910, DoAddB, DB, SdB, 4, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opd918, DoAddB, DB, SdB, 4, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opd920, DoAddB, DB, SdB, 4, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opd928, DoAddB, DB, SdB, 4, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opd930, DoAddB, DB, SdB, 4, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opd938, DoAddB, DB, SdB, 4, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opd940, DoAddx, DW, SdW, ins7, DW, DR, Cd, 4, GRW, SRW, 4)
Oper (Opd948, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 4, GMW, SMW, 20)
Oper (Opd950, DoAddW, DW, SdW, 4, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opd958, DoAddW, DW, SdW, 4, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opd960, DoAddW, DW, SdW, 4, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opd968, DoAddW, DW, SdW, 4, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opd970, DoAddW, DW, SdW, 4, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opd978, DoAddW, DW, SdW, 4, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opd980, DoAddx, DL, SdL, ins7, DL, DR, Cd, 4, GRL, SRL, 8)
Oper (Opd988, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 4, GML, SML, 32)
Oper (Opd990, DoAddL, DL, SdL, 4, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opd998, DoAddL, DL, SdL, 4, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opd9a0, DoAddL, DL, SdL, 4, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opd9a8, DoAddL, DL, SdL, 4, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opd9b0, DoAddL, DL, SdL, 4, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opd9b8, DoAddL, DL, SdL, 4, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opd9c0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Opd9c8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 4, GRL, SRL, 8)
Oper (Opd9d0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Opd9d8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Opd9e0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 4, GRL, SRL, 16)
Oper (Opd9e8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Opd9f0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 4, GRL, SRL, 20)
Oper (Opd9f8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 4, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opda00, DoAddB, DB, SdB, ins7, DB, DR, Cd, 5, GRB, SRB, 4)
Oper (Opda10, DoAddB, DB, SainB, ins7, DB, DR, Cd, 5, GRB, SRB, 8)
Oper (Opda18, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 5, GRB, SRB, 8)
Oper (Opda20, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 5, GRB, SRB, 12)
Oper (Opda28, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 5, GRB, SRB, 12)
Oper (Opda30, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 5, GRB, SRB, 16)
Oper (Opda38, DoAddB, DB, SearB, ins7, DB, DR, Cd, 5, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opda40, DoAddW, DW, SdW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Opda48, DoAddW, DW, SaW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Opda50, DoAddW, DW, SainW, ins7, DW, DR, Cd, 5, GRW, SRW, 8)
Oper (Opda58, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 5, GRW, SRW, 8)
Oper (Opda60, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 5, GRW, SRW, 12)
Oper (Opda68, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 5, GRW, SRW, 12)
Oper (Opda70, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 5, GRW, SRW, 16)
Oper (Opda78, DoAddW, DW, SearW, ins7, DW, DR, Cd, 5, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opda80, DoAddL, DL, SdL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Opda88, DoAddL, DL, SaL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Opda90, DoAddL, DL, SainL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Opda98, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Opdaa0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 5, GRL, SRL, 16)
Oper (Opdaa8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 5, GRL, SRL, 20)
Oper (Opdab0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 5, GRL, SRL, 20)
Oper (Opdab8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 5, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opdac0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Opdac8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Opdad0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 5, GRL, SRL, 12)
Oper (Opdad8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 5, GRL, SRL, 12)
Oper (Opdae0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Opdae8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Opdaf0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Opdaf8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 5, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opdb00, DoAddx, DB, SdB, ins7, DB, DR, Cd, 5, GRB, SRB, 4)
Oper (Opdb08, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 5, GMB, SMB, 20)
Oper (Opdb10, DoAddB, DB, SdB, 5, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opdb18, DoAddB, DB, SdB, 5, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opdb20, DoAddB, DB, SdB, 5, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opdb28, DoAddB, DB, SdB, 5, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opdb30, DoAddB, DB, SdB, 5, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opdb38, DoAddB, DB, SdB, 5, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opdb40, DoAddx, DW, SdW, ins7, DW, DR, Cd, 5, GRW, SRW, 4)
Oper (Opdb48, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 5, GMW, SMW, 20)
Oper (Opdb50, DoAddW, DW, SdW, 5, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opdb58, DoAddW, DW, SdW, 5, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opdb60, DoAddW, DW, SdW, 5, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opdb68, DoAddW, DW, SdW, 5, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opdb70, DoAddW, DW, SdW, 5, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opdb78, DoAddW, DW, SdW, 5, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opdb80, DoAddx, DL, SdL, ins7, DL, DR, Cd, 5, GRL, SRL, 8)
Oper (Opdb88, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 5, GML, SML, 32)
Oper (Opdb90, DoAddL, DL, SdL, 5, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opdb98, DoAddL, DL, SdL, 5, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opdba0, DoAddL, DL, SdL, 5, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opdba8, DoAddL, DL, SdL, 5, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opdbb0, DoAddL, DL, SdL, 5, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opdbb8, DoAddL, DL, SdL, 5, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opdbc0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Opdbc8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 5, GRL, SRL, 8)
Oper (Opdbd0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Opdbd8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Opdbe0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 5, GRL, SRL, 16)
Oper (Opdbe8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Opdbf0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 5, GRL, SRL, 20)
Oper (Opdbf8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 5, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opdc00, DoAddB, DB, SdB, ins7, DB, DR, Cd, 6, GRB, SRB, 4)
Oper (Opdc10, DoAddB, DB, SainB, ins7, DB, DR, Cd, 6, GRB, SRB, 8)
Oper (Opdc18, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 6, GRB, SRB, 8)
Oper (Opdc20, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 6, GRB, SRB, 12)
Oper (Opdc28, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 6, GRB, SRB, 12)
Oper (Opdc30, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 6, GRB, SRB, 16)
Oper (Opdc38, DoAddB, DB, SearB, ins7, DB, DR, Cd, 6, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opdc40, DoAddW, DW, SdW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Opdc48, DoAddW, DW, SaW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Opdc50, DoAddW, DW, SainW, ins7, DW, DR, Cd, 6, GRW, SRW, 8)
Oper (Opdc58, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 6, GRW, SRW, 8)
Oper (Opdc60, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 6, GRW, SRW, 12)
Oper (Opdc68, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 6, GRW, SRW, 12)
Oper (Opdc70, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 6, GRW, SRW, 16)
Oper (Opdc78, DoAddW, DW, SearW, ins7, DW, DR, Cd, 6, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opdc80, DoAddL, DL, SdL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Opdc88, DoAddL, DL, SaL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Opdc90, DoAddL, DL, SainL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Opdc98, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Opdca0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 6, GRL, SRL, 16)
Oper (Opdca8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 6, GRL, SRL, 20)
Oper (Opdcb0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 6, GRL, SRL, 20)
Oper (Opdcb8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 6, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opdcc0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Opdcc8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Opdcd0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 6, GRL, SRL, 12)
Oper (Opdcd8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 6, GRL, SRL, 12)
Oper (Opdce0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Opdce8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Opdcf0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Opdcf8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 6, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opdd00, DoAddx, DB, SdB, ins7, DB, DR, Cd, 6, GRB, SRB, 4)
Oper (Opdd08, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB, 6, GMB, SMB, 20)
Oper (Opdd10, DoAddB, DB, SdB, 6, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opdd18, DoAddB, DB, SdB, 6, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opdd20, DoAddB, DB, SdB, 6, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opdd28, DoAddB, DB, SdB, 6, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opdd30, DoAddB, DB, SdB, 6, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opdd38, DoAddB, DB, SdB, 6, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opdd40, DoAddx, DW, SdW, ins7, DW, DR, Cd, 6, GRW, SRW, 4)
Oper (Opdd48, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 6, GMW, SMW, 20)
Oper (Opdd50, DoAddW, DW, SdW, 6, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opdd58, DoAddW, DW, SdW, 6, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opdd60, DoAddW, DW, SdW, 6, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opdd68, DoAddW, DW, SdW, 6, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opdd70, DoAddW, DW, SdW, 6, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opdd78, DoAddW, DW, SdW, 6, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opdd80, DoAddx, DL, SdL, ins7, DL, DR, Cd, 6, GRL, SRL, 8)
Oper (Opdd88, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 6, GML, SML, 32)
Oper (Opdd90, DoAddL, DL, SdL, 6, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opdd98, DoAddL, DL, SdL, 6, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opdda0, DoAddL, DL, SdL, 6, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opdda8, DoAddL, DL, SdL, 6, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opddb0, DoAddL, DL, SdL, 6, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opddb8, DoAddL, DL, SdL, 6, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opddc0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Opddc8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 6, GRL, SRL, 8)
Oper (Opddd0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Opddd8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Opdde0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 6, GRL, SRL, 16)
Oper (Opdde8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Opddf0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 6, GRL, SRL, 20)
Oper (Opddf8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 6, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Opde00, DoAddB, DB, SdB, ins7, DB, DR, Cd, 7, GRB, SRB, 4)
Oper (Opde10, DoAddB, DB, SainB, ins7, DB, DR, Cd, 7, GRB, SRB, 8)
Oper (Opde18, DoAddB, DB, SaipB, ins7, DB, DR, Cd, 7, GRB, SRB, 8)
Oper (Opde20, DoAddB, DB, SmaiB, ins7, DB, DR, Cd, 7, GRB, SRB, 12)
Oper (Opde28, DoAddB, DB, SdaiB, ins7, DB, DR, Cd, 7, GRB, SRB, 12)
Oper (Opde30, DoAddB, DB, SaixB, ins7, DB, DR, Cd, 7, GRB, SRB, 16)
Oper (Opde38, DoAddB, DB, SearB, ins7, DB, DR, Cd, 7, GRB, SRB, (cycles+11)&0xfffffffc)
Oper (Opde40, DoAddW, DW, SdW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Opde48, DoAddW, DW, SaW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Opde50, DoAddW, DW, SainW, ins7, DW, DR, Cd, 7, GRW, SRW, 8)
Oper (Opde58, DoAddW, DW, SaipW, ins7, DW, DR, Cd, 7, GRW, SRW, 8)
Oper (Opde60, DoAddW, DW, SmaiW, ins7, DW, DR, Cd, 7, GRW, SRW, 12)
Oper (Opde68, DoAddW, DW, SdaiW, ins7, DW, DR, Cd, 7, GRW, SRW, 12)
Oper (Opde70, DoAddW, DW, SaixW, ins7, DW, DR, Cd, 7, GRW, SRW, 16)
Oper (Opde78, DoAddW, DW, SearW, ins7, DW, DR, Cd, 7, GRW, SRW, (cycles+11)&0xfffffffc)
Oper (Opde80, DoAddL, DL, SdL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Opde88, DoAddL, DL, SaL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Opde90, DoAddL, DL, SainL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Opde98, DoAddL, DL, SaipL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Opdea0, DoAddL, DL, SmaiL, ins7, DL, DR, Cd, 7, GRL, SRL, 16)
Oper (Opdea8, DoAddL, DL, SdaiL, ins7, DL, DR, Cd, 7, GRL, SRL, 20)
Oper (Opdeb0, DoAddL, DL, SaixL, ins7, DL, DR, Cd, 7, GRL, SRL, 20)
Oper (Opdeb8, DoAddL, DL, SearL, ins7, DL, DR, Cd, 7, GRL, SRL, (cycles+19)&0xfffffffc)
Oper (Opdec0, DoAdda, DL, SdW, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Opdec8, DoAdda, DL, SaW, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Opded0, DoAdda, DL, SainW, ins7, DL, DR, Ca, 7, GRL, SRL, 12)
Oper (Opded8, DoAdda, DL, SaipW, ins7, DL, DR, Ca, 7, GRL, SRL, 12)
Oper (Opdee0, DoAdda, DL, SmaiW, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Opdee8, DoAdda, DL, SdaiW, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Opdef0, DoAdda, DL, SaixW, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Opdef8, DoAdda, DL, SearW, ins7, DL, DR, Ca, 7, GRL, SRL, (cycles+15)&0xfffffffc)

Oper (Opdf00, DoAddx, DB, SdB, ins7, DB, DR, Cd, 7, GRB, SRB, 4)
Oper (Opdf08, DoAddx, DB, SmaiB, ins7, DB, DA, CmaiB15, 7, GMB, SMB, 20)
Oper (Opdf10, DoAddB, DB, SdB, 7, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Opdf18, DoAddB, DB, SdB, 7, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Opdf20, DoAddB, DB, SdB, 7, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Opdf28, DoAddB, DB, SdB, 7, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Opdf30, DoAddB, DB, SdB, 7, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Opdf38, DoAddB, DB, SdB, 7, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Opdf40, DoAddx, DW, SdW, ins7, DW, DR, Cd, 7, GRW, SRW, 4)
Oper (Opdf48, DoAddx, DW, SmaiW, ins7, DW, DA, CmaiW, 7, GMW, SMW, 20)
Oper (Opdf50, DoAddW, DW, SdW, 7, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Opdf58, DoAddW, DW, SdW, 7, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Opdf60, DoAddW, DW, SdW, 7, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Opdf68, DoAddW, DW, SdW, 7, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Opdf70, DoAddW, DW, SdW, 7, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Opdf78, DoAddW, DW, SdW, 7, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Opdf80, DoAddx, DL, SdL, ins7, DL, DR, Cd, 7, GRL, SRL, 8)
Oper (Opdf88, DoAddx, DL, SmaiL, ins7, DL, DA, CmaiL, 7, GML, SML, 32)
Oper (Opdf90, DoAddL, DL, SdL, 7, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Opdf98, DoAddL, DL, SdL, 7, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Opdfa0, DoAddL, DL, SdL, 7, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Opdfa8, DoAddL, DL, SdL, 7, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Opdfb0, DoAddL, DL, SdL, 7, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Opdfb8, DoAddL, DL, SdL, 7, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
Oper (Opdfc0, DoAdda, DL, SdL, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Opdfc8, DoAdda, DL, SaL, ins7, DL, DR, Ca, 7, GRL, SRL, 8)
Oper (Opdfd0, DoAdda, DL, SainL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Opdfd8, DoAdda, DL, SaipL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Opdfe0, DoAdda, DL, SmaiL, ins7, DL, DR, Ca, 7, GRL, SRL, 16)
Oper (Opdfe8, DoAdda, DL, SdaiL, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Opdff0, DoAdda, DL, SaixL, ins7, DL, DR, Ca, 7, GRL, SRL, 20)
Oper (Opdff8, DoAdda, DL, SearL, ins7, DL, DR, Ca, 7, GRL, SRL, (cycles+19)&0xfffffffc)

Oper (Op0600, DoAddB, DB, SimmB, 0, DB, DR, Cd, ins7, GRB, SRB, 8)
Oper (Op0610, DoAddB, DB, SimmB, 0, DB, DA, Cain, ins7, GMB, SMB, 16)
Oper (Op0618, DoAddB, DB, SimmB, 0, DB, DA, CaipB, ins7, GMB, SMB, 16)
Oper (Op0620, DoAddB, DB, SimmB, 0, DB, DA, CmaiB, ins7, GMB, SMB, 20)
Oper (Op0628, DoAddB, DB, SimmB, 0, DB, DA, Cdai, ins7, GMB, SMB, 20)
Oper (Op0630, DoAddB, DB, SimmB, 0, DB, DA, Caix, ins7, GMB, SMB, 24)
Oper (Op0638, DoAddB, DB, SimmB, 0, DB, DA, Ceaw, ins7, GMB, SMB, (cycles+23)&0xfffffffc)
Oper (Op0640, DoAddW, DW, SimmW, 0, DW, DR, Cd, ins7, GRW, SRW, 8)
Oper (Op0650, DoAddW, DW, SimmW, 0, DW, DA, Cain, ins7, GMW, SMW, 16)
Oper (Op0658, DoAddW, DW, SimmW, 0, DW, DA, CaipW, ins7, GMW, SMW, 16)
Oper (Op0660, DoAddW, DW, SimmW, 0, DW, DA, CmaiW, ins7, GMW, SMW, 20)
Oper (Op0668, DoAddW, DW, SimmW, 0, DW, DA, Cdai, ins7, GMW, SMW, 20)
Oper (Op0670, DoAddW, DW, SimmW, 0, DW, DA, Caix, ins7, GMW, SMW, 24)
Oper (Op0678, DoAddW, DW, SimmW, 0, DW, DA, Ceaw, ins7, GMW, SMW, (cycles+23)&0xfffffffc)
Oper (Op0680, DoAddL, DL, SimmL, 0, DL, DR, Cd, ins7, GRL, SRL, 16)
Oper (Op0690, DoAddL, DL, SimmL, 0, DL, DA, Cain, ins7, GML, SML, 28)
Oper (Op0698, DoAddL, DL, SimmL, 0, DL, DA, CaipL, ins7, GML, SML, 28)
Oper (Op06a0, DoAddL, DL, SimmL, 0, DL, DA, CmaiL, ins7, GML, SML, 32)
Oper (Op06a8, DoAddL, DL, SimmL, 0, DL, DA, Cdai, ins7, GML, SML, 32)
Oper (Op06b0, DoAddL, DL, SimmL, 0, DL, DA, Caix, ins7, GML, SML, 36)
Oper (Op06b8, DoAddL, DL, SimmL, 0, DL, DA, Ceaw, ins7, GML, SML, (cycles+35)&0xfffffffc)

Oper (Op5000, DoAddB, DB, Ss, 8, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5010, DoAddB, DB, Ss, 8, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5018, DoAddB, DB, Ss, 8, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5020, DoAddB, DB, Ss, 8, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5028, DoAddB, DB, Ss, 8, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5030, DoAddB, DB, Ss, 8, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5038, DoAddB, DB, Ss, 8, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5040, DoAddW, DW, Ss, 8, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5048, DoAdda, DL, Ss, 8, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5050, DoAddW, DW, Ss, 8, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5058, DoAddW, DW, Ss, 8, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5060, DoAddW, DW, Ss, 8, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5068, DoAddW, DW, Ss, 8, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5070, DoAddW, DW, Ss, 8, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5078, DoAddW, DW, Ss, 8, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5080, DoAddL, DL, Ss, 8, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5088, DoAdda, DL, Ss, 8, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5090, DoAddL, DL, Ss, 8, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5098, DoAddL, DL, Ss, 8, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op50a0, DoAddL, DL, Ss, 8, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op50a8, DoAddL, DL, Ss, 8, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op50b0, DoAddL, DL, Ss, 8, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op50b8, DoAddL, DL, Ss, 8, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5200, DoAddB, DB, Ss, 1, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5210, DoAddB, DB, Ss, 1, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5218, DoAddB, DB, Ss, 1, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5220, DoAddB, DB, Ss, 1, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5228, DoAddB, DB, Ss, 1, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5230, DoAddB, DB, Ss, 1, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5238, DoAddB, DB, Ss, 1, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5240, DoAddW, DW, Ss, 1, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5248, DoAdda, DL, Ss, 1, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5250, DoAddW, DW, Ss, 1, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5258, DoAddW, DW, Ss, 1, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5260, DoAddW, DW, Ss, 1, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5268, DoAddW, DW, Ss, 1, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5270, DoAddW, DW, Ss, 1, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5278, DoAddW, DW, Ss, 1, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5280, DoAddL, DL, Ss, 1, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5288, DoAdda, DL, Ss, 1, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5290, DoAddL, DL, Ss, 1, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5298, DoAddL, DL, Ss, 1, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op52a0, DoAddL, DL, Ss, 1, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op52a8, DoAddL, DL, Ss, 1, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op52b0, DoAddL, DL, Ss, 1, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op52b8, DoAddL, DL, Ss, 1, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5400, DoAddB, DB, Ss, 2, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5410, DoAddB, DB, Ss, 2, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5418, DoAddB, DB, Ss, 2, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5420, DoAddB, DB, Ss, 2, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5428, DoAddB, DB, Ss, 2, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5430, DoAddB, DB, Ss, 2, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5438, DoAddB, DB, Ss, 2, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5440, DoAddW, DW, Ss, 2, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5448, DoAdda, DL, Ss, 2, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5450, DoAddW, DW, Ss, 2, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5458, DoAddW, DW, Ss, 2, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5460, DoAddW, DW, Ss, 2, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5468, DoAddW, DW, Ss, 2, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5470, DoAddW, DW, Ss, 2, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5478, DoAddW, DW, Ss, 2, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5480, DoAddL, DL, Ss, 2, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5488, DoAdda, DL, Ss, 2, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5490, DoAddL, DL, Ss, 2, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5498, DoAddL, DL, Ss, 2, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op54a0, DoAddL, DL, Ss, 2, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op54a8, DoAddL, DL, Ss, 2, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op54b0, DoAddL, DL, Ss, 2, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op54b8, DoAddL, DL, Ss, 2, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5600, DoAddB, DB, Ss, 3, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5610, DoAddB, DB, Ss, 3, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5618, DoAddB, DB, Ss, 3, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5620, DoAddB, DB, Ss, 3, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5628, DoAddB, DB, Ss, 3, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5630, DoAddB, DB, Ss, 3, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5638, DoAddB, DB, Ss, 3, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5640, DoAddW, DW, Ss, 3, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5648, DoAdda, DL, Ss, 3, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5650, DoAddW, DW, Ss, 3, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5658, DoAddW, DW, Ss, 3, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5660, DoAddW, DW, Ss, 3, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5668, DoAddW, DW, Ss, 3, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5670, DoAddW, DW, Ss, 3, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5678, DoAddW, DW, Ss, 3, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5680, DoAddL, DL, Ss, 3, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5688, DoAdda, DL, Ss, 3, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5690, DoAddL, DL, Ss, 3, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5698, DoAddL, DL, Ss, 3, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op56a0, DoAddL, DL, Ss, 3, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op56a8, DoAddL, DL, Ss, 3, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op56b0, DoAddL, DL, Ss, 3, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op56b8, DoAddL, DL, Ss, 3, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5800, DoAddB, DB, Ss, 4, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5810, DoAddB, DB, Ss, 4, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5818, DoAddB, DB, Ss, 4, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5820, DoAddB, DB, Ss, 4, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5828, DoAddB, DB, Ss, 4, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5830, DoAddB, DB, Ss, 4, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5838, DoAddB, DB, Ss, 4, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5840, DoAddW, DW, Ss, 4, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5848, DoAdda, DL, Ss, 4, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5850, DoAddW, DW, Ss, 4, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5858, DoAddW, DW, Ss, 4, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5860, DoAddW, DW, Ss, 4, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5868, DoAddW, DW, Ss, 4, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5870, DoAddW, DW, Ss, 4, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5878, DoAddW, DW, Ss, 4, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5880, DoAddL, DL, Ss, 4, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5888, DoAdda, DL, Ss, 4, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5890, DoAddL, DL, Ss, 4, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5898, DoAddL, DL, Ss, 4, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op58a0, DoAddL, DL, Ss, 4, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op58a8, DoAddL, DL, Ss, 4, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op58b0, DoAddL, DL, Ss, 4, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op58b8, DoAddL, DL, Ss, 4, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5a00, DoAddB, DB, Ss, 5, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5a10, DoAddB, DB, Ss, 5, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5a18, DoAddB, DB, Ss, 5, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5a20, DoAddB, DB, Ss, 5, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5a28, DoAddB, DB, Ss, 5, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5a30, DoAddB, DB, Ss, 5, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5a38, DoAddB, DB, Ss, 5, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5a40, DoAddW, DW, Ss, 5, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5a48, DoAdda, DL, Ss, 5, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5a50, DoAddW, DW, Ss, 5, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5a58, DoAddW, DW, Ss, 5, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5a60, DoAddW, DW, Ss, 5, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5a68, DoAddW, DW, Ss, 5, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5a70, DoAddW, DW, Ss, 5, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5a78, DoAddW, DW, Ss, 5, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5a80, DoAddL, DL, Ss, 5, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5a88, DoAdda, DL, Ss, 5, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5a90, DoAddL, DL, Ss, 5, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5a98, DoAddL, DL, Ss, 5, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5aa0, DoAddL, DL, Ss, 5, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5aa8, DoAddL, DL, Ss, 5, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5ab0, DoAddL, DL, Ss, 5, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5ab8, DoAddL, DL, Ss, 5, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5c00, DoAddB, DB, Ss, 6, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5c10, DoAddB, DB, Ss, 6, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5c18, DoAddB, DB, Ss, 6, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5c20, DoAddB, DB, Ss, 6, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5c28, DoAddB, DB, Ss, 6, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5c30, DoAddB, DB, Ss, 6, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5c38, DoAddB, DB, Ss, 6, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5c40, DoAddW, DW, Ss, 6, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5c48, DoAdda, DL, Ss, 6, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5c50, DoAddW, DW, Ss, 6, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5c58, DoAddW, DW, Ss, 6, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5c60, DoAddW, DW, Ss, 6, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5c68, DoAddW, DW, Ss, 6, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5c70, DoAddW, DW, Ss, 6, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5c78, DoAddW, DW, Ss, 6, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5c80, DoAddL, DL, Ss, 6, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5c88, DoAdda, DL, Ss, 6, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5c90, DoAddL, DL, Ss, 6, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5c98, DoAddL, DL, Ss, 6, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5ca0, DoAddL, DL, Ss, 6, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5ca8, DoAddL, DL, Ss, 6, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5cb0, DoAddL, DL, Ss, 6, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5cb8, DoAddL, DL, Ss, 6, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)

Oper (Op5e00, DoAddB, DB, Ss, 7, DB, DR, Cd, ins7, GRB, SRB, 4)
Oper (Op5e10, DoAddB, DB, Ss, 7, DB, DA, Cain, ins7, GMB, SMB, 12)
Oper (Op5e18, DoAddB, DB, Ss, 7, DB, DA, CaipB, ins7, GMB, SMB, 12)
Oper (Op5e20, DoAddB, DB, Ss, 7, DB, DA, CmaiB, ins7, GMB, SMB, 16)
Oper (Op5e28, DoAddB, DB, Ss, 7, DB, DA, Fdai, ins7, GMB, SMB, 16)
Oper (Op5e30, DoAddB, DB, Ss, 7, DB, DA, Faix, ins7, GMB, SMB, 20)
Oper (Op5e38, DoAddB, DB, Ss, 7, DB, DA, Feaw, ins7, GMB, SMB, (cycles+19)&0xfffffffc)
Oper (Op5e40, DoAddW, DW, Ss, 7, DW, DR, Cd, ins7, GRW, SRW, 4)
Oper (Op5e48, DoAdda, DL, Ss, 7, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5e50, DoAddW, DW, Ss, 7, DW, DA, Cain, ins7, GMW, SMW, 12)
Oper (Op5e58, DoAddW, DW, Ss, 7, DW, DA, CaipW, ins7, GMW, SMW, 12)
Oper (Op5e60, DoAddW, DW, Ss, 7, DW, DA, CmaiW, ins7, GMW, SMW, 16)
Oper (Op5e68, DoAddW, DW, Ss, 7, DW, DA, Fdai, ins7, GMW, SMW, 16)
Oper (Op5e70, DoAddW, DW, Ss, 7, DW, DA, Faix, ins7, GMW, SMW, 20)
Oper (Op5e78, DoAddW, DW, Ss, 7, DW, DA, Feaw, ins7, GMW, SMW, (cycles+19)&0xfffffffc)
Oper (Op5e80, DoAddL, DL, Ss, 7, DL, DR, Cd, ins7, GRL, SRL, 8)
Oper (Op5e88, DoAdda, DL, Ss, 7, DL, DR, Ca, ins7, GRL, SRL, 8)
Oper (Op5e90, DoAddL, DL, Ss, 7, DL, DA, Cain, ins7, GML, SML, 20)
Oper (Op5e98, DoAddL, DL, Ss, 7, DL, DA, CaipL, ins7, GML, SML, 20)
Oper (Op5ea0, DoAddL, DL, Ss, 7, DL, DA, CmaiL, ins7, GML, SML, 24)
Oper (Op5ea8, DoAddL, DL, Ss, 7, DL, DA, Fdai, ins7, GML, SML, 24)
Oper (Op5eb0, DoAddL, DL, Ss, 7, DL, DA, Faix, ins7, GML, SML, 28)
Oper (Op5eb8, DoAddL, DL, Ss, 7, DL, DA, Feaw, ins7, GML, SML, (cycles+27)&0xfffffffc)
