
#ifndef h_stkeys_h
#define h_stkeys_h

#define JOY_UP       1
#define JOY_DOWN     2
#define JOY_LEFT     4
#define JOY_RIGHT    8
#define JOY_BUTTON 128

#define ST_ESC		0x01
#define ST_1		0x02
#define ST_2		0x03
#define ST_3		0x04
#define ST_4		0x05
#define ST_5		0x06
#define ST_6		0x07
#define ST_7		0x08
#define ST_8		0x09
#define ST_9		0x0a
#define ST_0		0x0b
#define ST_MINUS	0x0c
#define ST_EQUAL	0x0d
#define ST_BS		0x0e
#define ST_TAB		0x0f
#define ST_Q		0x10
#define ST_W		0x11
#define ST_E		0x12
#define ST_R		0x13
#define ST_T		0x14
#define ST_Y		0x15
#define ST_U		0x16
#define ST_I		0x17
#define ST_O		0x18
#define ST_P		0x19
#define ST_SQ_OPEN	0x1a	/* [ */
#define ST_SQ_CLOSE     0x1b	/* ] */
#define ST_RETURN	0x1c
#define ST_CONTROL	0x1d
#define ST_A		0x1e
#define ST_S		0x1f
#define ST_D		0x20
#define ST_F		0x21
#define ST_G		0x22
#define ST_H		0x23
#define ST_J		0x24
#define ST_K		0x25
#define ST_L		0x26
#define ST_SEMIC	0x27	/* ; */
#define ST_APOST	0x28	/* ' */
#define ST_GRAVE	0x29	/* ` */
#define ST_LSH		0x2a	/* left shift */
#define ST_BACKSL	0x2b	/* \ */
#define ST_Z		0x2c
#define ST_X		0x2d
#define ST_C		0x2e
#define ST_V		0x2f
#define ST_B		0x30
#define ST_N		0x31
#define ST_M		0x32
#define ST_COMMA	0x33
#define ST_DOT		0x34
#define ST_SLASH	0x35
#define ST_RSH		0x36	/* right shift */
#if 0
#define ST_PRINT        0x37    /* PrintScreen on PC keyboard */
#endif
#define ST_ALT		0x38
#define ST_SPACE	0x39
#define ST_CAPSLOCK	0x3a
#define ST_F1		0x3b
#define ST_F2		0x3c
#define ST_F3		0x3d
#define ST_F4		0x3e
#define ST_F5		0x3f
#define ST_F6		0x40
#define ST_F7		0x41
#define ST_F8		0x42
#define ST_F9		0x43
#define ST_F10		0x44

#define ST_HOME		0x47
#define ST_UP		0x48
#define ST_PG_UP        0x49    /* PageUp on Mac/PC keyboard */
#define ST_KP_MINUS     0x4a
#define ST_LEFT		0x4b
#if 0
#define ST_CENTER_CURSOR 0x4c
#endif
#define ST_RIGHT	0x4d
#define ST_KP_PLUS	0x4e
#define ST_END          0x4f    /* End on Mac/PC keyboard */
#define ST_DOWN		0x50
#define ST_PG_DN        0x51    /* PageDown on Mac/PC keyboard */
#define ST_INSERT	0x52
#define ST_DELETE	0x53
#if 0
#define ST_F11          0x54
#define ST_F12          0x55
#define ST_F13          0x56
#define ST_F14          0x57
#define ST_F15          0x58
#define ST_F16          0x59
#define ST_F17          0x5a
#define ST_F18          0x5b
#define ST_F19          0x5c
#define ST_F20          0x5d
#define ST_F21          0x5e
#define ST_F22          0x5f
#endif
#define ST_ISO		0x60	/* The 'Atari' Key */
#define ST_UNDO		0x61
#define ST_HELP		0x62
#define ST_KP_OPEN	0x63	/* Keypad ( */
#define ST_KP_CLOSE     0x64	/* Keypad ) */
#define ST_KP_DIV	0x65	/* Keypad / */
#define ST_KP_MULT	0x66	/* Keypad * */
#define ST_KP_7		0x67
#define ST_KP_8		0x68
#define ST_KP_9		0x69
#define ST_KP_4		0x6a
#define ST_KP_5		0x6b
#define ST_KP_6		0x6c
#define ST_KP_1		0x6d
#define ST_KP_2		0x6e
#define ST_KP_3		0x6f
#define ST_KP_0		0x70
#define ST_KP_DOT	0x71	/* Keypad . */
#define ST_KP_ENTER     0x72
#if 0
#define ST_CTRL_LFT     0x73
#define ST_CTRL_RGT     0x74
#define ST_CTRL_END     0x75
#define ST_CTRL_PG_DN   0x76
#define ST_CTRL_HOME    0x77
#define ST_ALT_1        0x78
#define ST_ALT_2        0x79
#define ST_ALT_3        0x7a
#define ST_ALT_4        0x7b
#define ST_ALT_5        0x7c
#define ST_ALT_6        0x7d
#define ST_ALT_7        0x7e
#define ST_ALT_8        0x7f
#define ST_ALT_9        0x80
#define ST_ALT_0        0x81
#define ST_ALT_MINUS    0x82
#define ST_ALT_EQUAL    0x83
#define ST_CTRL_PG_UP   0x84
#endif

#endif
