//////////////////////////////////////////////////////////////////////
// 
// File:        LSoundPlayer.h
// Author:      Brian Postma
// Created:     30 December 1999
//
// Purpose:     The hardware/OS dependent soundplayer layer. Provides
//              all means and methods to play sounds.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_)
#define AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define BUFFERSIZE SAMPLERATE/25

#include "bstypes.h"
#include "LChannel.h"
#include "Module.h"
#include <dc/sound/sound.h>
#include <dc/sound/stream.h>

class LSoundPlayer
{
public:
	LSoundPlayer(Module *modptr);
	LSoundPlayer *GetInstance();
	virtual ~LSoundPlayer();
	void CleanUp();
	bool Initialize(short nrofvoices, bool stereo=true);
	bool Play(short voicenr, BYTE instrument, int frequency, int volume);
	bool Stop(short voicenr);
	bool SetPan(short voicenr, int val);
	bool SetFrequency(short voicenr, int frequency);
	bool SetVolume(short voicenr, int volume);
	bool Update(short voicenr, BYTE *memptr, int offset, int numofbytes);
        bool Mix();
	inline short *GetBuffer()
	{
		return playbuffer;
	}
	unsigned int vol_data[4];
	short abs(short in)
	{
		if (in<0)
			return -in;
		else
			return in;
	}

private:
	static LSoundPlayer		*current;
        Module				*modptr;
	short				nrofvoices;
        int				stereo;
        int				soundhandle;
        LChannel			*channels;
        short				*playbuffer;
        volatile unsigned int 		*soundpos;
        volatile int 			idx_buf;
        int				lastpos;
};

#endif // !defined(AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_)
