//////////////////////////////////////////////////////////////////////
// 
// File:        LChannel.cpp
// Author:      Brian Postma
// Created:     30 December 1999
//
// Purpose:     Stores data for each channel, including mixer data.
//
//////////////////////////////////////////////////////////////////////

#include "LChannel.h"

LChannel::LChannel()
{
  memptr=NULL;
  size=0;
  repeat=0;
  replen=0;
  volume=0;
  leftchannel=true;
  playcursor=0;
  altmemptr=NULL;
  offset=0;
  numofbytes=0;
  count=0;
  playing=false;
}


LChannel::~LChannel()
{
}


void LChannel::SetPlayBuffer(BYTE *memptr, WORD size, WORD repeat, WORD replen)
{
  this->memptr=memptr;
  this->size=size;
  this->repeat=repeat;
  this->replen=replen;
  this->playcursor=0;
  this->altmemptr=NULL;
  this->offset=0;
  this->numofbytes=0;
  count=0;
}
  

void LChannel::GetNextBytes(BYTE &left, BYTE &right)
{
  int newval;
  left=128;
  right=128;

  if (!playing || memptr==NULL)
  {
    return;
  }
  if (numofbytes!=0 && playcursor>=offset && playcursor<=(offset+numofbytes))
  { // updated waveform
    newval=*(altmemptr+playcursor-offset);
  }
  else
  {
    newval=*(memptr+playcursor);
  }
  newval=((newval-128)*volume)>>6; //64
  if (leftchannel)
    left=newval+128;
  else
    right=newval+128;
  count+=(1<<13);
  while (count>=freqrepeat)
  {
    count=count-freqrepeat;
    playcursor++;
    if (replen>2)
    {
      if (playcursor>=(repeat+replen))
        playcursor=repeat;    // for repeating samples
    }
    else
    {
      if (playcursor>=size)    // non repeating
        playing=false;
    }
  }
}


void LChannel::Update(BYTE *memptr, WORD offset, WORD numofbytes)
{
  this->altmemptr=memptr;
  this->offset=offset;
  this->numofbytes=numofbytes;
}




void LChannel::GetShowBuf(BYTE *ptr)
{
  BYTE *tmp; 
  int  val;
 
  if (numofbytes!=0 && playcursor>=offset && playcursor<=(offset+numofbytes))
    tmp=altmemptr;
  else
    tmp=memptr;
  if (size>128)
    tmp+=playcursor; // I guess this is a sample and not a synth sound
  
  for (short i=0; i<32; i++)
  {
    val=*(tmp++)-128;
    val=(val*volume)>>6;
    *(ptr++)=val+128;
  }
}
