#include "Game.h"
#include <time.h>
#include <stdlib.h>
#include <kos.h>

bool		ingame=false;
bool		showtitle=true;
bool		scared=false;
bool		dying=false;

const int	screendelay=120;
const int	scrsize=nrofblocks*blocksize;
const int	animdelay=12;
const int	pacanimdelay=3;
const int	ghostanimcount=3;
const int	pacmananimcount=4;
const int	pacmanspeed=4;

int			count=screendelay;
int			ghostanimpos=0;
int			pacmananimpos=0;
int			nrofghosts;
int			pacsleft,score;
int			deathcounter;
int			dx[4],dy[4];
int			ghostx[maxghosts], ghosty[maxghosts], ghostdx[maxghosts];
int			ghostdy[maxghosts], ghostspeed[maxghosts];
int			ghostrot[maxghosts];

int			pacmanx, pacmany, pacmandx, pacmandy;
int			reqdx, reqdy, viewdx, viewdy;
int			scaredcount, scaredtime;
const int	maxscaredtime=200;
const int	minscaredtime=50;

const int	validspeeds[] = { 1,2,3,4,6,6 };
const int	maxspeed=6;

int			currentspeed=3;
char		screendata[nrofblocks*nrofblocks];

extern snd_stream_hnd_t	stream;

char   level1data[nrofblocks*nrofblocks] = { 
	19,26,26,22, 9,12,19,26,22, 9,12,19,26,26,22,
	37,11,14,17,26,26,20,15,17,26,26,20,11,14,37,
	17,26,26,20,11, 6,17,26,20, 3,14,17,26,26,20,
	21, 3, 6,25,22, 5,21, 7,21, 5,19,28, 3, 6,21,
	21, 9, 8,14,21,13,21, 5,21,13,21,11, 8,12,21,
	25,18,26,18,24,18,28, 5,25,18,24,18,26,18,28,
	 6,21, 7,21, 7,21,11, 8,14,21, 7,21, 7,21,03,
	 4,21, 5,21, 5,21,11,10,14,21, 5,21, 5,21, 1,
	12,21,13,21,13,21,11,10,14,21,13,21,13,21, 9,
	19,24,26,24,26,16,26,18,26,16,26,24,26,24,22,
	21, 3, 2, 2, 6,21,15,21,15,21, 3, 2, 2,06,21,
	21, 9, 8, 8, 4,17,26, 8,26,20, 1, 8, 8,12,21,
	17,26,26,22,13,21,11, 2,14,21,13,19,26,26,20,
	37,11,14,17,26,24,22,13,19,24,26,20,11,14,37,
	25,26,26,28, 3, 6,25,26,28, 3, 6,25,26,26,28  };


float Random(float min, float max)
{
	return float(double(rand())/RAND_MAX)*(max-min)+min;
}


void GameInit()
{
    pacsleft=3;
    score=0;
    scaredtime=maxscaredtime;
    LevelInit();
    nrofghosts=4;
    currentspeed=2;
    scaredtime=maxscaredtime;
}


void LevelInit()
{
    int  i;
    for (i=0; i<nrofblocks*nrofblocks; i++)
      screendata[i]=level1data[i];

    LevelContinue();
	viewdx=1;
	viewdy=0;
}


void LevelContinue()
{
    short i;
    int dx=1;
    int random;

    for (i=0; i<nrofghosts; i++)
    {
      ghosty[i]=7*blocksize;
      ghostx[i]=7*blocksize;
      ghostdy[i]=0;
      ghostdx[i]=dx;
	  ghostrot[i]=0;
      dx=-dx;
      random=(int)(Random(0,1)*float(currentspeed));
      if (random>(currentspeed-1))
        random=currentspeed-1;
      ghostspeed[i]=validspeeds[random];
    }
    screendata[7*nrofblocks+6]=10;
    screendata[7*nrofblocks+8]=10;
    pacmanx=7*blocksize;
    pacmany=11*blocksize;
    pacmandx=0;
    pacmandy=0;
    reqdx=0;
    reqdy=0;
    viewdx=-1;
    viewdy=0;
    dying=false;
    scared=false;
}


void PlayGame()
{
    if (dying)
    {
      Death();
    }
    else
    {
      CheckScared();
      MovePacMan();
      MoveGhosts();
      CheckMaze();
    }  
}


void PlayDemo()
{
    CheckScared();
    MoveGhosts();
//    ShowIntroScreen();
}


void Death()
{
    int k;

    deathcounter--;
/*  k=(deathcounter&15)/4;
    switch(k)
    {
      case 0:
        goff.drawImage(pacman4up,pacmanx+1,pacmany+1,this);
        break;
      case 1:
        goff.drawImage(pacman4right,pacmanx+1,pacmany+1,this);
        break;
      case 2:
        goff.drawImage(pacman4down,pacmanx+1,pacmany+1,this);
        break;
      default:
        goff.drawImage(pacman4left,pacmanx+1,pacmany+1,this);
    }
	*/
    if (deathcounter==0)
    {
      pacsleft--;
      if (pacsleft==0)
        ingame=false;
      LevelContinue();
    }
}


void MoveGhosts()
{
    short i;
    int pos;
    int count,t;

    for (i=0; i<nrofghosts; i++)
    {
      if (ghostx[i]%blocksize==0 && ghosty[i]%blocksize==0)
      {
        pos=ghostx[i]/blocksize+nrofblocks*(int)(ghosty[i]/blocksize);

        count=0;
        if ((screendata[pos]&1)==0 && ghostdx[i]!=1)
        {
          dx[count]=-1;
          dy[count]=0;
          count++;
        }
        if ((screendata[pos]&2)==0 && ghostdy[i]!=1)
        {
          dx[count]=0;
          dy[count]=-1;
          count++;
        }
        if ((screendata[pos]&4)==0 && ghostdx[i]!=-1)
        {
          dx[count]=1;
          dy[count]=0;
          count++;
        }
        if ((screendata[pos]&8)==0 && ghostdy[i]!=-1)
        {
          dx[count]=0;
          dy[count]=1;
          count++;
        }
        if (count==0)
        {
          if ((screendata[pos]&15)==15)
          {
            ghostdx[i]=0;
            ghostdy[i]=0;
          }
          else
          {
            ghostdx[i]=-ghostdx[i];
            ghostdy[i]=-ghostdy[i];
          }
        }
        else
        {
          t=(int)(Random(0,1)*float(count));
          if (t>(count-1)) t=count-1;
          ghostdx[i]=dx[t];
          ghostdy[i]=dy[t];
        }
      }
      ghostx[i]=ghostx[i]+(ghostdx[i]*ghostspeed[i]);
      ghosty[i]=ghosty[i]+(ghostdy[i]*ghostspeed[i]);
//      DrawGhost(ghostx[i]+1,ghosty[i]+1);

      if (pacmanx>(ghostx[i]-12) && pacmanx<(ghostx[i]+12) &&
          pacmany>(ghosty[i]-12) && pacmany<(ghosty[i]+12) && ingame)
      {
        if (scared)
        {
          score+=10;
          ghostx[i]=7*blocksize;
          ghosty[i]=7*blocksize;
        }
        else
        {
          dying=true;
          deathcounter=64;
        }
      }
    }
}


void MovePacMan()
{
    int     pos;
    char    ch;

    if (reqdx==-pacmandx && reqdy==-pacmandy && (reqdx!=0 || reqdy!=0))
    {
      pacmandx=reqdx;
      pacmandy=reqdy;
      viewdx=pacmandx;
      viewdy=pacmandy;
    }
    if (pacmanx%blocksize==0 && pacmany%blocksize==0)
    {
      pos=pacmanx/blocksize+nrofblocks*(int)(pacmany/blocksize);
      ch=screendata[pos];
      if ((ch&16)!=0)
      {
        screendata[pos]=(ch&15);
        score++;
      }
      if ((ch&32)!=0)
      {
        scared=true;
        scaredcount=scaredtime;
        screendata[pos]=(ch&15);
        score+=5;
      }

      if (reqdx!=0 || reqdy!=0)
      {
        if (!( (reqdx==-1 && reqdy==0 && (ch&1)!=0) ||
           (reqdx==1 && reqdy==0 && (ch&4)!=0) ||
           (reqdx==0 && reqdy==-1 && (ch&2)!=0) ||
           (reqdx==0 && reqdy==1 && (ch&8)!=0)))
        {
          pacmandx=reqdx;
          pacmandy=reqdy;
          viewdx=pacmandx;
          viewdy=pacmandy;
        }
      }
 
      // Check for standstill
      if ( (pacmandx==-1 && pacmandy==0 && (ch&1)!=0) ||
           (pacmandx==1 && pacmandy==0 && (ch&4)!=0) ||
           (pacmandx==0 && pacmandy==-1 && (ch&2)!=0) ||
           (pacmandx==0 && pacmandy==1 && (ch&8)!=0))
      {
        pacmandx=0;
        pacmandy=0;
      }
    }
    pacmanx=pacmanx+pacmanspeed*pacmandx;
    pacmany=pacmany+pacmanspeed*pacmandy;
}


/*void DrawPacMan()
{
    if (viewdx==-1)
      DrawPacManLeft();
    else if (viewdx==1)
      DrawPacManRight();
    else if (viewdy==-1)
      DrawPacManUp();
    else
      DrawPacManDown();

}*/


void CheckScared()
{
    scaredcount--;
    if (scaredcount<=0)
      scared=false;

    if (scared)
    {
      screendata[7*nrofblocks+6]=11;
      screendata[7*nrofblocks+8]=14;
    }
    else
    {
      screendata[7*nrofblocks+6]=10;
      screendata[7*nrofblocks+8]=10;
    }
}


void CheckMaze()
{
    short i=0;
    bool finished=true;

    while (i<nrofblocks*nrofblocks && finished)
    {
      if ((screendata[i]&48)!=0)
        finished=false;
      i++;
    }
    if (finished)
    {
      score+=50;
      for (i=0; i<30; i++)
      {
        timer_spin_sleep(100);
        snd_stream_poll(stream);
      }
      if (nrofghosts < maxghosts)
        nrofghosts++; 
      if (currentspeed<maxspeed)
        currentspeed++;
      scaredtime=scaredtime-20;
      if (scaredtime<minscaredtime)
        scaredtime=minscaredtime;
      LevelInit();
    }
}


