
#include <stdio.h>			// Header File For Standard Input/Output
#include "DrawStuff.h"
#include "Player.h"
#include "Module.h"
#include "Framework.h"
#include "Music.h"

#define JOYC 40

#include <GL/glut.h> //glutSwapBuffers();

extern snd_stream_hnd_t	stream;

Player		*player=NULL;
Module		*module=NULL;

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)		// Resize And Initialize The GL Window
{
	if (height==0)										// Prevent A Divide By Zero By
	{
		height=1;										// Making Height Equal One
	}

	glViewport(0,0,width,height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);
//	glOrtho(-1.3f,1.3f,-1.3f,1.3f,-0.1f,100.0f);				// Create Ortho 640x480 View (0,0 At Top Left)

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}

void InitGL(GLvoid)										// All Setup For OpenGL Goes Here
{
//	glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping ( NEW )
	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations

	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	ReSizeGLScene(640,480);

	InitStuff();
//	glGenTextures(2, &texture[0]);					// Create The Texture
//	LoadResTexture(IDB_TEXTURE_1,0);
//	LoadResTexture(IDB_TEXTURE_2,1);
}


void DrawGLScene(GLvoid)									// Here's Where We Do All The Drawing
{
	snd_stream_poll(stream);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

	ShowAll();
}

void ResetDC()
{
	arch_exit();
}

GLvoid KillGLWindow(GLvoid)								// Properly Kill The Window
{
	ResetDC();
}

void StartMusic()
{
	StopMusic();
	module=new Module(modje);
	if (module!=NULL)
	{
		if (module->Init()==BS_OK)
		{
			player=new Player(module);
			player->Start();
		}
	}
}

void StopMusic()
{
	if (player!=NULL)
	{
		player->Stop();
		delete player;
		player=NULL;
	}
	if (module!=NULL)
	{
		delete module;
		module=NULL;
	}
}


pvr_init_params_t params = {
        /* Enable opaque and translucent polygons with size 16 */
        { PVR_BINSIZE_16, PVR_BINSIZE_0, PVR_BINSIZE_16, PVR_BINSIZE_0, PVR_BINSIZE_0 },

        /* Vertex buffer size 512K */
        512*1024
};

int main(int argc, char **argv) {
	maple_device_t *cont;
    cont_state_t *cond;

	/* Initialize KOS */
	pvr_init(&params);

	/* Get basic stuff initialized */
	glKosInit();
	snd_init();
	StartMusic();
	InitGL();
	
	cont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	if (cont == NULL) return -1;

	while(1) {
		/* Check key status */
		cond = (cont_state_t *) maple_dev_status(cont);
		if (cond){   
			if (cond->buttons & CONT_START)
				break;
			TranslateKeys(cond);
		}

		/* Draw the GL "scene" */
		DrawGLScene();

		/* Finish the frame */
		glutSwapBuffers();
		
	}
	StopMusic();
	ResetDC();
	return 0;
}

//Using new KOS MAPLE!
void TranslateKeys(cont_state_t *cond)
{	
	int i;
	short joyx=cond->joyx; //-128 to 128, 0 centered
	short joyy=cond->joyy;

	for (i=0; i<256; i++)
		keys[i]=0;

	if ((cond->buttons & CONT_DPAD_UP) || joyy<-JOYC)
		keys[VK_UP]=1;

	if ((cond->buttons & CONT_DPAD_DOWN) || joyy>JOYC)
		keys[VK_DOWN]=1;

	if ((cond->buttons & CONT_DPAD_LEFT) || joyx<-JOYC)
		keys[VK_LEFT]=1;

	if ((cond->buttons & CONT_DPAD_RIGHT) || joyx>JOYC)
		keys[VK_RIGHT]=1;

	if ((cond->buttons & CONT_A))
		keys[VK_F1]=1;

	if ((cond->buttons & CONT_B))
		keys[VK_F2]=1;

	if ((cond->buttons & CONT_X))
		keys[VK_F3]=1;

	if ((cond->buttons & CONT_Y))
		keys[VK_F4]=1;

	
}
