#include "DrawStuff.h"
#include "Game.h"
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include "LineFont.h"
#include "Framework.h"

#define PI 3.14159265f
#define STEPS 32
#define CELLSIZE 2

#define MAXCHEW 0.2f
#define MINCHEW 0.0f
#define DELTACHEW 0.01f

float chew=MINCHEW;
float dchew=DELTACHEW;
int pacmanrot=0;

bool	keys[256];
GLuint	texture[1];
int view=1;

const float d1=1.09f;
const float d2=1.12f;
int titlerot=0;
int titlerotdelay=40;
int titlecount=0;

float pacscale=0.7f;

int dirs[]= { 1,0, 0,1, -1,0, 0,-1 };

float px[STEPS],py[STEPS];

float ghostcolors[] = { 1,0,0,  0,0,1,  0,1,0,  1,0,1,  1,0.5f,0,  0,0.5f,1,  1,0.5f,0.5f,  0.5f,1,0.3f };

void InitStuff()
{
	int i;
	float angle;

	srand( (unsigned)time( NULL ) );
	for (i=0; i<STEPS; i++)
	{
		angle=2.0f*PI*float(i)/float(STEPS);
		px[i]=float(cos(angle));
		py[i]=float(sin(angle));
	}
	GameInit();
	LevelInit();
}


void GLPacman()
{
	int i,j;

	glColor3f(1,1,0);
	glBegin(GL_TRIANGLES);
	for (i=0; i<STEPS; i++)
	{
		j=i-1;
		if (j<0)
			j=STEPS-1;
		glVertex3f(px[i],0.7f,py[i]);
		glVertex3f(px[j],0.7f,py[j]);
		glVertex3f(0,1.0f,0);
	}
	for (i=0; i<STEPS; i++)
	{
		j=i-1;
		if (j<0)
			j=STEPS-1;
		glVertex3f(px[i],-0.7f,py[i]);
		glVertex3f(px[j],-0.7f,py[j]);
		glVertex3f(0,-1.0f,0);
	}
	glEnd();

	glBegin(GL_QUADS);
	for (i=0; i<STEPS; i++)
	{
		j=i-1;
		if (j<0)
			j=STEPS-1;
		if (i>2 && i<(STEPS-2))
		{
			glColor3f(1,1,0);
			glVertex3f(px[i],-0.7f,py[i]);
			glVertex3f(px[j],-0.7f,py[j]);
			glVertex3f(px[j],0.7f,py[j]);
			glVertex3f(px[i],0.7f,py[i]);
		}
		else
		{
			glColor3f(1,1,0);
			glVertex3f(px[i],-0.4f+chew,py[i]);
			glVertex3f(px[j],-0.4f+chew,py[j]);
			glVertex3f(px[j],0.7f,py[j]);
			glVertex3f(px[i],0.7f,py[i]);

			glVertex3f(px[i],-0.4f-chew,py[i]);
			glVertex3f(px[j],-0.4f-chew,py[j]);
			glVertex3f(px[j],-0.7f,py[j]);
			glVertex3f(px[i],-0.7f,py[i]);

			glColor3f(0,0,0);
			glVertex3f(px[i],-0.4f+chew,py[i]);
			glVertex3f(px[i],-0.4f-chew,py[i]);
			glVertex3f(px[j],-0.4f-chew,py[j]);
			glVertex3f(px[j],-0.4f+chew,py[j]);	
		}
	}
	// Eyes white
	glColor3f(1,1,1);
		glVertex3f(d1*px[1],0.5f,d1*py[1]);
		glVertex3f(d1*px[1],0.0f,d1*py[1]);
		glVertex3f(d1*px[3],0.0f,d1*py[3]);
		glVertex3f(d1*px[3],0.5f,d1*py[3]);
		glVertex3f(d1*px[STEPS-1],0.5f,d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-1],0.0f,d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-3],0.0f,d1*py[STEPS-3]);
		glVertex3f(d1*px[STEPS-3],0.5f,d1*py[STEPS-3]);
		// Eyes black
	glColor3f(0,0,0);
		glVertex3f(d2*px[1],0.25f,d2*py[1]);
		glVertex3f(d2*px[1],0.0f,d2*py[1]);
		glVertex3f(d2*px[2],0.0f,d2*py[2]);
		glVertex3f(d2*px[2],0.25f,d2*py[2]);
		glVertex3f(d2*px[STEPS-2],0.25f,d2*py[STEPS-2]);
		glVertex3f(d2*px[STEPS-2],0.0f,d2*py[STEPS-2]);
		glVertex3f(d2*px[STEPS-3],0.0f,d2*py[STEPS-3]);
		glVertex3f(d2*px[STEPS-3],0.25f,d2*py[STEPS-3]);
	glEnd();
}

void AdjustPacmanRotation()
{
	int reqrot;

	if (viewdx>0)
		reqrot=0;
	else if (viewdx<0)
		reqrot=180;
	else if (viewdy>0)
		reqrot=270;
	else 
		reqrot=90;

	if (abs(reqrot-pacmanrot)<180)
	{
		if (reqrot>pacmanrot)
			pacmanrot+=10;
		else if (reqrot<pacmanrot)
			pacmanrot-=10;	
	}
	else
	{
		if (reqrot>pacmanrot)
			pacmanrot-=10;
		else if (reqrot<pacmanrot)
			pacmanrot+=10;			
	}
	if (pacmanrot>=360)
		pacmanrot-=360;
	if (pacmanrot<0)
		pacmanrot+=360;
}


void DrawPacman()
{
	float px,py;
	glPushMatrix();
	px=CELLSIZE*(float(pacmanx)/blocksize-float(nrofblocks)/2.0f);
	py=-CELLSIZE*(float(pacmany)/blocksize-float(nrofblocks)/2.0f);
	glTranslatef(px,py,0);
	glRotatef(90,1,0,0);
	glRotatef((float)pacmanrot,0,1,0);
	glScalef(pacscale,1.0f,pacscale);
	GLPacman();
	glPopMatrix();
}


void DrawGhost()
{
	int i,j;

	glBegin(GL_QUADS);

	for (i=0; i<STEPS; i++)
	{
		j=i-1;
		if (j<0)
			j=STEPS-1;
		glVertex3f(px[i],-1,py[i]);
		glVertex3f(px[j],-1,py[j]);
		glVertex3f(px[j],1,py[j]);
		glVertex3f(px[i],1,py[i]);
	}
	glEnd();

	glBegin(GL_TRIANGLES);
	for (i=0; i<STEPS; i++)
	{
		j=i-1;
		if (j<0)
			j=STEPS-1;
		glVertex3f(px[i],1,py[i]);
		glVertex3f(px[j],1,py[j]);
		glVertex3f(0,1.3f,0);
	}
	glEnd();

	glBegin(GL_QUADS);
		glColor3f(1,1,1);
		// Eyes white
		glVertex3f(d1*px[1],0.5f,d1*py[1]);
		glVertex3f(d1*px[1],0.0f,d1*py[1]);
		glVertex3f(d1*px[3],0.0f,d1*py[3]);
		glVertex3f(d1*px[3],0.5f,d1*py[3]);
		glVertex3f(d1*px[STEPS-1],0.5f,d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-1],0.0f,d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-3],0.0f,d1*py[STEPS-3]);
		glVertex3f(d1*px[STEPS-3],0.5f,d1*py[STEPS-3]);
		// Eyes black
		glColor3f(0,0,0);
		glVertex3f(d2*px[1],0.25f,d2*py[1]);
		glVertex3f(d2*px[1],0.0f,d2*py[1]);
		glVertex3f(d2*px[2],0.0f,d2*py[2]);
		glVertex3f(d2*px[2],0.25f,d2*py[2]);
		glVertex3f(d2*px[STEPS-2],0.25f,d2*py[STEPS-2]);
		glVertex3f(d2*px[STEPS-2],0.0f,d2*py[STEPS-2]);
		glVertex3f(d2*px[STEPS-3],0.0f,d2*py[STEPS-3]);
		glVertex3f(d2*px[STEPS-3],0.25f,d2*py[STEPS-3]);

		// Mouth
		glVertex3f(d1*px[1],-0.6f, d1*py[1]);
		glVertex3f(d1*px[1],-0.7f, d1*py[1]);
		glVertex3f(d1*px[0],-0.75f, d1*py[0]);
		glVertex3f(d1*px[0],-0.65f, d1*py[0]);

		glVertex3f(d1*px[1],-0.6f, d1*py[1]);
		glVertex3f(d1*px[1],-0.7f, d1*py[1]);
		glVertex3f(d1*px[2],-0.75f, d1*py[2]);
		glVertex3f(d1*px[2],-0.65f, d1*py[2]);

		glVertex3f(d1*px[0],-0.65f, d1*py[0]);
		glVertex3f(d1*px[0],-0.75f, d1*py[0]);
		glVertex3f(d1*px[STEPS-1],-0.7f, d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-1],-0.6f, d1*py[STEPS-1]);

		glVertex3f(d1*px[STEPS-2],-0.65f, d1*py[STEPS-2]);
		glVertex3f(d1*px[STEPS-2],-0.75f, d1*py[STEPS-2]);
		glVertex3f(d1*px[STEPS-1],-0.7f, d1*py[STEPS-1]);
		glVertex3f(d1*px[STEPS-1],-0.6f, d1*py[STEPS-1]);

	glEnd();
}


void DrawBlock(float x1, float y1, float x2, float y2, float z1, float z2, float r, float g, float b)
{
	glColor3f(r,g,b);
	glVertex3f(x1,y1,z1);
	glVertex3f(x1,y1,z2);
	glVertex3f(x2,y1,z2);
	glVertex3f(x2,y1,z1);

	glVertex3f(x1,y2,z1);
	glVertex3f(x1,y2,z2);
	glVertex3f(x2,y2,z2);
	glVertex3f(x2,y2,z1);

	glColor3f(0.8f*r,0.8f*g,0.8f*b);
	glVertex3f(x1,y1,z1);
	glVertex3f(x1,y1,z2);
	glVertex3f(x1,y2,z2);
	glVertex3f(x1,y2,z1);

	glVertex3f(x2,y1,z1);
	glVertex3f(x2,y1,z2);
	glVertex3f(x2,y2,z2);
	glVertex3f(x2,y2,z1);

	glColor3f(0.9f*r,0.9f*g,0.9f*b);
	glVertex3f(x1,y1,z1);
	glVertex3f(x2,y1,z1);
	glVertex3f(x2,y2,z1);
	glVertex3f(x1,y2,z1);

	glVertex3f(x1,y1,z2);
	glVertex3f(x2,y1,z2);
	glVertex3f(x2,y2,z2);
	glVertex3f(x1,y2,z2);
}


void DrawMaze()
{
	float x,y,s;
	float mr,mg,mb;
	int i,j;
	char ch;
	s=float(CELLSIZE)/2.0f;

    if (scared && scaredcount>=30)
	{
		mr=0.85f; mg=0; mb=0.85f;
	}
	else
	{
		mr=0; mg=0.85f; mb=0.85f;
	}

	glPushMatrix();
	glBegin(GL_QUADS);

	y=+nrofblocks*s;
	for (i=0; i<nrofblocks; i++)
	{
		x=-nrofblocks*s;
		for (j=0; j<nrofblocks; j++)
		{
			ch=screendata[i*nrofblocks+j];
			if (ch&1) // Left
			{
				DrawBlock(x-s,y-s,x-s-0.05f,y+s,-1,0.7f,mr,mg,mb);
			}
			if (ch&2) // Top
			{
				DrawBlock(x-s,y+s,x+s,y+s+0.05f,-1,0.7f,mr,mg,mb);
			}
			if (ch&4) // Right
			{
				DrawBlock(x+s,y-s,x+s+0.05f,y+s,-1,0.7f,mr,mg,mb);
			}
			if (ch&8) // Bottom
			{
				DrawBlock(x-s,y-s,x+s,y-s-0.05f,-1,0.7f,mr,mg,mb);
			}
			if (ch&16)
			{
				DrawBlock(x-s/4.0f,y-s/4.0f,x+s/4.0f,y+s/4.0f,-0.2f,0.1f,1,1,0);
			}
			if (ch&32)
			{
				DrawBlock(x-s/3.0f,y-s/3.0f,x+s/3.0f,y+s/3.0f,-0.4f,0.2f,1,0.6f,0);
			}
			x=x+2.0f*s;
		}
		y=y-2.0f*s;
	}

	glEnd();
	glPopMatrix();
}


void AdjustGhostRotation(int g)
{
	int reqrot;

	if (ghostdx[g]>0)
		reqrot=0;
	else if (ghostdx[g]<0)
		reqrot=180;
	else if (ghostdy[g]>0)
		reqrot=270;
	else 
		reqrot=90;

	if (abs(reqrot-ghostrot[g])<180)
	{
		if (reqrot>ghostrot[g])
			ghostrot[g]+=10;
		else if (reqrot<ghostrot[g])
			ghostrot[g]-=10;			
	}
	else
	{
		if (reqrot>ghostrot[g])
			ghostrot[g]-=10;
		else if (reqrot<ghostrot[g])
			ghostrot[g]+=10;			
	}
	if (ghostrot[g]>=360)
		ghostrot[g]-=360;
	if (ghostrot[g]<0)
		ghostrot[g]+=360;
}


void DrawGhosts()
{
	float gx,gy;
	int i;
	float *ptr=ghostcolors;

	for (i=0; i<nrofghosts; i++)
	{
		glPushMatrix();
		gx=CELLSIZE*(float(ghostx[i])/blocksize-float(nrofblocks)/2.0f);
		gy=-CELLSIZE*(float(ghosty[i])/blocksize-float(nrofblocks)/2.0f);
		glTranslatef(gx,gy,0);
		glRotatef(90,1,0,0);
		glRotatef(float(ghostrot[i]),0,1,0);
		if (scared)
			glColor3f(0,0,0.7f);
		else
			glColor3f(*ptr,*(ptr+1),*(ptr+2));
		ptr=ptr+3;
		glScalef(0.7f,1.0f,0.7f);
		DrawGhost();
		glPopMatrix();
	}
}


void SetView()
{
	int theview=view;

	if (!ingame)
		theview=0;

	switch(theview)
	{
		case 1:
			gluLookAt(0,-30,30, 0,0,0, 0,1,0); // isomorphic view
			break;
		case 2:
		{
			float lax1,lay1,lax2,lay2; // Begin view
			float px,py;

			px=CELLSIZE*(float(pacmanx)/blocksize-float(nrofblocks)/2.0f);
			py=-CELLSIZE*(float(pacmany)/blocksize-float(nrofblocks)/2.0f);

			lax1=px-25*(float)cos(PI*float(pacmanrot)/180.0f);
			lay1=py-25*(float)sin(PI*float(pacmanrot)/180.0f);
			lax2=px+18*(float)cos(PI*float(pacmanrot)/180.0f);
			lay2=py+18*(float)sin(PI*float(pacmanrot)/180.0f);
			gluLookAt(lax1,lay1,12.2f,  lax2,lay2,1.3f,  0,0,1);
			break;
		}

		default:
			gluLookAt(0,0,45, 0,0,0, 0,1,0); // Classic top down view
			break;
	}
}

void DoAnims()
{
	int i;
	chew=chew+dchew;
	if (chew>=MAXCHEW || chew<=MINCHEW)
		dchew=-dchew;
	AdjustPacmanRotation();
	for (i=0; i<nrofghosts; i++)
		AdjustGhostRotation(i);
	if (dying && pacscale>0)
		pacscale-=0.04f;
	if (!dying)
		pacscale=0.7f;
}


void DrawScore()
{
	char buf[8];
	int i;

	glPushMatrix();
	glLoadIdentity();
	glTranslatef(0,0,-40);

	sprintf(buf,"%07d",score);
	glColor3f(1,1,1);
	DrawString(buf,14,14,0.2f);

	for (i=0; i<pacsleft; i++)
	{
		glLoadIdentity();
		glTranslatef(float(i)*2.5f+15,12,-40);
		glRotatef(-90,0,1,0);
		GLPacman();
	}
	glPopMatrix();
}


void ShowTitle()
{
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(0,0,-35);
	glRotatef(float(titlerot),1,0,0);
	glColor3f(0,0,0.4f);
	glBegin(GL_QUADS);
		glVertex3f(-16,6,-1);
		glVertex3f(-16,-6,-1);
		glVertex3f(16,-6,-1);
		glVertex3f(16,6,-1);
	glEnd();
	glColor3f(1,1,1);
	glBegin(GL_QUADS);
		glVertex3f(-16.3f,6.3f,-1.2);
		glVertex3f(-16.3f,-6.3f,-1.2);
		glVertex3f(16.3f,-6.3f,-1.2);
		glVertex3f(16.3f,6.3f,-1.2);
	glEnd();

	glColor3f(1,0,1);
	DrawString("PACMAN 3D",-14.5f,2,0.7f);
	glColor3f(1,1,0);
	DrawString("A GAME BY BRIAN POSTMA",-14.5f,-4,0.3f);
	glColor3f(0.8f, 0.6f,0);
	DrawString("HTTP://WWW.BRIANPOSTMA.COM",-9,-5.3f,0.15f);
	if (titlecount<50)
	{
		glColor3f(1,1,1);
//		DrawString("PRESS F1 TO START, F12 TO QUIT",-9.5f,0.0f,0.15f);
		DrawString("PRESS A TO START, START TO QUIT",-11.5f,0.0f,0.18f);
//		DrawString("USE F2-F4 TO CHANGE VIEWS",-8.5f, -1.2f,0.15f);
		DrawString("USE B,X,Y TO CHANGE VIEWS",-9.0f, -1.2f,0.18f);
	}
	titlecount++;
	if (titlecount>80)
		titlecount=0;

	titlerotdelay--;
	if (titlerotdelay<=0)
	{
		titlerot=(titlerot+3)%360;
		titlerotdelay=1;
		if (titlerot==0)
			titlerotdelay=70;
	}
	glPopMatrix();
}


void ShowAll()
{
	glLoadIdentity();
	SetView();
    DrawMaze();
	DrawGhosts();
    DrawScore();
    DoAnims();
    if (ingame)
	{
		DrawPacman();
		PlayGame();
	}
    else
	{
      PlayDemo();
	  ShowTitle();
	}
	KeyHandler();
}


void NextDir(int delta)
{
	int newdir,curdir=0,i;

	for (i=0; i<4; i++)
	{
		if (dirs[i*2]==viewdx && dirs[i*2+1]==viewdy)
			curdir=i;
	}
	newdir=(curdir+delta)%4;
	reqdx=dirs[newdir*2];
	reqdy=dirs[newdir*2+1];
}


void KeyHandler()
{
	if (ingame)
	{
		if (view!=2)
		{
			if (keys[VK_LEFT])
			{
				reqdx=-1;
				reqdy=0;
			}
			else if (keys[VK_RIGHT])
			{
				reqdx=1;
				reqdy=0;
			}
			else if (keys[VK_UP])
			{
				reqdx=0;
				reqdy=-1;
			}
			else if (keys[VK_DOWN])
			{
				reqdx=0;
				reqdy=1;
			}
		}
		else
		{
			if (keys[VK_LEFT])
				NextDir(3);
			if (keys[VK_RIGHT])
				NextDir(1);
			if (keys[VK_DOWN])
				NextDir(2);
			if (keys[VK_UP])
				NextDir(0);
		}
		if (keys[VK_ESCAPE])
		{
			ingame=false;
		}
	}
	else
	{
		if (keys[VK_F1])
		{
			ingame=true;
			GameInit();
		}
	}
	if (!(keys[VK_LEFT] || keys[VK_RIGHT] || keys[VK_UP] ||  keys[VK_DOWN]))
	{
		reqdx=0;
		reqdy=0;
	}
	if (view==2 && keys[VK_DOWN])
		keys[VK_DOWN]=0;

	if (keys[VK_F2])
		view=0;
	if (keys[VK_F3])
		view=1;
	if (keys[VK_F4])
		view=2;
}


