/* Grandia 2 file splitter 0.2beta by Mat
Programma che gestisce gli archivi di Grandia 2 in formato AFS.
Dato che non ho il gioco non ho ne ho potuto testare il funzionamento,
ma Mentz mi ha detto che funziona.
Il codice e stato scritto facendo in modo che le funzioni siano riutilizzabili
e gestiscano gli errori delle system call.
Penso di aver scritto un codice decente anche se i commenti non sono molti e
non spiegano granche' (ho questa cattiva abitudine). Se qualche riga e' poco
chiara contattami.
Questo programma e' stato scritto con Dev-C++ e compilato con gcc, e una
richiesta fondamentale per il funzionamento e' che i dati siano Little Endian
e che gli int siano a 4 byte e i char a 1 byte (e' per questo che nelle 
funzioni non ho usato sizeof(int), perche' se la dimensione fosse diversa non
il programma non funzionerebbe comunque).
Forse prossimamente cambiero' gli fwrite invertendo 1 e nbyte, il modo da rendere
piu' veloce il controllo.

Mat - 15/07/2003
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#define MAXDIR 256
#define BUFFSIZE 32768


int splitL62C(FILE *arc, FILE *out, int ric);
/* Estrae un archivio di AFS di Grandia 2, scrivendo su out il nome dei file
   estratti e alcuni errori
    arc: file pointer dell'archivio da creare (aprire in "rb")
    out: file pointer su cui verranno scritti i messaggi, se 0 non stampa messaggi
    
    Valore di ritorno:
    0 in caso di successo
    1 se il file non e' un archivio
    2 in caso di errore di lettura o di seek
    3 in caso di errore di lettura dall'archivio di uno specifico file (messaggio su out)
    4 nel caso che sia impossibile creare un file (messaggio su out)
    5 in caso si errore di scrittura di un file (messaggio su out)
    
    NOTA: La funzione non chiude i file pointer passati e muove il seek
*/
int copiadati(FILE *orig, FILE* dest, int size, int ric);

int main(int argc, char *argv[]) {

   FILE *arc;
   int err;
   char old_dir[MAXDIR];
   
   if((argc >= 3) && (argc <= 4)) {  // Se ci sono almeno 3 argomenti
 
      if(!(strcmpi(argv[1], "-r") && (err = strcmpi(argv[1], "-e")))) {  // Estrazione di un archivio

         if((arc = fopen(argv[2], "rb")) == NULL) {  // apre l'archivio
            printf("Impossibile aprire il file %s - Operazione non riuscita\n", argv[2]);
            exit(2);  // uscita con errore
         }
         
         if(argc == 4) {  // se abbio specificato la dir destinazione
            if(!getcwd(old_dir, MAXDIR)) {  //ottime la dir corrente
               printf("Impossibile ottenere la directory corrente - Operazione non riuscita\n");
               exit(2);  // uscita con errore
            }
            mkdir(argv[3]);  // prova a creare la dir destinazione
            if(chdir(argv[3])) {  // entra nella dir destinazione
               printf("Impossibile entrare nella directory destinazione - Operazione non riuscita\n");
               exit(2);  // uscita con errore
            }
         }
         err = splitL62C(arc, stdout, err);  // estrae l'archivio
         fclose(arc);  // chiude l'archivio
         if(argc == 4) chdir(old_dir);  // ripristina la dir iniziale
         if(err) {  
            printf(" - Operazione non riuscita\n");
            exit(2);  // uscita con errore
         }
         printf("Grandia 2 file splitter 0.2beta by Mat - Operazione riuscita\n"); // uscita normale
         exit(0);  // uscita corretta
      }
   }
   
   printf("Grandia 2 file splitter 0.2beta by Mat - USO:\ng2split -e origine [destinazione]   splitta un archivio (header based)\ng2split -r origine [destinazione]   splitta un archivio (header + ricerca)\n\nMat - 15/07/2003\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
   exit(1);  // uscita corretta
}

int splitL62C(FILE *arc, FILE *out, int ric) {
   #define sp_errore(num) {err = (num); break;}
   char nomefile[13];
   FILE *dest;
   unsigned int header[6];
   int i = 1, err = 0, res, poscur, filesize;
   
   if(fseek(arc, 0, SEEK_END)) err = 1;  // fine del file
   else if((filesize = ftell(arc)) == -1) err = 1;
   else if(fseek(arc, 0, SEEK_SET)) err = 1;  // fine del file
   
   while(!err) {
      sprintf(nomefile, "part.%.3d", i);  // il nome del file e' uguale a i
      if(fread(header, 4, 1, arc) != 1) break; // legge l'header
      if((dest = fopen(nomefile, "wb")) == NULL) {  // crea il file destinazione
         if(out) fprintf(out, "Impossibile creare il file %s", nomefile);
         return 3;
      }
      if(header[0] == 0x4332364C) { // File L62C
         if(fread(header + 1, 4, 1, arc) != 1) sp_errore(1); // legge la dimesione dei dati
         if(fwrite(header, 4, 2, dest) != 2) sp_errore(2);
         if(res = copiadati(arc, dest, header[1], 0)) sp_errore(res);
      }
      else if(header[0] == 0x58494247) { // File GBIX
         if(fread(header + 1, 4, 5, arc) != 5) sp_errore(1); // legge la dimesione dei dati
         if(fwrite(header, 4, 6, dest) != 6) sp_errore(2);
         if(res = copiadati(arc, dest, header[5], 0)) sp_errore(res);
      }
      else { // File L62C
         fprintf(out, "%s TIPO SCONOSCIUTO\n", nomefile);
         if((poscur = ftell(arc)) == -1) sp_errore(1);  // dimensione del file
         if(fwrite(header, 4, 1, dest) != 1) sp_errore(2);
         if(res = copiadati(arc, dest, filesize - poscur, ric)) sp_errore(res);
      }
      ++i;
      fclose(dest);
   }
   if(err) {
      fclose(dest);
      //unlink(nomefile);
      if(err == 1) fprintf(out, "Errore di lettura nell'archivio");
      else fprintf(out, "Impossibile leggere il file %s dall'archivio", nomefile);
      return err;
   }
   return 0;
}

int copiadati(FILE *orig, FILE* dest, int size, int ricerca) {
  
   char buffer[BUFFSIZE + 3];
   int blocco, i;
   
   while(size > 0) {  // cicla finche' ci sono dati da leggere
     if(size < BUFFSIZE) blocco = size;  // ci sono da leggere meno dati della grandezza del buffer
     else blocco = BUFFSIZE;  // dati maggiori della grandezza del buffer
     if(fread(buffer, 1, blocco + 3, orig) < blocco) return 1;
     if(ricerca) {
        for(i = 0; i < blocco; ++i) {
           if((*(int *)(buffer + i) == 0x4332364C) || (*(int *)(buffer + i) == 0x58494247)) {
              if(i) {if(fwrite(buffer, i, 1, dest) != 1) return 2;}
              if(fseek(orig, i - (blocco + 3), SEEK_CUR)) return 1;
              break;
           }
        }
        if(i != blocco) break;
     }
     if(fwrite(buffer, blocco, 1, dest) != 1) return 2;
     if(fseek(orig, -3, SEEK_CUR)) ;
     size -= blocco;  // diminuisce i dati ancora da scrivere
   }
   return 0;
}
