/* Grandia 2 graphic converter 0.1beta3 by Mat
Programma che converte in raw e viceversa alcuni tipi di pvr usati da
Grandia 2 (quelli non supportati dal plug-in per Photoshop).
Dato che non ho il gioco non ho ne ho potuto testare il funzionamento,
ma penso che funzioni.
Il codice e stato scritto facendo in modo che le funzioni siano riutilizzabili
e gestiscano gli errori delle system call.
Penso di aver scritto un codice decente anche se i commenti non sono molti e
non spiegano granche' (ho questa cattiva abitudine). Se qualche riga e' poco
chiara contattami.
Questo programma e' stato scritto con Dev-C++ e compilato con gcc, e una
richiesta fondamentale per il funzionamento e' che i dati siano Little Endian
e che gli int siano a 4 byte e i char a 1 byte (e' per questo che nelle 
funzioni non ho usato sizeof(int), perche' se la dimensione fosse diversa non
il programma non funzionerebbe comunque).
Forse prossimamente cambiero' gli fwrite invertendo 1 e nbyte, il modo da rendere
piu' veloce il controllo e evitare i warning con VC++

Per fare questo programma mi sono basato sul:
Texture twiddler/detwiddler for PowerVR (c)2000 Dan Potter

Mat - 15/07/2003
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Dati letti
unsigned char *buforig;

// Dati scritti 
unsigned char *bufdest;

// Grandezza immagine
int imgsize;

int convert(FILE *orig, FILE *dest, int operazione);
void subdivide_and_move(int x1, int y1, int size, int op);

int main(int argc, char *argv[]) {
   FILE *letto, *scritto;
   int err;
   
   if(argc == 4) {
      if(!((err = strcmpi(argv[1], "-e")) && strcmpi(argv[1], "-c"))) {
         if((letto = fopen(argv[2], "rb")) == NULL) {
            printf("Impossibile aprire %s\n", argv[2]);
            exit(2);  // uscita con errore
         }
         if((scritto = fopen(argv[3], "wb")) == NULL) {
            printf("Impossibile aprire %s\n", argv[3]);
            fclose(letto);
            exit(2);  // uscita con errore
         }
         err = convert(letto, scritto, err);
         fclose(letto);
         fclose(scritto);
         
         if(err) {
            unlink(argv[3]);
            if(err == -1) printf("Errore nell'allocazione della memoria");
            if(err == 1) printf("Il file non \212 ancora supportato");
            else if(err == 2) printf("Impossibile leggere il file %s", argv[2]);
            else if(err == 3) printf("Impossibile scrivere il file %s", argv[3]);
            else printf("Il file specifica una dimesione 0x0");
            printf(" - Operazione non riuscita\n");
            exit(2);  // uscita con errore
         }
         printf("Immagine %dx%d + 32byte header\nGrandia 2 graphic converter 0.1beta3 by Mat - Operazione riuscita\n", imgsize, imgsize);
         exit(0);  // uscita corretta
      }
   }      
   printf("Grandia 2 graphic converter 0.1beta3 by Mat - USO:\ng2gc -e origine.pvr destinazione.raw  (converte in raw)\ng2gc -c origine.raw destinzaione.pvr  (converte in pvr)\n\nGrazie a Dan Potter per il suo \"Texture twiddler/detwiddler for PowerVR\"\n\nMat - 15/07/2003\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
   exit(1);  // uscita con errore per mancanza di parameti
}

int convert(FILE *orig, FILE *dest, int operazione) {
   #define uscita1(num) { free(buforig); return(num); }
   #define uscita2(num) { free(bufdest); return(num); }
   char header[32];
   int i, size;
   
   if(fseek(orig, 0, SEEK_END)) return 2;
   if((size = ftell(orig)) == -1) return 2;
   if(fseek(orig, 0, SEEK_SET)) return 2;
   if(fread(header, 1, 32, orig) != 32) return 2;
   
   
   if(*(short *)(header + 28) != *(short *)(header + 30)) return 1;
   if(fwrite(header, 1, 32, dest) != 32) return 2;
   imgsize = *(short *)(header + 28);
   if(!imgsize) return 4;
   size -= 32;
   if(!(buforig = malloc(size))) return -1;
   if(fread(buforig, 1, size, orig) != size) uscita1(2);
   if(!(bufdest = malloc(size))) uscita1(-1);
   subdivide_and_move(0, 0, imgsize, operazione);
   free(buforig);
   /* Questo ciclo scrive i dati in BMP, prima pero' bisogna aggiungere l'header
   for(i = ((size - imgsize) / imgsize) * imgsize; i != -imgsize; i -= imgsize) {
      if(fwrite(bufdest + i, 1, imgsize, dest) != imgsize) uscita2(3);
   }
   */
   if(fwrite(bufdest, 1, size, dest) != size) uscita2(3);
   uscita2(0);
}

void subdivide_and_move(int x1, int y1, int size, int op) {
   static int pos = 0;
   if(size == 1) {
      if(op) {  // Codifica
         bufdest[pos++] = buforig[y1*imgsize+x1];
      }
      else {  // Decodifica
         bufdest[y1*imgsize+x1] = buforig[pos++];
      }
   }
   else {
      int ns = size/2;
      subdivide_and_move(x1, y1, ns, op);
      subdivide_and_move(x1, y1+ns, ns, op);
      subdivide_and_move(x1+ns, y1, ns, op);
      subdivide_and_move(x1+ns, y1+ns, ns, op);
   }
}

