/* Grandia 2 font decoder 0.2 by Mat - USO:

FL = larghezza font
FA = altezza font
FN = numero font per linea (16 largezza per 16 font = 256 pixel)

Mat - 19/09/2003
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define DATASIZE 12288
#define RAWSIZE 98304
#define DATASIZE2 25920
#define RAWSIZE2 207360
#define FL 16
#define FL2 24
#define FA 24
#define FN 16
#define FN2 20

int decomprimi_file(FILE *orig, FILE *dest);
int comprimi_file(FILE *orig, FILE *dest);

int main(int argc, char *argv[]) {
   FILE *letto, *scritto;
   int err;
   
   if(argc != 4) {
      printf("Grandia 2 font decoder 0.2 by Mat - USO:\ng2fd -e origine destinazione.raw   (converte in raw)\ng2fd -c origine.raw destinazione   (converte in tilemap)\n\nDimensione RAW: 256x384 per eng24.fnt, 480x432 per 24.fnt\n\nMat - 19/09/2003\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
      exit(1);
   }
   else if(strcmpi(argv[1], "-e") && strcmpi(argv[1], "-c")) {
      printf("Le opzioni sono:\n-e (converte in raw)\n-c per (converte in tilemap)\n");
      exit(1);
   }
   
   if((letto = fopen(argv[2], "rb")) == NULL) {
      printf("Impossibile aprire %s\n", argv[2]);
      exit(1);
   }
   if((scritto = fopen(argv[3], "wb")) == NULL)  {
      printf("Impossibile aprire %s\n", argv[3]);
      exit(1);
   }
   if(((argv[1])[1] == 'e') || ((argv[1])[1] == 'E')) err = decomprimi_file(letto, scritto);
   else err = comprimi_file(letto, scritto);
   fclose(letto);
   fclose(scritto);
   if(err) {
      unlink(argv[3]);
      if(err == 1) printf("Il file non \212 nel giusto formato");
      else if(err == 2) printf("Impossibile leggere il file %s", argv[2]);
      else printf("Impossibile scrivere il file %s", argv[3]);
      printf(" - Operazione non riuscita\n");
      exit(1);
   }
   printf("Grandia 2 font decoder 0.2 by Mat - Operazione riuscita\n");
   exit(0);
}

int decomprimi_file(FILE *orig, FILE *dest) {
   // ritorna una raw
   unsigned char buffer[RAWSIZE2];
   unsigned char buffer2[RAWSIZE2];
   int c, b, i, tot = 0;
   int a1 = 0, a2 = 0, a3 = 0, a4 = 0;
   int rawsize, fl, fa = FA, fn;
   
   if(fseek(orig, 0, SEEK_END)) return 2;
   if((c = ftell(orig)) == -1) return 2;
   if(c == DATASIZE) {
      rawsize = RAWSIZE;
      fl = FL;
      fn = FN;
   }
   else if(c == DATASIZE2) {
      rawsize = RAWSIZE2;
      fl = FL2;
      fn = FN2;
   }
   else return 1;
   
   if(fseek(orig, 0, SEEK_SET)) return 2;
   
   // Converte in raw 16x?
   while((c = getc(orig)) != -1) {
      for(i = 0; i < 8; ++i) {
         b = (c >> (7 - i)) & 1;
         if(b) b = 0xFF;
         buffer[tot++] = b; 
      }
   }
   if(ferror(orig)) return 2;
      
   
   // Arrotonda alla riga (FL * FA * FN byte) superiore
   //if((c = tot % (fl * FA * FN))) tot += (fl * FA * FN) - c;
   
   // Converte in raw 256x
   for(i = 0; i < tot; ++i) {
      buffer2[i] = buffer[a1 + (a2 * fa * fl) + (a3 * fl) + (a4 * fl * fa * fn)];
      if(++a1 == fl) {
         a1 = 0;
         if(++a2 == fn) {
            a2 = 0;
            if(++a3 == fa) {
               a3 = 0;
               ++a4;
            }
         }
      }
   }
   if(fwrite(buffer2, tot, 1, dest) != 1) return 3;
   return 0;
}

int comprimi_file(FILE *orig, FILE *dest) {
   // ritorna una raw 256x209 con 16 byte di header
   unsigned char buffer[RAWSIZE2];
   unsigned char buffer2[RAWSIZE2];
   unsigned char *p;
   int i, j, c, a1 = 0, a2 = 0, a3 = 0, a4 = 0;
   int rawsize, fl, fa = FA, fn;
   
   if(fseek(orig, 0, SEEK_END)) return 2;
   if((rawsize = ftell(orig)) == -1) return 2;
   if(rawsize == RAWSIZE) {
      fl = FL;
      fn = FN;
   }
   else if(rawsize == RAWSIZE2) {
      fl = FL2;
      fn = FN2;
   }
   else return 1;
   
   if(fseek(orig, 0, SEEK_SET)) return 2;
   
   // Legge il file
   if(fread(buffer, rawsize, 1, orig) != 1) return 2;
   // Converte in raw 16x3344
   for(i = 0; i < rawsize; ++i) {
      buffer2[a1 + (a2 * fa * fl) + (a3 * fl) + (a4 * fl * fa * fn)] = buffer[i];
      if(++a1 == fl) {
         a1 = 0;
         if(++a2 == fn) {
            a2 = 0;
            if(++a3 == fa) {
               a3 = 0;
               ++a4;
            }
         }
      }
   }
   
   for(i = 0; i < rawsize; i += 8) {
      c = 0;
      p = buffer2 + i;
      for(j = 0; j < 8; ++j) {
         if(p[j]) c |= 128 >> j;
      }
      if(putc(c, dest) == -1) return 3;
   }
   return 0;
}

