/* Grandia 2 text dumper/inserter 0.1Beta4 by Mat - USO:

Opcode:
04-1
05-2
06-3
08-3
09-4
0A-6 ?
0B-2
0C-1 ?
0F-1
10-7 ?
11-3
14-5
15-4
1C-1

RINGRAZIAMENTI
- Chop per aver scoperto gli opcode
- _Ombra_ per tutti i test che ha fatto

Mat - 21/04/2004
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/

#include <stdlib.h>
#include <stdio.h>

int GRA2_dumpa(FILE *orig, FILE *dest);

int GRA2_dumpaTesto(FILE *dump, unsigned char *orig, int i, int dim,  unsigned char *label);

int GRA2_inserisci(FILE *orig, FILE *dest);

int GRA2_strCompare(char *expr, char *string, unsigned char *value);

int GRA2_inserisciStanza(unsigned char *origine, int *posOrig, unsigned char *destinazione, int *offset, unsigned char *label);

char *tbl[256] = {"{00}", "{01}", "{02}", "{03}", "{04}", "{05}", "{06}", "{07}", "{08}", "{09}", "{0A}", "{0B}", "{0C}", "{0D}", "{0E}", "{0F}", 
                  "{10}", "{11}", "{12}", "{13}", "{14}", "{15}", "{16}", "{17}", "{18}", "{19}", "\n<new/>", "\n<wait/>", "{1C}", "{1D}", "{1E}", "\n", 
                  " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", 
                  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<;", "=", ">", "?", 
                  "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", 
                  "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", 
                  "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", 
                  "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{{", "|", "}}", "~", "{7F}", 
                  "{80}", "{81}", "{82}", "{83}", "{84}", "{85}", "{86}", "{87}", "{88}", "{89}", "{8A}", "{8B}", "{8C}", "{8D}", "{8E}", "{8F}", 
                  "{90}", "{91}", "{92}", "{93}", "{94}", "{95}", "{96}", "{97}", "{98}", "{99}", "{9A}", "{9B}", "{9C}", "{9D}", "{9E}", "{9F}", 
                  "{A0}", "{A1}", "{A2}", "{A3}", "{A4}", "{A5}", "{A6}", "{A7}", "{A8}", "{A9}", "{AA}", "{AB}", "{AC}", "{AD}", "{AE}", "{AF}", 
                  "{B0}", "{B1}", "{B2}", "{B3}", "{B4}", "{B5}", "{B6}", "{B7}", "{B8}", "{B9}", "{BA}", "{BB}", "{BC}", "{BD}", "{BE}", "{BF}", 
                  "{C0}", "{C1}", "{C2}", "{C3}", "{C4}", "{C5}", "{C6}", "{C7}", "{C8}", "{C9}", "{CA}", "{CB}", "{CC}", "{CD}", "{CE}", "{CF}", 
                  "{D0}", "{D1}", "{D2}", "{D3}", "{D4}", "{D5}", "{D6}", "{D7}", "{D8}", "{D9}", "{DA}", "{DB}", "{DC}", "{DD}", "{DE}", "{DF}", 
                  "{E0}", "{E1}", "{E2}", "{E3}", "{E4}", "{E5}", "{E6}", "{E7}", "{E8}", "{E9}", "{EA}", "{EB}", "{EC}", "{ED}", "{EE}", "{EF}", 
                  "{F0}", "{F1}", "{F2}", "{F3}", "{F4}", "{F5}", "{F6}", "{F7}", "{F8}", "{F9}", "{FA}", "{FB}", "{FC}", "{FD}", "{FE}", "{FF}"};

int main(int argc, char *argv[]) {
   FILE *letto, *scritto;
   int err;
   
   if(argc == 4) {  // 4 argomenti richiesti
      if(!(strcmpi(argv[1], "-e"))) {  // opzioni supportate
         if((letto = fopen(argv[2], "rb")) == NULL) {  // apre il file in lettura
            printf("Impossibile aprire %s\n", argv[2]);
            exit(2);  // uscita con errore
         }
         if((scritto = fopen(argv[3], "wt")) == NULL) {  // apre il file in scrittura
            printf("Impossibile aprire %s\n", argv[3]);
            fclose(letto);
            exit(2);  // uscita con errore
         }
         err = GRA2_dumpa(letto, scritto);
      }
      if(!(strcmpi(argv[1], "-c"))) {  // opzioni supportate
         if((letto = fopen(argv[2], "rt")) == NULL) {  // apre il file in lettura
            printf("Impossibile aprire %s\n", argv[2]);
            exit(2);  // uscita con errore
         }
         if((scritto = fopen(argv[3], "wb")) == NULL) {  // apre il file in scrittura
            printf("Impossibile aprire %s\n", argv[3]);
            fclose(letto);
            exit(2);  // uscita con errore
         }
         err = GRA2_inserisci(letto, scritto);
      }
      fclose(letto);  // chiude i file
      fclose(scritto);
         
      if(err) {  // se c'e' un errore
         //unlink(argv[3]);  // elimina il file destinazione
         if(err == -1) printf("Errore nell'allocazione della memoria");
         else if(err == 2) printf("Impossibile leggere il file %s", argv[2]);
         else printf("%d Impossibile scrivere il file %s", err, argv[3]);
         printf(" - Operazione non riuscita\n");
         exit(2);  // uscita con errore
      }
      printf("Grandia 2 text dumper/inserter 0.1Beta4 by Mat - Operazione riuscita\n");
      exit(0);  // uscita corretta
   }      
   printf("Grandia 2 text dumper/inserter 0.1Beta4 by Mat - USO:\nGR2dump -e origine.dat destinazione.txt\nGR2dump -c origine.txt destinazione.dat\n\nGrazie a Chop e a _Ombra_ per l'aiuto :)\n\nMat - 21/04/2004\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
   exit(1);  // // uscita con errore per mancanza di parameti
}

int GRA2_dumpa(FILE *orig, FILE *dest) {
   unsigned char *origine;  // conterra' i dati del file da dumpare
   int filesize;  // grandezza dei file da dumpare
   unsigned char *inizioTesto;
   int dimHeader;
   int i;
   int posIniz;
   int posFine;

   if(fseek(orig, 0, SEEK_END)) return 2;  // fine del file
   if((filesize = ftell(orig)) == -1) return 2;  // dimensione del file
   if(fseek(orig, 0, SEEK_SET)) return 2;  // ritorna all'inizio
   if(!(origine = malloc(filesize))) return -1;  // alloca la memoria necessaria per il file
   if(fread(origine, filesize, 1, orig) != 1) { free(origine); return 2; };  // legge il contenuto del file

   dimHeader = *((int*)origine);
   inizioTesto = origine + dimHeader;
   fprintf(dest, "<grandiaDump version=\"0.1b4\" numStanze=\"%.4X\">", (dimHeader - 8) / 4);
   for(i = 4; i < dimHeader - 4; i += 4) {
      posIniz = 0;
      posFine = 0;
      memcpy(&posIniz, origine + i + 2, 2);
      posIniz <<= 3;
      memcpy(&posFine, origine + i + 6, 2);
      posFine <<= 3;
      if(posFine > filesize) posFine = filesize - dimHeader;
      GRA2_dumpaTesto(dest, inizioTesto, posIniz, posFine, origine + i);
   }
   fprintf(dest, "\n</grandiaDump>");
   return 0;
}

int GRA2_dumpaTesto(FILE *dump, unsigned char *orig, int i, int dim,  unsigned char *label) {
   static int numPtr = 0;

   int rawData = 1;
   int j;
   unsigned short ptr[1000];
   unsigned short flag;
   
   fprintf(dump, "\n<stanza label=\"%.2X%.2X\">", label[0], label[1]);
   while(i < dim) {
      for(j = 0; j < numPtr; ++j) {
         if(ptr[j] == i) fprintf(dump, "\n<ref num=\"%.4X\"/>", j);
      }
      switch(orig[i]) {
         case 0x03: if(orig[i + 1] == 0x10) {
                        memcpy(ptr + numPtr, orig + i + 2, 2);
                        fprintf(dump, "\n<ptr num=\"%.4X\"/>", numPtr);
                        ++numPtr;
                     }
                     else fprintf(dump, "\n<op03 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]);
                     i += 4; break;
         case 0x04: fprintf(dump, "\n<op04 value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x05: fprintf(dump, "\n<op05 value=\"%.2X%.2X\"/>", orig[i + 1], orig[i + 2]); i += 3; break;
         case 0x06: fprintf(dump, "\n<op06 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x08: fprintf(dump, "\n<op08 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x09: fprintf(dump, "\n<op09 value=\"%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4]); i += 5; break;
/* ? */  case 0x0A: fprintf(dump, "\n<op0A value=\"%.2X%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5], orig[i + 6]); i += 7; break;
         case 0x0B: fprintf(dump, "\n<op0B value=\"%.2X%.2X\"/>", orig[i + 1], orig[i + 2]); i += 3; break;
/* ? */  case 0x0C: fprintf(dump, "\n<op0C value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
/* ? */  case 0x0D: fprintf(dump, "\n<op0D value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x0F: fprintf(dump, "\n<op0F value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
/* ? */  case 0x10: fprintf(dump, "\n<op10 value=\"%.2X%.2X%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5], orig[i + 6], orig[i + 7]); i += 8; break;
         case 0x11: fprintf(dump, "\n<op11 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x14: fprintf(dump, "\n<op14 value=\"%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5]); i += 6; break;
         case 0x15: fprintf(dump, "\n<op15 value=\"%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4]); i += 5; break;
         case 0x17: switch(orig[i + 1]) {
                       case 0x01: fprintf(dump, "\n<text>"); i += 2; break;
                       case 0x20: fprintf(dump, "\n<unk value=\"%.2X%.2X\"/>", orig[i + 2], orig [i + 3]); i += 4; break;
                       case 0x40: fprintf(dump, "\n<selection/>"); i += 2; break;
                       case 0x80: fprintf(dump, "\n<item num=\"%.2X%.2X\"/>", orig[i + 2], orig [i + 3]); i += 4; break;
                       case 0x00: fprintf(dump, "\n</text>"); i += 2; rawData = 1; break;
                       default: fprintf(dump, "%s", tbl[orig[i]]); ++i;
                    } break;
         case 0x18: fprintf(dump, "\n<portrait num=\"%.2X%.2X\"/>", orig[i + 1], orig [i + 2]); i += 3; break;
         case 0x1C: fprintf(dump, "\n<op1C value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x1D: if((orig[i + 1] == 0xFF) && (orig[i + 2] == 0x0F)) fprintf(dump, "\n<pause/>");
                    else fprintf(dump, "\n<op1D value=\"%.2X%.2X\"/>", orig[i + 1], orig [i + 2]);
                    i += 3;
                    break;
//         case 0x22: fprintf(dump, "\n<op22 num=\"%.2X\"/>\n", orig[i + 1]); i += 2; break;
         default: fprintf(dump, "%s", tbl[orig[i]]); ++i;
      }
   }
   fprintf(dump, "\n</stanza>");
   return 0;
}

int GRA2_inserisci(FILE *orig, FILE *dest) {
   #define MAX_LINEA 100000
   unsigned char *origine;
   unsigned char *destinazione;
   unsigned char *stanze;
   unsigned char valori[20];
   int filesize;  // grandezza dei file da dumpare
   int numStanze;
   int dimHeader;
   int offset = 0;
   int posOrig;
   int tmp = 0xFFFFFFFF;
   int i;

   if(fseek(orig, 0, SEEK_END)) return 2;  // fine del file
   if((filesize = ftell(orig)) == -1) return 2;  // dimensione del file
   if(fseek(orig, 0, SEEK_SET)) return 2;  // ritorna all'inizio
   if(!(origine = malloc(filesize+5050))) return -1;  // alloca la memoria necessaria per il file
   if(!(destinazione = malloc(filesize+5050))) return -1;  // alloca la memoria necessaria per il file
   filesize = fread(origine, 1, filesize+5050, orig);  // legge il con
   if((posOrig = GRA2_strCompare("<grandiaDump version=\"0.1b4\" numStanze=\"\">", origine, valori)) == -1) return 1;

   numStanze = valori[1] + (valori[0] << 8);
   dimHeader = (numStanze * 4) + 8;
   stanze = destinazione + dimHeader;
   memcpy(destinazione, &dimHeader, 4);
   memcpy(destinazione + (dimHeader - 4), &tmp, 4);
   
   for(i = 0; i < numStanze; ++i) {
      if(offset & 7) offset = (offset | 7) + 1;
      tmp = offset >> 3;
      memcpy(destinazione + 6 + (i * 4), &tmp, 2);
      GRA2_inserisciStanza(origine, &posOrig, stanze, &offset, destinazione + 4 + (i * 4));
   }
   fwrite(destinazione, offset + dimHeader, 1, dest);
   return 0;
}

int GRA2_inserisciStanza(unsigned char *origine, int *posOrig, unsigned char *destinazione, int *offset, unsigned char *label) {
   unsigned char valori[20];
   int i;
   int n;
   unsigned short posPtr[5000] = {0};
   
   if((n = GRA2_strCompare("\n<stanza label=\"\">", origine + *posOrig, label)) == -1) {*posOrig += n; printf("g"); exit(1);return 0;}
   *posOrig += n;

   while(1) {
      if((n = GRA2_strCompare("\n</stanza>", origine + *posOrig, NULL)) != -1) {
         *posOrig += n;
         for(i = 0; i < 5000; ++i) {
            if(posPtr[i] != 0) printf("%.4X\n", i);
         }
         return 0;
      }
      else if((n = GRA2_strCompare("\n<ptr num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x03;
         destinazione[(*offset)++] = 0x10;
         posPtr[(valori[0] << 8) + valori[1]] = *offset;
         *offset += 2;
      }
      else if((n = GRA2_strCompare("\n<ref num=\"\"/>", origine + *posOrig, valori)) != -1) {
        memcpy(destinazione + posPtr[(valori[0] << 8) + valori[1]], offset, 2);
        posPtr[(valori[0] << 8) + valori[1]] = 0;
      }
      else if((n = GRA2_strCompare("\n<op03 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x03;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op04 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x04;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op05 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x05;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op06 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x06;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op08 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x08;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];  
      }
      else if((n = GRA2_strCompare("\n<op09 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x09;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
      }
      else if((n = GRA2_strCompare("\n<op0A value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0A;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
         destinazione[(*offset)++] = valori[5];
      }
      else if((n = GRA2_strCompare("\n<op0B value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0B;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op0C value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0C;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op0D value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0D;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op0F value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0F;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op10 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x10;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
         destinazione[(*offset)++] = valori[5];
         destinazione[(*offset)++] = valori[6];
      }
      else if((n = GRA2_strCompare("\n<op11 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x11;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];  
      }
      else if((n = GRA2_strCompare("\n<op14 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x14;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
      }
      else if((n = GRA2_strCompare("\n<op15 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x15;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
      }
      else if((n = GRA2_strCompare("\n<text>", origine + *posOrig, NULL)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x01;
      }
      else if((n = GRA2_strCompare("\n<unk value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x20;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<selection/>", origine + *posOrig, NULL)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x40;
      }
      else if((n = GRA2_strCompare("\n<item num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x80;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n</text>", origine + *posOrig, NULL)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x00;
      }
      else if((n = GRA2_strCompare("\n<portrait num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x18;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op1C value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1C;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<pause/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1D;
         destinazione[(*offset)++] = 0xFF;
         destinazione[(*offset)++] = 0x0F;
      }
      else if((n = GRA2_strCompare("\n<op1D value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1D;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else {
         for(i = 0; i < 256; ++i) {
            if((n = GRA2_strCompare(tbl[i], origine + *posOrig, NULL)) != -1) {
               destinazione[(*offset)++] = i;
               break;
            }
         }
      }
   *posOrig += n;
   }
   return 0;
}

int GRA2_strCompare(char *expr, char *string, unsigned char *value) {
   int i = 0;
   int j = 0;
   int v = 0;
   int tmp;
   char byte[3];
   byte[2] = '\0';
   
   while(expr[i] != '\0') {
      if(expr[i] == '') {
         byte[0] = string[j];
         byte[1] = string[++j];
         sscanf(byte, "%x", &tmp);
         value[v++] = tmp;
      }
      else {
         if(expr[i] != string[j]) return -1;
      }
      ++i; ++j;
   }
   return j;
}
