/* PVMH Grandia 2 file extractor/compressor 0.2beta2 by Mat mattia.d.r@libero.it
Programma che gestisce gli archivi di Grandia 2.
Dato che non ho il gioco non ho ne ho potuto testare il funzionamento,
spero che funzioni!
Il codice e stato scritto facendo in modo che le funzioni siano riutilizzabili
e gestiscano gli errori delle system call.
Penso di aver scritto un codice decente anche se i commenti non sono molti (ho
questa cattiva abitudine). Se qualche riga e' poco chiara contattami.
Questo programma e' stato scritto con Dev-C++ e compilato con gcc, e una
richiesta fondamentale per il funzionamento e' che i dati siano Little Endian
e che gli int siano a 4 byte e i char a 1 byte (e' per questo che nelle 
funzioni non ho usato sizeof(int), perche' se la dimensione fosse diversa non
il programma non funzionerebbe comunque).

Mat - 15/07/2003
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#define MAXDIR 256
#define BUFFSIZE 32768

int estrai_archivioPVMH(FILE *arc, FILE *out);
/* Estrae un archivio di PVMH di Grandia 2, scrivendo su out il nome dei file
   estratti e alcuni errori
    arc: file pointer dell'archivio da creare (aprire in "rb")
    out: file pointer su cui verranno scritti i messaggi, se 0 non stampa messaggi
    
    Valore di ritorno:
    0 in caso di successo
    1 se il file non e' un archivio
    2 in caso di errore di lettura o di seek
    3 in caso di errore di lettura dall'archivio di uno specifico file (messaggio su out)
    4 nel caso che sia impossibile creare un file (messaggio su out)
    5 in caso si errore di scrittura di un file (messaggio su out)
    
    NOTA: La funzione non chiude i file pointer passati e muove il seek
*/

int main(int argc, char *argv[]) {

   int err = 1;
   FILE *arc;
   
   if(argc >= 3) {  // Se ci sono almeno 3 argomenti
 
      if((argc <= 4) && (!strcmpi(argv[1], "-e"))) {  // Estrazione di un archivio
         char old_dir[MAXDIR];

         if((arc = fopen(argv[2], "rb")) == NULL) {
            printf("Impossibile aprire il file %s - Operazione non riuscita\n", argv[2]);
            exit(1);
         }
         
         if(argc == 4) {
            if(!getcwd(old_dir, MAXDIR)) {
               printf("Impossibile ottenere la directory corrente - Operazione non riuscita\n");
               exit(1);
            }
            mkdir(argv[3]);
            if(chdir(argv[3])) {
               printf("Impossibile entrare nella directory destinazione - Operazione non riuscita\n");
               exit(1);
            }
         }
         err = estrai_archivioPVMH(arc, stdout);
         fclose(arc);
         if(argc == 4) chdir(old_dir);
         if(err) {  // se ci sono errori
            if(err == 1) printf("Il file non \212 un archivio PVMH di Grandia 2");
            else if(err == 2) printf("Errore di lettura nell'archivio");
            // negli altri casi il messaggio e' stampato dalla funzione
            printf(" - Operazione non riuscita\n");
            exit(1);
         }
      }
      
      /*else if((argc >= 4) && (!strcmpi(argv[1], "-c"))) {
         
         if((arc = fopen(argv[2], "wb")) == NULL) {
            printf("Impossibile creare il file %s - Operazione non riuscita\n", argv[2]);
            exit(1);
         }
         
         err = crea_archivioPVMH(arc, argv + 3, argc - 3);
         fclose(arc);
         if(err) {  // se c'e' un errore
            if(err == 1) printf("Impossibile scrivere il file %s", argv[2]);
            else if(err == -1) printf("Errore nell'allocazione della memoria");
            else printf("Impossibile leggere il file %s", argv[err + 1]);
            unlink(argv[2]);  // elimina l'archivio corrotto
            printf(" - Operazione non riuscita\n");
            exit(1);
         }
      }*/
   }
   
   if(err) {  // se non abbiamo digitato un parametro corretto
      printf("PVMH Grandia 2 file extractor 0.1beta by Mat - USO:\nextPVMH -e archivio [destinazione]   (estrae i file in un archivio)\n\nMat - 15/07/2003\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
      exit(1);
   }
   printf("PVMH Grandia 2 file extractor 0.1beta by Mat - Operazione riuscita\n"); // uscita normale
   exit(0);
}

int estrai_archivioPVMH(FILE *arc, FILE *out) {
   #define PVRTSALTO 6176
   #define PVRTSIZE 6160
   int header[2], numfile, count;
   char nomefile[29], buffer[PVRTSIZE];
   FILE *dest;

   if(fseek(arc, 0, SEEK_SET)) return 2;
   if(fread(header, 4, 2, arc) != 2) return 2;
   if(header[0] != 0x484D5650) return 1;  // il file non e' un archivio
   if(fseek(arc, 10, SEEK_SET)) return 2;
   if(fread(&numfile, 4, 1, arc) != 1) return 2;
   nomefile[28] = '\0';
   header[1] += 8;
   
   for(count = 0; count < numfile; ++count) {  //  cicla per tutti i file
      if(fseek(arc, 14 + (count * 38), SEEK_SET)) return 2;  // va nell'entrata del file
      if(fread(nomefile, 1, 28, arc) != 28) return 2;
      if(fseek(arc, header[1] + (PVRTSALTO * count), SEEK_SET)) return 2;  // si posiziona dov'e' il contenuto del file
      if((dest = fopen(nomefile, "wb")) == NULL) {
         if(out) fprintf(out, "Impossibile creare il file %s", nomefile);
         return 4;
      }
      if(fread(buffer, 1, PVRTSIZE, arc) != PVRTSIZE) {
         fclose(dest);
         unlink(nomefile);
         if(out) fprintf(out, "Impossibile leggere il file %s dall'archivio", nomefile);
         return 3;
      }  // servono a leggere un blocco dati
      if(fwrite(buffer, 1, PVRTSIZE, dest) != PVRTSIZE) {
         fclose(dest);
         unlink(nomefile);
         if(out) fprintf(out, "Impossibile scrivere il file %s", nomefile);
         return 5;
      }  // scrive un blocco dati
      fclose(dest);
      if(out) fprintf(out, "%s\n", nomefile);  // scrive il nome del file
   }
   return 0;
}
