/* AFS Grandia 2 archive extractor/creator 0.4beta by Mat
Programma che gestisce gli archivi di Grandia 2 in formato AFS.
Il codice e stato scritto facendo in modo che le funzioni siano riutilizzabili
e gestiscano gli errori delle system call.
Penso di aver scritto un codice decente anche se i commenti non sono molti e
non spiegano granche' (ho questa cattiva abitudine). Se qualche riga e' poco
chiara contattami.
Questo programma e' stato scritto con Dev-C++ e compilato con gcc, e una
richiesta fondamentale per il funzionamento e' che i dati siano Little Endian
e che gli int siano a 4 byte e i char a 1 byte (e' per questo che nelle 
funzioni non ho usato sizeof(int), perche' se la dimensione fosse diversa non
il programma non funzionerebbe comunque).

Mat - 15/09/2003
E-mail: mattia.d.r@libero.it
Sito:   http://www.matzone.altervista.org
Membro dei SadNES cITy: http://www.sadnescity.it
Public Release: 11/08/2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#define MAXDIR 256
#define BUFFSIZE 32768

int crea_archivioAFS(FILE *dest, char *(*origN), unsigned int numfile);
/* Crea un archivio AFS compatibile con Grandia 2
    dest:    file pointer dell'archivio da creare (aprire in "wb")
    origN:   array di stringhe contenente il nome dei file da aggiungere all'archivio
    numfile: numero di file da aggiungere all'archivio
    
    Valore di ritorno:
    0 in caso di successo
    1 in caso di errori di scrittura o di seek dell'archivio
    > 1 quando un file ha provocato errori in lettura (ritorna l'indice + 2
      del file che ha provocato errori in lettura nell'array origN)
    
    NOTA: La funzione non chiude il file pointer passato e cambia il seek
*/

int estrai_archivioAFS(FILE *arc, FILE *out, int est);
/* Estrae un archivio di AFS di Grandia 2, scrivendo su out il nome dei file
   estratti e alcuni errori
    arc: file pointer dell'archivio da creare (aprire in "rb")
    out: file pointer su cui verranno scritti i messaggi, se 0 non stampa messaggi
    est: se diverso da 0 la funzione aggiunge un estensione ai file estratti in base all'header
    
    Valore di ritorno:
    0 in caso di successo
    1 se il file non e' un archivio
    2 in caso di errore di lettura o di seek
    3 in caso di errore di lettura dall'archivio di uno specifico file (messaggio su out)
    4 nel caso che sia impossibile creare un file (messaggio su out)
    5 in caso si errore di scrittura di un file (messaggio su out)
    
    NOTA: La funzione non chiude i file pointer passati e muove il seek
*/

int main(int argc, char *argv[]) {

   int err = 1;
   FILE *arc;
   
   if(argc >= 3) {  // Se ci sono almeno 3 argomenti
 
      if((argc <= 4) && !((err = strcmpi(argv[1], "-e")) && strcmpi(argv[1], "-ef"))) {  // Estrazione di un archivio
         char old_dir[MAXDIR];

         if((arc = fopen(argv[2], "rb")) == NULL) {  // apre l'archivio
            printf("Impossibile aprire il file %s - Operazione non riuscita\n", argv[2]);
            exit(2);  // uscita con errore
         }
         
         if(argc == 4) {  // se abbio specificato la dir destinazione
            if(!getcwd(old_dir, MAXDIR)) {  //ottime la dir corrente
               printf("Impossibile ottenere la directory corrente - Operazione non riuscita\n");
               exit(2);  // uscita con errore
            }
            mkdir(argv[3]);  // prova a creare la dir destinazione
            if(chdir(argv[3])) {  // entra nella dir destinazione
               printf("Impossibile entrare nella directory destinazione - Operazione non riuscita\n");
               exit(2);  // uscita con errore
            }
         }
         err = estrai_archivioAFS(arc, stdout, err);  // estrae l'archivio
         fclose(arc);  // chiude l'archivio
         if(argc == 4) chdir(old_dir);  // ripristina la dir iniziale
         if(err) {  // se ci sono errori
            if(err == 1) printf("Il file non \212 un archivio AFS di Grandia 2");
            else if(err == 2) printf("Errore di lettura nell'archivio");
            // negli altri casi il messaggio e' stampato dalla funzione
            printf(" - Operazione non riuscita\n");
            exit(2);  // uscita con errore
         }
      }
      
      else if((argc >= 4) && (!strcmpi(argv[1], "-c"))) {  // Creazione archivio
         
         if((arc = fopen(argv[2], "wb")) == NULL) { // Crea if file archivio 
            printf("Impossibile creare il file %s - Operazione non riuscita\n", argv[2]);
            exit(2);  // uscita con errore
         }
         
         err = crea_archivioAFS(arc, argv + 3, argc - 3);  // crea l'archivio
         fclose(arc);  // chiude l'archivio
         if(err) {  // se c'e' un errore
            if(err == 1) printf("Impossibile scrivere il file %s", argv[2]);
            else if(err == -1) printf("Errore nell'allocazione della memoria");
            else printf("Impossibile leggere il file %s", argv[err + 1]);
            unlink(argv[2]);  // elimina l'archivio corrotto
            printf(" - Operazione non riuscita\n");
            exit(2);  // uscita con errore
         }
      }
   }
   
   if(err) {  // se non abbiamo digitato un parametro corretto
      printf("AFS Grandia 2 archive extractor/creator 0.4beta by Mat - USO:\nextAFS -e archivio [destinazione]   (estrae i file in un archivio)\nextAFS -ef archivio [destinazione]  (estrae e aggiunge il formato del file)\nextAFS -c archivio file1 file2 file3 ...   (ricrea un archivio)\n\nMat - 15/09/2003\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\nPublic Release: 11/08/2004\n");
      exit(1);  // uscita con errore per mancanza di parameti
   }
   printf("AFS Grandia 2 archive extractor/creator 0.4beta by Mat - Operazione riuscita\n"); // uscita normale
   exit(0);  // uscita corretta
}

int estrai_archivioAFS(FILE *arc, FILE *out, int est) {
   unsigned int offset, size, blocco, numfile, count;
   char nomefile[13], buffer[BUFFSIZE];
   char *estensioni[8] = {"unkn", "afs", "l62c", "pvmh", "gbix.pvr", "pvrt.pvr", "gixl", "dsth"};
   FILE *dest;

   if(fseek(arc, 0, SEEK_SET)) return 2;  // va all'inizio
   if(fread(&size, 4, 1, arc) != 1) return 2; // legge l'header
   if(size != 0x534641) return 1;  // il file non e' un archivio
   if(fread(&numfile, 4, 1, arc) != 1) return 2;  // legge in numero di file
   
   for(count = 0; count < numfile; ++count) {  //  cicla per tutti i file
      if(fseek(arc, 8 + (count << 3), SEEK_SET)) return 2;  // va nell'entrata del file
      if((fread(&offset, 4, 1, arc) + fread(&size, 4, 1, arc)) != 2) return 2;
      if(fseek(arc, offset, SEEK_SET)) return 2;  // si posiziona dov'e' il contenuto del file
      if(est) {
         if(fread(&blocco, 4, 1, arc) != 1) blocco = 0;  // legge l'header del file
         else switch(blocco) {
            case 0x534641:   blocco = 1; break;  // AFS
            case 0x4332364C: blocco = 2; break;  // L62C
            case 0x484D5650: blocco = 3; break;  // PVMH
            case 0x58494247: blocco = 4; break;  // GBIX
            case 0x54525650: blocco = 5; break;  // PVRT
            // formati sconusciuti
            case 0x4C584947: blocco = 6; break;  // GIXL
            case 0x48545344: blocco = 7; break;  // DSTH
            default: blocco = 0;
         }
         if(fseek(arc, offset, SEEK_SET)) return 2;  // ripristina l'offset
         // il nome del file e' uguale a count + 1 piu' l'estensione
         sprintf(nomefile, "%.2d.%s", count + 1, estensioni[blocco]);
      }
      else sprintf(nomefile, "%.2d", count + 1);  // il nome del file e' uguale a count + 1
      if((dest = fopen(nomefile, "wb")) == NULL) {  // crea il file destinazione
         if(out) fprintf(out, "Impossibile creare il file %s", nomefile);
         return 4;
      }
      if(out) fprintf(out, "%s -%8d byte\n", nomefile, size);  // scrive il nome del file
      while(size > 0) {  // cicla finche' ci sono dati da leggere
         if(size < BUFFSIZE) blocco = size;  // ci sono da leggere meno dati della grandezza del buffer
         else blocco = BUFFSIZE;  // dati maggiori della grandezza del buffer
         if(fread(buffer, 1, blocco, arc) != blocco) {  // legge un blocco dati
            fclose(dest);
            unlink(nomefile);
            if(out) fprintf(out, "Impossibile leggere il file %s dall'archivio", nomefile);
            return 3;
         }
         if(fwrite(buffer, 1, blocco, dest) != blocco) {// scrive un blocco dati
            fclose(dest);
            unlink(nomefile);
            if(out) fprintf(out, "Impossibile scrivere il file %s", nomefile);
            return 5;
         }  
         size -= blocco;  // diminuisce i dati ancora da scrivere
      }
      fclose(dest);  // chiude il file destinazione
   }
   return 0;
}

int crea_archivioAFS(FILE *dest, char *(*origN), unsigned int numfile) {
   // i file vanno posizionati all'inzio di un blocco
   #define BLOCKSIZE 2048
   char buffer[BUFFSIZE];
   char blank[BLOCKSIZE] = "AFS";  // header dell'archivio
   FILE *orig;
   unsigned int i, nbyte, tab[2];  // coppia offeset-grandezza
    
   if(fseek(dest, 0, SEEK_SET)) return 1;  // inzio dell'archivio
   *(unsigned int *)(blank + 4) = numfile;  // imposta il numero di file
   if(fwrite(blank, 1, BLOCKSIZE, dest) != BLOCKSIZE) return 1;  // scrive l'inizio del file
   for(i = 0; i < 8; ++i) blank[i] = '\0';  // rimette blank a 0
   
   for(i = 0; i < numfile; ++i) {  // per tutti  i file
      if((tab[0] = ftell(dest)) == -1) return 1;  // salva l'offset del file
      if((orig = fopen(origN[i], "rb")) == NULL) return i + 2;  // apre il file
      tab[1] = 0;  // grandezza del file a 0
      while((nbyte = fread(buffer, 1, BUFFSIZE, orig)) > 0) {  // legge il file
         if(fwrite(buffer, 1, nbyte, dest) != nbyte) {fclose(orig); return 1;}  // scrive l'achivio
         tab[1] += nbyte;  // aumenta la grandezza del file
      }
      if(ferror(orig)) return i + 2;  // se ce stato errore in lettura
      fclose(orig);
      if(nbyte = tab[1] % BLOCKSIZE) {  // se la grandezza non e' un multiplo di BLOCKSIZE scrive dei blank
         if(fwrite(blank, 1, BLOCKSIZE - nbyte, dest) != BLOCKSIZE - nbyte) return 1;
      }
      if((nbyte = ftell(dest)) == -1) return 1;  // salva l'offeset corrente
      if(fseek(dest, 8 + (i * 8), SEEK_SET)) return 1;  // si posizione nell'entata della tabella dei file
      if(fwrite(tab, 4, 2, dest) != 2) return 2;  // scrive la coppia offeset-grandezza
      if(fseek(dest, nbyte, SEEK_SET)) return 1;  // ritorna nella posizone iniziale
   }
   return 0;  // fine con successo
}

