/*
03-3
04-1
05-2
06-3
07-5
08-3
09-4
0A-6 ?
0B-2
0C-1 ?
0D-1
0E-3
0F-1
10-7 ?
11-3
14-5
15-4
16-2 ?
17-1/3
18-2
1C-1
1D-2/3
1E-1
*/

/*
Info su beta5 by chop:
Ho semplicente modificato alla meno peggio le routine di estrazione/inserimento
per gestire direttamente gli archivi anzich la singola parte del testo
Il programma si occupa anche dell'aggiornamento dei puntatori dei file che seguono
il testo in modo da poter permettere una evntuale espansione del testo.
NOTA BENE: questa funzionalit  stata testata solo parzialmente, quindi potrebbero
esserci dei casi in cui non funzioni correttamente.

Info su Beta6b by chop:
- Modificato opcode 1D: Ha 2 parametri se il primo  FF altrimenti ne ha 3

Beta7
- Lettere accentate
- Risolto loop su caratteri non validi
- Messaggi di debug vari

Beta8
- aggiunto opcode 1E con 1 parametro
- aggiungi 2 parametri all'opcode 17 quando  seguito da 40 (in pratica 17 40 xx xx)

Beta8l
- scrittura file log

Beta9 (nuovi opcode scoperti da chop)
 07 - 5 parametri
 0E - 3 parametri
 16 - 2 parametri (?)
 Sull'opcode 16 non sono molto sicuro, comunque da quello che ho visto lo si trova solo nei tutorial.

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

FILE *logs;
char op_usati[256] = {0};

int GRA2_dumpa(FILE *orig, FILE *dest);

int GRA2_inserisci(FILE *orig, char *dest);		//<---Modificato!

int GRA2_strCompare(char *expr, char *string, unsigned char *value);

int GRA2_inserisciStanza(unsigned char *origine, int *posOrig, unsigned char *destinazione, int *offset, unsigned char *label);

char *tbl[256] = {"{00}", "{01}", "{02}", "{03}", "{04}", "{05}", "{06}", "{07}", "{08}", "{09}", "{0A}", "{0B}", "{0C}", "{0D}", "{0E}", "{0F}", 
                  "{10}", "{11}", "{12}", "{13}", "{14}", "{15}", "{16}", "{17}", "{18}", "{19}", "\n<new/>", "\n<wait/>", "{1C}", "{1D}", "{1E}", "\n", 
                  " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", 
                  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<;", "=", ">", "?", 
                  "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", 
                  "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", 
                  "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", 
                  "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{{", "|", "}}", "~", "{7F}", 
                  "", "", "", "", "", "", "", "", "", "", "", "", "{8C}", "{8D}", "{8E}", "{8F}", 
                  "{90}", "{91}", "{92}", "{93}", "{94}", "{95}", "{96}", "{97}", "{98}", "{99}", "{9A}", "{9B}", "{9C}", "{9D}", "{9E}", "{9F}", 
                  "{A0}", "{A1}", "{A2}", "{A3}", "{A4}", "{A5}", "{A6}", "{A7}", "{A8}", "{A9}", "{AA}", "{AB}", "{AC}", "{AD}", "{AE}", "{AF}", 
                  "{B0}", "{B1}", "{B2}", "{B3}", "{B4}", "{B5}", "{B6}", "{B7}", "{B8}", "{B9}", "{BA}", "{BB}", "{BC}", "{BD}", "{BE}", "{BF}", 
                  "{C0}", "{C1}", "{C2}", "{C3}", "{C4}", "{C5}", "{C6}", "{C7}", "{C8}", "{C9}", "{CA}", "{CB}", "{CC}", "{CD}", "{CE}", "{CF}", 
                  "{D0}", "{D1}", "{D2}", "{D3}", "{D4}", "{D5}", "{D6}", "{D7}", "{D8}", "{D9}", "{DA}", "{DB}", "{DC}", "{DD}", "{DE}", "{DF}", 
                  "{E0}", "{E1}", "{E2}", "{E3}", "{E4}", "{E5}", "{E6}", "{E7}", "{E8}", "{E9}", "{EA}", "{EB}", "{EC}", "{ED}", "{EE}", "{EF}", 
                  "{F0}", "{F1}", "{F2}", "{F3}", "{F4}", "{F5}", "{F6}", "{F7}", "{F8}", "{F9}", "{FA}", "{FB}", "{FC}", "{FD}", "{FE}", "{FF}"};

int main(int argc, char *argv[]) {
   FILE *letto, *scritto;
   int err;
   for(err=0; err<256; ++err) op_usati[err] = 0;
   
   if(argc == 4) {  // 4 argomenti richiesti
      if(!(strcmpi(argv[1], "-e"))) {  // opzioni supportate
         char nomelog[256];
         if((letto = fopen(argv[2], "rb")) == NULL) {  // apre il file in lettura
            printf("Impossibile aprire %s\n", argv[2]);
            exit(2);  // uscita con errore
         }
         if((scritto = fopen(argv[3], "wt")) == NULL) {  // apre il file in scrittura
            printf("Impossibile aprire %s\n", argv[3]);
            fclose(letto);
            exit(2);  // uscita con errore
         }
         sprintf(nomelog, "%s.log", argv[2]);
         if((logs = fopen(nomelog, "wt")) == NULL) {  // apre il file in scrittura
            printf("Impossibile aprire %s\n", nomelog);
            fclose(scritto);
            fclose(letto);
            exit(2);  // uscita con errore
         }
         err = GRA2_dumpa(letto, scritto);
      }
      if(!(strcmpi(argv[1], "-c"))) {  // opzioni supportate
         if((letto = fopen(argv[2], "rt")) == NULL) {  // apre il file in lettura
            printf("Impossibile aprire %s\n", argv[2]);
            exit(2);  // uscita con errore
         }
         if((scritto = fopen(argv[3], "rb")) == NULL) {  // apre il file in scrittura
            printf("Impossibile aprire %s\n", argv[3]);
            fclose(letto);
            exit(2);  // uscita con errore
         }
		 fclose(scritto);
         err = GRA2_inserisci(letto, argv[3]);
      }
      fclose(letto);  // chiude i file

         
      if(err) {  // se c'e' un errore
         //unlink(argv[3]);  // elimina il file destinazione
         if(err == -1) printf("Errore nell'allocazione della memoria");
         else if(err == 2) printf("Impossibile leggere il file %s", argv[2]);
         else if(err == 3) printf("Il file %s non \212 un dump di questa versione", argv[2]);
         else printf("%d Impossibile scrivere il file %s", err, argv[3]);
         printf(" - Operazione non riuscita\n");
         exit(2);  // uscita con errore
      }
      printf("Grandia 2 text dumper/inserter 0.1Beta9a by Mat - Operazione riuscita\n");
      exit(0);  // uscita corretta
   }      
   printf("Grandia 2 text dumper/inserter 0.1Beta9a by Mat - USO:\nGR2dump -e origine.dat destinazione.txt\nGR2dump -c origine.txt destinazione.dat (file originale non tradotto)\n\nStudio degli opcode by Chop\n\nMat - 11/10/2004\nE-mail:\tmattia.d.r@libero.it\nSito:\thttp://www.matzone.altervista.org\nMembro dei SadNES cITy: http://www.sadnescity.it\n");
   exit(1);  // // uscita con errore per mancanza di parameti
}

int GRA2_dumpa(FILE *orig, FILE *dest) {
   unsigned char *origine;  // conterra' i dati del file da dumpare
   int filesize;  // grandezza dei file da dumpare
   unsigned char *inizioTesto;
   int dimHeader;
   int i;
   int posIniz;
   int posFine;
   
   int numPtr = 0;
   unsigned short ptr[1000];
   unsigned char type[1000];

   //Leggi lunghezza e posizione del testo nell'archivio
   unsigned long txt_pos=0;

   if(fseek(orig, 0x78, SEEK_SET)) return 2;  
   fread(&filesize, 4, 1, orig);
   if(fseek(orig, 0x7C, SEEK_SET)) return 2; 
   fread(&txt_pos, 4, 1, orig);   

   if(fseek(orig, txt_pos, SEEK_SET)) return 2;  // ritorna all'inizio
   if(!(origine = malloc(filesize))) return -1;  // alloca la memoria necessaria per il file
   if(fread(origine, filesize, 1, orig) != 1) { free(origine); return 2; };  // legge il contenuto del file
   
   dimHeader = *((int*)origine);
   inizioTesto = origine + dimHeader;
   for(i = 4; i < dimHeader - 4; i += 4) {
      posIniz = 0;
      posFine = 0;
      memcpy(&posIniz, origine + i + 2, 2);
      posIniz <<= 3;
      memcpy(&posFine, origine + i + 6, 2);
      posFine <<= 3;
      if(posFine > filesize) posFine = filesize - dimHeader;
      GRA2_analisiTesto(inizioTesto, posIniz, posFine, ptr, type, &numPtr);
   }
   
   fprintf(logs, "GR2dump 0.1b9 - Opcode sospetti:\n");

   dimHeader = *((int*)origine);
   inizioTesto = origine + dimHeader;
   fprintf(dest, "<grandiaDump version=\"0.1b9\" numStanze=\"%.4X\">", (dimHeader - 8) / 4);
   for(i = 4; i < dimHeader - 4; i += 4) {
      posIniz = 0;
      posFine = 0;
      memcpy(&posIniz, origine + i + 2, 2);
      posIniz <<= 3;
      memcpy(&posFine, origine + i + 6, 2);
      posFine <<= 3;
      if(posFine > filesize) posFine = filesize - dimHeader;
      GRA2_dumpaTesto(dest, inizioTesto, posIniz, posFine, origine + i, ptr, type, numPtr);
   }
   fprintf(dest, "\n</grandiaDump>");
   fprintf(logs, "Operatori sconosciuti:");
   // salto 00 01 02 0A 0B 0F
   for(i = 0x03; i <= 0x19; ++i) if(op_usati[i] != 0) fprintf(logs, " %.2X", i);
   for(i = 0x1C; i <= 0x1E; ++i) if(op_usati[i] != 0) fprintf(logs, " %.2X", i);
   fprintf(logs, "\nCodici non visualizabili usati:");
   for(i = 0x8C; i < 256; ++i) if(op_usati[i] != 0) fprintf(logs, " %.2X", i);
   fprintf(logs, "\n");
   return 0;
}

int GRA2_dumpaTesto(FILE *dump, unsigned char *orig, int i, int dim,  unsigned char *label, unsigned short *ptr, unsigned char *type, int numPtr) {
   int j;
   static int localPtr = 0;
   
   fprintf(dump, "\n<stanza label=\"%.2X%.2X\">", label[0], label[1]);
   while(i < dim) {
      for(j = 0; j < numPtr; ++j) {
         if(ptr[j] == i) fprintf(dump, "\n<ref type=\"%.2X\" num=\"%.4X\"/>", type[j], j);
      }
      switch(orig[i]) {
         case 0x03: if((orig[i + 1] == 0x10) || (orig[i + 1] == 0x20)) {
                        fprintf(dump, "\n<ptr type=\"%.2X\" num=\"%.4X\"/>", orig[i + 1], localPtr);
                        ++localPtr;
                     }
                     else {
                        fprintf(dump, "\n<op03 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]);
                        fprintf(logs, "<op03 value=\"%.2X%.2X%.2X\"/>\n", orig[i + 1], orig[i + 2], orig[i + 3]);
                     }
                     i += 4; break;
         case 0x04: fprintf(dump, "\n<op04 value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x05: fprintf(dump, "\n<op05 value=\"%.2X%.2X\"/>", orig[i + 1], orig[i + 2]); i += 3; break;
         case 0x06: fprintf(dump, "\n<op06 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x07: fprintf(dump, "\n<op07 value=\"%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5]); i += 6; break;
         case 0x08: fprintf(dump, "\n<op08 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x09: fprintf(dump, "\n<op09 value=\"%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4]); i += 5; break;
/* ? */  case 0x0A: fprintf(dump, "\n<op0A value=\"%.2X%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5], orig[i + 6]); i += 7; break;
         case 0x0B: fprintf(dump, "\n<op0B value=\"%.2X%.2X\"/>", orig[i + 1], orig[i + 2]); i += 3; break;
/* ? */  case 0x0C: fprintf(dump, "\n<op0C value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
/* ? */  case 0x0D: fprintf(dump, "\n<op0D value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x0E: fprintf(dump, "\n<op0E value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x0F: fprintf(dump, "\n<op0F value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
/* ? */  case 0x10: fprintf(dump, "\n<op10 value=\"%.2X%.2X%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5], orig[i + 6], orig[i + 7]); i += 8; break;
         case 0x11: fprintf(dump, "\n<op11 value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3]); i += 4; break;
         case 0x14: fprintf(dump, "\n<op14 value=\"%.2X%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4], orig[i + 5]); i += 6; break;
         case 0x15: fprintf(dump, "\n<op15 value=\"%.2X%.2X%.2X%.2X\"/>", orig[i + 1], orig[i + 2], orig[i + 3], orig[i + 4]); i += 5; break;
/* ? */  case 0x16: fprintf(dump, "\n<op16 value=\"%.2X%.2X\"/>", orig[i + 1], orig[i + 2]); i += 3; break;
         case 0x17: switch(orig[i + 1]) {
                       case 0x01: fprintf(dump, "\n<text>"); i += 2; break;
                       case 0x20: fprintf(dump, "\n<unk value=\"%.2X%.2X\"/>", orig[i + 2], orig [i + 3]); i += 4; break;
                       case 0x40: fprintf(dump, "\n<selection value=\"%.2X%.2X\"/>", orig[i + 2], orig [i + 3]); i += 4; break;
                       case 0x80: fprintf(dump, "\n<item num=\"%.2X%.2X\"/>", orig[i + 2], orig [i + 3]); i += 4; break;
                       case 0x00: fprintf(dump, "\n</text>"); i += 2; break;
                       default: fprintf(dump, "%s", tbl[orig[i]]); ++i; op_usati[orig[i]] = 1;
                    } break;
         case 0x18: fprintf(dump, "\n<portrait num=\"%.2X%.2X\"/>", orig[i + 1], orig [i + 2]); i += 3; break;
         case 0x1C: fprintf(dump, "\n<op1C value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
         case 0x1D: if(orig[i + 1] == 0xFF){
                       if(orig[i + 2] == 0x0F) fprintf(dump, "\n<pause/>");
                       else fprintf(dump, "\n<op1D value=\"%.2X%.2X\"/>", orig[i + 1], orig [i + 2]);
					   i += 3;
					}
					else {
					   fprintf(dump, "\n<op1D value=\"%.2X%.2X%.2X\"/>", orig[i + 1], orig [i + 2], orig[i + 3]);
					   i += 4;
					}
                    break;
         case 0x1E: fprintf(dump, "\n<op0F value=\"%.2X\"/>", orig[i + 1]); i += 2; break;
//         case 0x22: fprintf(dump, "\n<op22 num=\"%.2X\"/>\n", orig[i + 1]); i += 2; break;
         default: fprintf(dump, "%s", tbl[orig[i]]); op_usati[orig[i]] = 1; ++i;                  
      }
   }
   fprintf(dump, "\n</stanza>");
   return 0;
}

int GRA2_analisiTesto(unsigned char *orig, int i, int dim, unsigned short *ptr, unsigned char *type, int *curPtr) {

   while(i < dim) {
      switch(orig[i]) {
         case 0x03: if((orig[i + 1] == 0x10) || (orig[i + 1] == 0x20)) {
                        memcpy(ptr + *curPtr, orig + i + 2, 2); // copia l'offset del puntatore
                        memcpy(type + *curPtr, orig + i + 1, 1); // copia il tipo del puntatore
                        ++*curPtr;
                     }
                     i += 4; break;
         case 0x04: i += 2; break;
         case 0x05: i += 3; break;
         case 0x06: i += 4; break;
         case 0x07: i += 6; break;
         case 0x08: i += 4; break;
         case 0x09: i += 5; break;
/* ? */  case 0x0A: i += 7; break;
         case 0x0B: i += 3; break;
/* ? */  case 0x0C: i += 2; break;
/* ? */  case 0x0D: i += 2; break;
         case 0x0E: i += 4; break;
         case 0x0F: i += 2; break;
/* ? */  case 0x10: i += 8; break;
         case 0x11: i += 4; break;
         case 0x14: i += 6; break;
         case 0x15: i += 5; break;
/* ? */  case 0x16: i += 3; break;
         case 0x17: switch(orig[i + 1]) {
                       case 0x01: i += 2; break;
                       case 0x20: i += 4; break;
                       case 0x40: i += 4; break;
                       case 0x80: i += 4; break;
                       case 0x00: i += 2; break;
                       default: ++i;
                    } break;
         case 0x18: i += 3; break;
         case 0x1C: i += 2; break;
         case 0x1D: if(orig[i + 1] == 0xFF) {
					   i += 3;
					}
					else {
					   i += 4;
					}
                    break;
         case 0x1E: i += 2; break;
//         case 0x22: i += 2; break;
         default: if((orig[i] < 0x20) && (orig[i] != 0x00) && (orig[i] != 0x01) && (orig[i] != 0x02) && (orig[i] != 0x1A) && (orig[i] != 0x1B) && (orig[i] != 0x1F)) printf("Opcode sconoscito: %.2X\n", orig[i]);
		 ++i;
      }
   }
   return 0;
}

int GRA2_inserisci(FILE *orig, char *dest) {
   #define MAX_LINEA 100000
   unsigned char *origine;
   unsigned char *destinazione;
   unsigned char *stanze;
   unsigned char valori[20];
   int filesize;  // grandezza dei file da dumpare
   int numStanze;
   int dimHeader;
   int offset = 0;
   int posOrig;
   int tmp = 0xFFFFFFFF;
   int i;


   unsigned long txt_pos=0;
   unsigned long txt_len=0;
   unsigned long dst_len=0;
   unsigned char* tmp_buff;
   unsigned long temp=0;
   FILE* dst_file=NULL;

   if(fseek(orig, 0, SEEK_END)) return 2;  // fine del file
   if((filesize = ftell(orig)) == -1) return 2;  // dimensione del file
   if(fseek(orig, 0, SEEK_SET)) return 2;  // ritorna all'inizio
   if(!(origine = calloc(filesize+5050, 1))) return -1;  // alloca la memoria necessaria per il file
   if(!(destinazione = calloc(filesize+5050, 1))) return -1;  // alloca la memoria necessaria per il file
   filesize = fread(origine, 1, filesize+5050, orig);  // legge il con
   if((posOrig = GRA2_strCompare("<grandiaDump version=\"0.1b9\" numStanze=\"\">", origine, valori)) == -1) return 3;

   numStanze = valori[1] + (valori[0] << 8);
   dimHeader = (numStanze * 4) + 8;
   stanze = destinazione + dimHeader;
   memcpy(destinazione, &dimHeader, 4);
   memcpy(destinazione + (dimHeader - 4), &tmp, 4);
   
   for(i = 0; i < numStanze; ++i) {
      if(offset & 7) offset = (offset | 7) + 1;
      tmp = offset >> 3;
      memcpy(destinazione + 6 + (i * 4), &tmp, 2);
      GRA2_inserisciStanza(origine, &posOrig, stanze, &offset, destinazione + 4 + (i * 4));
   }
   GRA2_aggiornaPtr(stanze);

   //inserisci il file al punto giusto
   
   if ((dst_file = fopen(dest, "rb"))==NULL) return 2;
   
   if(fseek(dst_file, 0, SEEK_END)) return 2;  // fine del file
   if((dst_len = ftell(dst_file)) == -1) return 2;  // dimensione del file

   
   if(fseek(dst_file, 0x78, SEEK_SET)) return 2;
   fread(&txt_len, 4, 1, dst_file);	//vecchia lunghezza testo

   if(fseek(dst_file, 0x7C, SEEK_SET)) return 2;
   fread(&txt_pos, 4, 1, dst_file); //posizione testo

   if(fseek(dst_file, 0, SEEK_SET)) return 2;
   
   //Alloca un altro buffer temporaneo per l'intero file
   tmp_buff = malloc((dst_len + offset+ dimHeader) - txt_len);

   fread(tmp_buff, txt_pos, 1, dst_file);
   memcpy(tmp_buff+txt_pos, destinazione, offset+dimHeader);
   fseek(dst_file, txt_pos+txt_len, SEEK_SET);
   fread(tmp_buff+txt_pos+offset+dimHeader, dst_len-(txt_pos+txt_len),1,dst_file);
   fclose(dst_file);


	//Modifica gli altri puntatori
   for(i=0; i<10; i++){
		memcpy(&temp, tmp_buff+0x84+8*i, 4);
		if (temp == 0) continue;	//se 0 non fare niente
		else {		//altrimenti aggiorna la poszione
			temp = (temp + offset+dimHeader) - txt_len;
			memcpy(tmp_buff+0x84+8*i,&temp, 4);
		}
   }

   memcpy(&temp, tmp_buff+0xE8, 4);
   temp = (temp + offset+dimHeader) - txt_len;
   memcpy(tmp_buff+0xE8,&temp, 4);
	
	//Modifica la lunghezza
   temp=offset+dimHeader;
   memcpy(tmp_buff+0x78, &temp, 4);

   if ((dst_file = fopen(dest, "wb"))==NULL) return 2;
   fwrite(tmp_buff, dst_len-txt_len+offset+dimHeader, 1, dst_file);
   fclose(dst_file);
   return 0;
}

int numPtr = 0;
int numRef = 0;
unsigned short ptr[5000]; // posizione in cui scrivere il puntatore
unsigned short ref[5000];
   
int GRA2_inserisciStanza(unsigned char *origine, int *posOrig, unsigned char *destinazione, int *offset, unsigned char *label) {
   unsigned char valori[20];
   int i;
   int n;
   
   if((n = GRA2_strCompare("\n<stanza label=\"\">", origine + *posOrig, label)) == -1) {*posOrig += n; printf("g"); exit(1);return 0;}
   *posOrig += n;

   while(1) {
      if((n = GRA2_strCompare("\n</stanza>", origine + *posOrig, NULL)) != -1) {
         *posOrig += n;
         //padding a 8 byte, spazio sprecato ma almeno non devo pensarci
         if(*offset % 8) *offset += 8 - (*offset % 8);
         return 0;
      }
      else if((n = GRA2_strCompare("\n<ptr type=\"\" num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x03;
         destinazione[(*offset)++] = valori[0];
         ptr[(valori[1] << 8) + valori[2]] = *offset;
         ++numPtr;
         *offset += 2;
      }
      else if((n = GRA2_strCompare("\n<ref type=\"\" num=\"\"/>", origine + *posOrig, valori)) != -1) {
         ref[(valori[1] << 8) + valori[2]] = *offset;
         ++numRef;
      }
      else if((n = GRA2_strCompare("\n<op03 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x03;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op04 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x04;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op05 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x05;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op06 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x06;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op07 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x07;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
      }
      else if((n = GRA2_strCompare("\n<op08 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x08;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];  
      }
      else if((n = GRA2_strCompare("\n<op09 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x09;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
      }
      else if((n = GRA2_strCompare("\n<op0A value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0A;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
         destinazione[(*offset)++] = valori[5];
      }
      else if((n = GRA2_strCompare("\n<op0B value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0B;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op0C value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0C;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op0D value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0D;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op0E value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0E;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op0F value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x0F;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<op10 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x10;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
         destinazione[(*offset)++] = valori[5];
         destinazione[(*offset)++] = valori[6];
      }
      else if((n = GRA2_strCompare("\n<op11 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x11;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];  
      }
      else if((n = GRA2_strCompare("\n<op14 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x14;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
         destinazione[(*offset)++] = valori[4];
      }
      else if((n = GRA2_strCompare("\n<op15 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x15;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
         destinazione[(*offset)++] = valori[3];
      }
      else if((n = GRA2_strCompare("\n<op16 value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x16;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<text>", origine + *posOrig, NULL)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x01;
      }
      else if((n = GRA2_strCompare("\n<unk value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x20;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<selection value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x40;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<item num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x80;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n</text>", origine + *posOrig, NULL)) != -1) {
         destinazione[(*offset)++] = 0x17;
         destinazione[(*offset)++] = 0x00;
      }
      else if((n = GRA2_strCompare("\n<portrait num=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x18;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op1C value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1C;
         destinazione[(*offset)++] = valori[0];
      }
      else if((n = GRA2_strCompare("\n<pause/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1D;
         destinazione[(*offset)++] = 0xFF;
         destinazione[(*offset)++] = 0x0F;
      }
      else if((n = GRA2_strCompare("\n<op1D value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1D;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
      }
      else if((n = GRA2_strCompare("\n<op1D value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1D;
         destinazione[(*offset)++] = valori[0];
         destinazione[(*offset)++] = valori[1];
         destinazione[(*offset)++] = valori[2];
      }
      else if((n = GRA2_strCompare("\n<op1E value=\"\"/>", origine + *posOrig, valori)) != -1) {
         destinazione[(*offset)++] = 0x1E;
         destinazione[(*offset)++] = valori[0];
      }
      else {
         for(i = 0; i < 256; ++i) {
            if((n = GRA2_strCompare(tbl[i], origine + *posOrig, NULL)) != -1) {
               destinazione[(*offset)++] = i;
               break;
            }
         }
         if(i == 256) {
            printf("Carattere non valido, impossibile inserire: %c\n", origine[*posOrig]);
            n = 1;
         }
      }
   *posOrig += n;
   }
   return 0;
}
int GRA2_aggiornaPtr(unsigned char *destinazione) {
    int i;
    
    if(numRef != numPtr) printf("Riferimenti e puntatori in numero diverso O___O\n");
    
    for(i = 0; i < numPtr; ++i) {
       memcpy(destinazione + ptr[i], ref + i, 2);
    }
}

int GRA2_strCompare(char *expr, char *string, unsigned char *value) {
   int i = 0;
   int j = 0;
   int v = 0;
   int tmp;
   char byte[3];
   byte[2] = '\0';
   
   while(expr[i] != '\0') {
      if(expr[i] == '') {
         byte[0] = string[j];
         byte[1] = string[++j];
         sscanf(byte, "%x", &tmp);
         value[v++] = tmp;
      }
      else {
         if(expr[i] != string[j]) return -1;
      }
      ++i; ++j;
   }
   return j;
}
