/*
	FurbyKill 3D
	============
	License: GPL
	Author: Andre Schnabel
	E-Mail: thefrogs@web.de
	Homepage: http://www.semler-service.de/andre/
*/

// Splash.cpp

#include "Framework.h"
#include "Splash.h"

//
// Init
//
void Splash::Init()
{
	if(framework->GetScrW() >= 640)
		splashImg = framework->LoadImage("images/splash.bmp");
	else
		splashImg = framework->LoadImage("images/lowQuality/splash.bmp");
	
	splashSnd = framework->LoadSound("sounds/intro_sound.wav");
	framework->PlaySound(splashSnd);
	startY = -splashImg->h/2;
	alpha = SDL_ALPHA_TRANSPARENT;
	black = Colors::black.ToUint32();
	aboutSurf = framework->DrawTextToSurface("2006 by Andre Schnabel", Colors::white, false);
}

//
// Quit
//
void Splash::Quit()
{
	if(!framework->GetNoSound())
	{
		Mix_HaltChannel(-1);
		Mix_FreeChunk(splashSnd);
	}
	
	SDL_FreeSurface(aboutSurf);
	SDL_FreeSurface(splashImg);
}

//
// Input
//
void Splash::Input()
{
	if(framework->KeyPressed(SDLK_ESCAPE) || framework->KeyPressed(SDLK_RETURN))
		SetDone(true);
}

//
// Update
//
void Splash::Update()
{
	if(startY < 0)
	{
		alpha ++;
		startY += 2;
		
		if(startY >= 0)
		{
			alpha = SDL_ALPHA_OPAQUE;
			startY = 0;
		}
		
		SDL_SetAlpha(splashImg, SDL_SRCALPHA, alpha);
	}
}

//
// Draw
//
void Splash::Draw()
{
	framework->FillRect(NULL, black);
	framework->Draw(splashImg, 0, startY);
	framework->Draw(aboutSurf, framework->GetScrW() - aboutSurf->w - 2, framework->GetScrH() - aboutSurf->h);
}
