/*
	FurbyKill 3D
	============
	License: GPL
	Author: Andre Schnabel
	E-Mail: thefrogs@web.de
	Homepage: http://www.semler-service.de/andre/
*/

// Player.cpp

#include "Player.h"

//
// Player
// Constructor
//
Player::Player()
{
	health = 100;
	ammo = 128;
	hasKey = false;
}

//
// GetHealth
//
int Player::GetHealth()
{
	return health;
}

//
// SetHealth
//
void Player::SetHealth(int health)
{
	this->health = health;
}

//
// GetAmmo
//
int Player::GetAmmo()
{
	return ammo;
}

//
// SetAmmo
//
void Player::SetAmmo(int ammo)
{
	this->ammo = ammo;
}

//
// DecrementAmmo
//
void Player::DecrementAmmo(int value)
{
	if(ammo - value >= 0)
		ammo -= value;
}

//
// IncrementAmmo
//
void Player::IncrementAmmo(int value)
{
	ammo += value;
}

//
// IncrementHealth
//
void Player::IncrementHealth(int value)
{
	if(health + value <= 200)
		health += value;
}

//
// DecrementHealth
//
void Player::DecrementHealth(int value)
{
	if(health - value >= 0)
		health -= value;
}

//
// HasKey
//
bool Player::HasKey()
{
	return hasKey;
}

//
// SetHasKey
//
void Player::SetHasKey(bool hasKey)
{
	this->hasKey = hasKey;
}
