//
// License: GPL
// Date: 18.3.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// Game.h

#ifndef GAME_H
#define GAME_H

#include "Framework/State.h"

class Game : public State
{
public:
	Game(int argc, char **argv);
	~Game();

	virtual void Init();
	virtual void Quit();

	virtual void Input();
	virtual void Update();
	virtual void Draw();

private:
	void DrawTile(int x, int y, SDL_Color color);

	enum Dir
	{
		DIR_LEFT,
		DIR_RIGHT,
		DIR_UP,
		DIR_DOWN,
		NUM_DIRECTIONS
	};

	enum TileType
	{
		TILE_EMPTY,
		TILE_P1,
		TILE_P2,
		TILE_P3,
		TILE_P4,
	};

	struct Player
	{
		struct Pos { unsigned int x, y; };
		Dir dir;
		Pos head;
		SDL_Color color;
		bool dead;
		int score;

		int keyNums[NUM_DIRECTIONS];

		Player()
		{
			dir = DIR_LEFT;
			head.x = head.y = 0;
			color = Color::red;
			dead = false;
			score = 0;
		}
	};

	int numPlayers;

	static const int SCORE_ADD = 100;

	static const Uint32 UPDATE_TIME = 125;
	static const Uint32 GAME_OVER_TIME = 2000;

	static const int MAP_W = 62;
	static const int MAP_H = 46;

	static const int TILE_W = 10;
	static const int TILE_H = 10;

	static const Dir p1StartDir = DIR_LEFT;
	static const Dir p2StartDir = DIR_RIGHT;

	TileType map[MAP_H][MAP_W];
	Player *players;

	bool gameOver;
	Uint32 gOvStart;

	Uint32 lUpdate;
};

#endif

