//
// License: GPL
// Date: 4.3.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// State.h

#ifndef STATE_H
#define STATE_H

#include <SDL/SDL.h>
#include <map>
using namespace std;

#include "ResourceManager.h"

class State
{
public:
	virtual void Init() = 0;
	virtual void Quit() = 0;

	virtual void Input() = 0;
	virtual void Update() = 0;
	virtual void Draw() = 0;

	bool GetDone() { return done; }
	void SetDone(bool done) { this->done = done; }
	
	void Kill() { delete this; }

protected:
	void InitResMngr(string filename)
	{
		resources = new ResourceManager(filename);
	}

	void ReleaseResMngr()
	{
		delete resources;
	}

	inline SDL_Surface	*IMG(string name)	{ return resources->GetImage(name); }
	inline Mix_Chunk	*SND(string name)	{ return resources->GetSound(name); }
	inline Mix_Music	*MUS(string name)	{ return resources->GetMusic(name); }
	inline TTF_Font		*FONT(string name)	{ return resources->GetFont(name);	}

	bool done;
	ResourceManager *resources;
};

#endif
