//
// License: GPL
// Date: 25.2.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// Sprite.h

#ifndef SPRITE_H
#define SPRITE_H

#include "Framework.h"

class Sprite
{
public:
	Sprite(SDL_Surface *img, int x = 0, int y = 0);
	Sprite(string filename, int x = 0, int y = 0);
	virtual ~Sprite();

	void SetParalyzed(bool value);

	void SetPos(int x = 0, int y = 0);
	void Move(int horizontal = 0, int vertical = 0, bool dontGoOut = false);
	bool CollWithOther(Sprite *other);

	void Draw();

	SDL_Rect *GetRect();

protected:
	bool ownImg;
	SDL_Surface *image;
	SDL_Rect rect;

	bool paralyzed;
};

#endif
