//
// License: GPL
// Date: 25.02.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// ResourceManager.h

#ifndef RESOURCE_MANAGER_H
#define RESOURCE_MANAGER_H

#include "Framework.h"
#include <fstream>

class ResourceManager
{
public:
	ResourceManager(string filename);
	~ResourceManager();

	SDL_Surface *GetImage(string name);
	Mix_Chunk *GetSound(string name);
	Mix_Music *GetMusic(string name);
	TTF_Font *GetFont(string name);

private:
	enum ResType { RES_IMAGE, RES_SOUND, RES_MUSIC, RES_FONT, RES_UNKNOWN };
	ResType IsResType(string filename) const;
	string StripToRawName(string filename) const;

	void DrawLoadingBar(int percent) const;

	map<string, SDL_Surface *> images;
	map<string, Mix_Chunk *> sounds;
	map<string, Mix_Music *> songs;
	map<string, TTF_Font *> fonts;
};

#endif
