//
// License: GPL
// Date: 18.3.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// main.cpp

#ifdef DREAMCAST
	#include <kos.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
	
	extern uint8 romdisk[];
	KOS_INIT_ROMDISK(romdisk);
#endif

#include "Framework/Framework.h"
#include "Framework/Splash.h"
#include "Game.h"

//
// main
//
int main(int argc, char **argv)
{
	#ifdef DREAMCAST
		fs_chdir("/rd/");
		printf("Starting...\n");
	#endif
	
	FrameworkSettings settings;

	settings.caption = "Tron";
	settings.version = "1.3";
	settings.fullscreen = true;

	new Framework(&settings);

	framework->AddState(new Splash);
	framework->AddState(new Game(argc, argv));

	framework->Run();

	return 0;
}
