//
// License: GPL
// Date: 25.2.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// Sprite.cpp

#include "Sprite.h"

//
// Sprite
// Constructor
//
Sprite::Sprite(SDL_Surface *img, int x, int y) : image(img), ownImg(false), paralyzed(false)
{
	rect.x = x;
	rect.y = y;
	rect.w = img->w;
	rect.h = img->h;
}

//
// Sprite
// Constructor
//
Sprite::Sprite(string filename, int x, int y) : ownImg(true), paralyzed(false)
{
	image = framework->LoadImage(filename, true);

	rect.x = x;
	rect.y = y;
	rect.w = image->w;
	rect.h = image->h;
}

//
// ~Sprite
// Destructor
//
Sprite::~Sprite()
{
	if(ownImg)
		framework->FreeImage(image);
}

//
// SetParalyzed
//
void Sprite::SetParalyzed(bool value)
{
	paralyzed = value;
}

//
// SetPos
//
void Sprite::SetPos(int x, int y)
{
	rect.x = x;
	rect.y = y;
}

//
// Move
//
void Sprite::Move(int horizontal, int vertical, bool dontGoOut)
{
	if(paralyzed)
		return;

	rect.x += horizontal;
	rect.y += vertical;

	if(dontGoOut)
	{
		if(rect.x < 0)
			rect.x = 0;
		if(rect.x + rect.w > framework->GetScreenW())
			rect.x = framework->GetScreenW() - rect.w;
		if(rect.y < 0)
			rect.y = 0;
		if(rect.y + rect.h > framework->GetScreenH())
			rect.y = framework->GetScreenH() - rect.h;
	}
}

//
// CollWithOther
//
bool Sprite::CollWithOther(Sprite *sprite)
{
	return framework->Coll(&rect, sprite->GetRect());
}

//
// Draw
//
void Sprite::Draw()
{
	framework->Draw(image, &rect);
}

//
// GetRect
//
SDL_Rect *Sprite::GetRect()
{
	return &rect;
}
