//
// License: GPL
// Date: 25.02.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// Splash.cpp

#include "Splash.h"

//
// Splash
// Constructor
//
Splash::Splash(string resMngrFilename, string bgName, string fontName)
{
	this->resMngrFilename = resMngrFilename;
	this->bgName = bgName;
	this->fontName = fontName;
}

//
// Init
//
void Splash::Init()
{
	InitResMngr(resMngrFilename);
	versStr = "Version: " + framework->GetVersion();
}

//
// Quit
//
void Splash::Quit()
{
	ReleaseResMngr();
}

//
// Input
//
void Splash::Input()
{
	if(framework->KeyIsPressed(SDLK_ESCAPE) || framework->KeyIsPressed(SDLK_RETURN))
		done = true;
}

//
// Update
//
void Splash::Update()
{
}

//
// Draw
//
void Splash::Draw()
{
	framework->Draw(IMG(bgName));
	framework->DrawShadowedText(versStr, 20, framework->GetScreenH() - 30, FONT(fontName), Color::white, true);
}

