//
// License: GPL
// Date: 27.2.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// AnimatedSprite.h

#ifndef ANIMATED_SPRITE_H
#define ANIMATED_SPRITE_H

#include "Sprite.h"

class AnimatedSprite : public Sprite
{
public:
	AnimatedSprite(SDL_Surface *img, int frameW, int frameH);
	AnimatedSprite(string filename, int frameW, int frameH);

	void SetChgTime(Uint32 chgTime);

	int GetCurFrame() const;
	void SetCurFrame(int curFrame);
	void IncCurFrame();
	void DecCurFrame();

	void Draw();

private:
	SDL_Rect srcRect;
	int curFrame, numFrames;
	Uint32 lFrameChg, chgTime;
};

#endif
