//
// License: GPL
// Date: 27.2.2006
// Author: Andr Schnabel (thefrogs@web.de)
// http://www.masterspace.biz/andreschnabel/
//

// AnimatedSprite.cpp

#include "AnimatedSprite.h"

//
// AnimatedSprite
// Constructor
//
AnimatedSprite::AnimatedSprite(SDL_Surface *img, int frameW, int frameH) : Sprite(img), curFrame(0)
{
	srcRect.w = rect.w = frameW;
	srcRect.h = rect.h = frameH;
	srcRect.y = 0;

	numFrames = image->w / frameW;
	curFrame = 0;

	lFrameChg = framework->GetTicks();
	chgTime = 1000 / framework->GetMaxFps();
}

//
// AnimatedSprite
// Constructor
//
AnimatedSprite::AnimatedSprite(string filename, int frameW, int frameH) : Sprite(filename), curFrame(0)
{
	srcRect.w = rect.w = frameW;
	srcRect.h = rect.h = frameH;
	srcRect.y = 0;

	numFrames = image->w / frameW;
	curFrame = 0;

	lFrameChg = framework->GetTicks();
	chgTime = 1000 / framework->GetMaxFps();
}

//
// SetChgTime
//
void AnimatedSprite::SetChgTime(Uint32 chgTime)
{
	this->chgTime = chgTime;
}

//
// GetCurFrame
//
int AnimatedSprite::GetCurFrame() const
{
	return curFrame;
}

//
// SetCurFrame
//
void AnimatedSprite::SetCurFrame(int curFrame)
{
	this->curFrame = curFrame;
}

//
// IncCurFrame
//
void AnimatedSprite::IncCurFrame()
{
	if(framework->GetTicks() - lFrameChg < chgTime)
		return;

	if(curFrame + 1 < numFrames)
		curFrame++;
	else
		curFrame = 0;

	lFrameChg = framework->GetTicks();
}

//
// DecCurFrame
//
void AnimatedSprite::DecCurFrame()
{
	if(framework->GetTicks() - lFrameChg < chgTime)
		return;

	if(curFrame > 0)
		curFrame--;
	else
		curFrame = numFrames - 1;

	lFrameChg = framework->GetTicks();
}

//
// Draw
//
void AnimatedSprite::Draw()
{
	srcRect.x = curFrame * srcRect.w;
	framework->Draw(image, &srcRect, &rect);
}
