//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// utils.h

#ifndef UTILS_H
#define UTILS_H

#include "globals.h"
#include "font.h"

// Possible states of a key
typedef enum keystate_s
{
	KSTATE_PRESSED,
	KSTATE_UNCHANGED,
	KSTATE_RELEASED
} keystate_t;

extern font_t font, fontBlack;

void Error(const char *message);

void SysInit(void);
void SysQuit(void);

void SysInput(void);
void SysFlip(void);

void SysRestartVid(void);

SDL_Surface *LoadImage(const char *filename, boolean useAlpha);

#ifndef NO_SOUND
Mix_Chunk *LoadWAV(const char *filename);
Mix_Music *LoadMUS(const char *filename);
#endif

boolean IsPressed(keystate_t kState);
void UpdateKey(keystate_t *kState, int keyId);

#endif
