//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// snake.h

#ifndef SNAKE_H
#define SNAKE_H

#include "globals.h"
#include "utils.h"

// The length of the snake at the beginning
#define SNAKE_LENGTH_START	6

// Number of units the snakes moves in a second
#define SNAKE_SPEED_START	4

// The snake consists of a linked list of blocks
typedef struct block_s
{
	int x, y;
	struct block_s *prev;
} block_t;

typedef struct snake_s
{
	block_t *blocks;
	float speed;
	Uint32 lMove;
	dir_t dir;
	boolean grow;
	int score;
	int nr;
	keystate_t kLeft, kRight;
	keystate_t kUp, kDown;
	boolean loser;
} snake_t;

extern snake_t players[MAX_PLAYERS];
extern int playersLeft;

boolean AlreadyBlockOnPos(int x, int y, snake_t *snake);
void AddBlock(int x, int y, snake_t *snake);
void RemoveLastBlock(snake_t *snake);
void DeleteBlocks(snake_t *snake);
void InitSnake(snake_t *snake, int length, int nr);
void DrawBlock(int x, int y, boolean head, snake_t *snake);
void UpdateSnake(snake_t *snake);
void DrawSnake(snake_t *snake);

#endif
