//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// messages.c

#include "messages.h"

msg_t msgs[MAX_MSGS];

void InitMessages(void)
{
	int i;
	for(i=0; i<MAX_MSGS; i++)
		msgs[i].active = false;
}

void AddMessage(const char *msg)
{
	int i;
	for(i=0; i<MAX_MSGS; i++)
	{
		if(!msgs[i].active)
		{
			strcpy(msgs[i].text, msg);
			msgs[i].timeToLast = 100;
			msgs[i].active = true;
			break;
		}
	}
}

void UpdateMessages(void)
{
	int i;
	for(i=0; i<MAX_MSGS; i++)
	{
		if(msgs[i].active)
		{
			msgs[i].timeToLast--;
			
			if(msgs[i].timeToLast <= 0)
				msgs[i].active = false;
		}
	}
}

void DrawMessages(int x, int y)
{
	int i;
	for(i=0; i<MAX_MSGS; i++)
	{
		if(msgs[i].active)
			DrawText(msgs[i].text, x, y + i * font.oneChar.h, &font);
	}
}
