//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// globals.h

#ifndef GLOBALS_H
#define GLOBALS_H

//#define NO_SOUND
#define SNAKE_GETTING_FASTER

#include <SDL/SDL.h>

#ifndef NO_SOUND
#include <SDL/SDL_mixer.h>
#endif

#include <stdio.h>
#include <string.h>

// Own boolean type
typedef enum { false, true } boolean;

#define MAX_PLAYERS	4

// Screen dimensions
#define SCR_W			640
#define SCR_H			480

//#define SCR_BPP			32
//#define SCR_FLAGS		SDL_HWSURFACE | SDL_DOUBLEBUF

#define SCR_BPP			16
#define SCR_FLAGS		SDL_SWSURFACE

#define SCR_FULLSCREEN	1

// Window caption
#define CAPTION		"Snake"

// Dimensions of a block (unit in space)
#define BLOCK_W		16
#define BLOCK_H		16

// Different directions
typedef enum
{
	// Horizontal
	DIR_LEFT = 0,
	DIR_RIGHT = 2,
	// Vertical
	DIR_UP = 1,
	DIR_DOWN = 3,
} dir_t;

typedef struct pos_s
{
	int x, y;
} pos_t;

typedef struct dimensions_s
{
	int w, h;
} dimensions_t;

extern SDL_Surface *screen;
extern Uint8 *keys;

extern SDL_Surface *appleImg, *blockImgs[MAX_PLAYERS], *headImgs[MAX_PLAYERS][4], *tileImg;
extern float snakeSpeed;

#ifndef NO_SOUND
extern Mix_Chunk *eatSnd, *gameOverSnd, *movSnd;
#endif

extern boolean done, gameOver, altCtrl;
extern boolean editor, fullscreen;

extern int numPlayers;

#endif
