//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// font.c

#include "font.h"
#include "utils.h"

font_t InitFont(const char *filename, pos_t offset, dimensions_t oneCharDim)
{
	font_t newFont;
	
	memcpy(&newFont.offset, &offset, sizeof(pos_t));
	memcpy(&newFont.oneChar, &oneCharDim, sizeof(dimensions_t));
	
	newFont.fontmap = LoadImage(filename, true);
	
	return newFont;
}

void FreeFont(font_t *font)
{
	SDL_FreeSurface(font->fontmap);
}

void DrawText(const char *text, int x, int y, font_t *font)
{
	int i;
	char c;
	static SDL_Rect srcRect, destRect;
	int factorX, factorY;
	
	destRect.w = srcRect.w = font->oneChar.w;
	destRect.h = srcRect.h = font->oneChar.h;
	
	for(i=0; i<strlen(text); i++)
	{
		c = text[i];
		
		if(c >= '!' && c <= '@')
		{
			factorX = c - '!';
			factorY = 0;
		}
		else if(c >= 'A' && c <= '`')
		{
			factorX = c - 'A';
			factorY = 1;
		}
		else if(c >= 'a' && c <= '~')
		{
			factorX = c - 'a';
			factorY = 2;
		}
		else
			continue;
		
		srcRect.y = factorY * font->oneChar.h + font->offset.y;
		srcRect.x = factorX * font->oneChar.w + font->offset.x;
		
		destRect.x = i * font->oneChar.w + x;
		destRect.y = y;
		
		SDL_BlitSurface(font->fontmap, &srcRect, screen, &destRect);
	}
}
