//==============================================================================
//
// Snake
// -----
// http://www.masterspace.biz/andreschnabel/
// 2006 by Andr Schnabel (thefrogs@web.de)
//
//==============================================================================

// menu.c

#include "menu.h"
#include "utils.h"

void DrawOptions(int x, int y);

void ShowMenu(void)
{
	boolean showPlayerSel = false, showSettings = false;
	char plrSel[2];
	int plrSelNum = 2;
	SDL_Surface *logoImg, *ballImg;
	SDL_Rect rect, ballRect;
	boolean menuDone = false;
	Uint32 bgColor = SDL_MapRGB(screen->format, 0, 0, 0);
	int selection = 0;
	boolean upRel = false, downRel = false;
	boolean useFullscreen = false;
	
	logoImg = LoadImage("menu.bmp", true);
	ballImg = LoadImage("ball.bmp", true);
	
	rect.w = logoImg->w;
	rect.h = logoImg->h;
	
	rect.x = (SCR_W - logoImg->w) / 2;
	rect.y = 100;
	
	ballRect.w = ballImg->w;
	ballRect.h = ballImg->h;
	
	while(!menuDone && !done)
	{
		SysInput();
		
		if(keys[SDLK_UP])
		{
			if(upRel)
			{
				if(!showPlayerSel && !showSettings)
				{
					selection--;
					
					if(selection < 0)
						selection = NUM_OPTIONS - 1;					
				}
				else if(showPlayerSel)
				{
					plrSelNum++;
					
					if(plrSelNum > 4)
						plrSelNum = 1;
					
					sprintf(plrSel, "%d", plrSelNum);
				}
				else
					useFullscreen = !useFullscreen;
				
				upRel = false;
			}
		}
		else
			upRel = true;
		
		if(keys[SDLK_DOWN])
		{
			if(downRel)
			{
				if(!showPlayerSel && !showSettings)
				{
					selection++;
				
					if(selection >= NUM_OPTIONS)	
						selection = 0;
				}
				else if(showPlayerSel)
				{
					plrSelNum--;
					
					if(plrSelNum < 1)
						plrSelNum = 4;
					
					sprintf(plrSel, "%d", plrSelNum);
				}
				else
					useFullscreen = !useFullscreen;
				
				downRel = false;
			}
		}
		else
			downRel = true;
		
		if(keys[SDLK_RETURN])
		{
			keys[SDLK_RETURN] = false;
			
			if(!showPlayerSel && !showSettings)
			{
				switch(selection)
				{
					case OPT_SPLAYER:
						menuDone = true;
						break;
					case OPT_MPLAYER:
						showPlayerSel = true;
						sprintf(plrSel, "%d", plrSelNum);
						break;
					/*
					case OPT_EDITOR:
						editor = true;
						menuDone = true;
						break;
					case OPT_SETTINGS:
						showSettings = true;
						break;
					*/
					case OPT_EXIT:
						done = true;
						break;
				}
			}
			else if(showPlayerSel)
			{
				numPlayers = plrSelNum;
				menuDone = true;
			}
			else
			{
				fullscreen = useFullscreen;
				menuDone = true;
				SysRestartVid();
			}
		}
		
		SDL_FillRect(screen, NULL, bgColor);
		SDL_BlitSurface(logoImg, NULL, screen, &rect);
		
		DrawOptions(280, rect.y + rect.h + 10);
		
		ballRect.x = 280 - 20;
		ballRect.y = rect.y + rect.h + 10 + selection * font.oneChar.h;
		SDL_BlitSurface(ballImg, NULL, screen, &ballRect);
		
		if(showPlayerSel)
		{
			DrawText("How many players?", 10, SCR_H - 30, &font);
			DrawText(plrSel, 150, SCR_H - 30, &font);
		}
		else if(showSettings)
		{
			DrawText("Fullscreen mode?", 10, SCR_H - 30, &font);
			
			if(useFullscreen)
				DrawText("Yes", 150, SCR_H - 30, &font);
			else
				DrawText("No", 150, SCR_H - 30, &font);
		}
		
		SysFlip();
	}
	
	SDL_FreeSurface(ballImg);
	SDL_FreeSurface(logoImg);
}

void DrawOptions(int x, int y)
{
	int i;
	for(i=0; i<NUM_OPTIONS; i++)
		DrawText(options[i], x, y + i * font.oneChar.h, &font);
}
