// game.h

/*
	Sokoban
	2006 by André Schnabel (thefrogs@web.de)
	http://www.semler-service.de/andre/
	License: GPL
*/

#ifndef GAME_H
#define GAME_H

#define MAP_W	16
#define MAP_H	12

#define TILE_W	40
#define TILE_H	40

#define MAP_PREFIX "maps/map"

#define SHOW_LEVEL_DONE_TIME	2000

#define MAX_HIDDEN_TARGETS		8

//Sokoban format :)
//NOTE: This engine now accepts box on target(*) and player on target(+)!!!

/*
#define TILE_EMPTY 0
#define	TILE_FLOOR 1
#define	TILE_TARGET 2
#define	TILE_WALL 3
#define	TILE_BOX 4
#define	TILE_PLAYER_START 5
#define	NUM_TILES 6
*/

#define TILE_EMPTY '0'
#define	TILE_FLOOR ' '
#define	TILE_TARGET '.'
#define	TILE_WALL '#'
#define	TILE_BOX '$'
#define	TILE_PLAYER_START '@'
#define	TILE_BOX_TARGET '*'
#define	TILE_PLAYER_TARGET '+'
#define	NUM_TILES 6

typedef struct player_s {
	int x, y;
	int steps, pushes;
	int bocesDone;
} player_t;

typedef struct target_s {
	int x, y;
	boolean active;
} target_t;

void GM_Init(void);
void GM_Quit(void);

void GM_Input(void);
void GM_Update(void);
void GM_Draw(void);

#endif
