// common.h

/*
	Sokoban
	2006 by André Schnabel (thefrogs@web.de)
	http://www.semler-service.de/andre/
	License: GPL
*/

#ifndef COMMON_H
#define COMMON_H

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STR_LENGTH	256
#define MAX_FPS			25

#define DATA_PREFIX 	"data/"
#define IMAGE_PREFIX	"images/"
#define AUDIO_PREFIX	"audio/"

#ifndef __cplusplus
typedef enum { false, true } boolean;
#else
typedef bool boolean;
#endif

typedef struct state_s {
	void (*init)(void);
	void (*quit)(void);
	
	void (*input)(void);
	void (*update)(void);
	void (*draw)(void);
} state_t;

void COM_Init(const char *caption, int scrW, int scrH, int scrBpp, boolean fullscreen);
void COM_Quit(void);

void COM_Error(const char *message);

void COM_DrawImage(SDL_Surface *image, int x, int y);
void COM_DrawText(const char *text, int x, int y);

boolean COM_KeyPressed(int keyNum, boolean wasReleased);

void COM_MainLoop(state_t *state);

SDL_Surface *COM_LoadImage(const char *filename, boolean useAlpha);
Mix_Chunk *COM_LoadSound(const char *filename);

boolean COM_FileExists(const char *filename);

extern SDL_Surface *screen;
extern boolean curStateDone;

#endif
