// main.c

/*
	Sokoban
	2006 by André Schnabel (thefrogs@web.de)
	http://www.semler-service.de/andre/
	License: GPL
*/

#include "common.h"
#include "splash.h"
#include "game.h"

#ifdef DREAMCAST
	extern uint8 romdisk[];
	#include <kos.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
	KOS_INIT_ROMDISK(romdisk);	
#endif

int main(int argc, char **argv)
{
	#ifdef DREAMCAST
        	printf("Starting...\n");
		fs_chdir("/rd");
	#endif

	state_t splash, game;
	
	COM_Init("Sokoban", 640, 480, 32, true);
	
	splash.init = SPL_Init;
	splash.quit = SPL_Quit;
	splash.input = SPL_Input;
	splash.update = SPL_Update;
	splash.draw = SPL_Draw;
	
	game.init = GM_Init;
	game.quit = GM_Quit;
	game.input = GM_Input;
	game.update = GM_Update;
	game.draw = GM_Draw;
	
	COM_MainLoop(&splash);
	COM_MainLoop(&game);
		
	COM_Quit();
	
	return 0;
}
