/*****************************************************\
	CTux_Player.h	
	Author: Andr Schnabel
	Date: 30.10.02 - 31.10.02
	License: GPL
\*****************************************************/

#ifndef __CTUX_PLAYER_H__
#define __CTUX_PLAYER_H__

#define LEFT    0
#define RIGHT   1

#define STAYING 0
#define WALKING 1
#define JUMPING 2
#define FALLING 3
#define DEAD    4

#define PLAYER_SPEED  4
#define JUMP_POWER    13
#define GRAVITY       6

#define NUM_LIVES 4

#define DEAD_TIME 8

#include "CTux_Global.h"
#include "CTux_Level.h"
#include "CTux_Sprite.h"

class Player : public Sprite
{
public:
	Player(const char *filename, SDL_Rect *newsrcrect);
	~Player(void);
	void Walk(int dir);
	void Update(void);
	void DrawP(void);
	void Jump(void);
	int GetState(void);
	void SetState(int newstate);
	bool HitOther(SDL_Rect *other);
	void DrawLives(SDL_Surface *head, int posx, int posy);
	void SetDeadCount(int ndeadcount);
private:
	int walk_count;
	int state, lives;
	int jump_speed;
	int jump_power;
	int dead_count;
	bool able_fall, able_jump, able_left, able_right;
};

#endif