/*****************************************************\
	CTux_Player.cpp	
	Author: Andr Schnabel
	Date: 30.10.02 - 31.10.02
	License: GPL
\*****************************************************/

#include "CTux_Player.h"

Player::Player(const char *filename, SDL_Rect *newsrcrect)
{
	SetImage(filename, newsrcrect);
	SDL_SetColorKey(imageset, SDL_SRCCOLORKEY | SDL_RLEACCEL, magenta);
	state = 0;
	lives = NUM_LIVES;
}

Player::~Player(void)
{
	SDL_FreeSurface(imageset);
}

void Player::Walk(int dir)
{
	if(state == 4)
		return;
	int i;
	srcrect.y = dir * srcrect.h;
	if(dir == LEFT)
	{
		for(i=0; i<PLAYER_SPEED; i++)
		{
			DetectCollisions(&able_jump, &able_fall, &able_right, &able_left, &rect);
			if(able_left)
			{
				rect.x--;
			}
		}
		
	}
	else
	{
		for(i=0; i<PLAYER_SPEED; i++)
		{
			DetectCollisions(&able_jump, &able_fall, &able_right, &able_left, &rect);
			if(able_right)
			{
				rect.x++;
			}
		}
	}
}

void Player::Update(void)
{
	int i;
	switch(state)
	{
	case 0 || 1:
		DetectCollisions(&able_jump, &able_fall, &able_right, &able_left, &rect);
		if(able_fall)
			state = 3;
		break;
	case 2:
		if(jump_power == 0)
		{
			state = 3;
			break;
		}
		for(i=0; i<jump_power; i++)
		{
			DetectCollisions(&able_jump, &able_fall, &able_right, &able_left, &rect);
			if(!able_jump)
			{
				state = 3;
				break;
			}
			else
			{
				rect.y--;
			}
		}
		jump_power--;
		break;
	case 3:
		for(i=0; i<GRAVITY; i++)
		{
			DetectCollisions(&able_jump, &able_fall, &able_right, &able_left, &rect);
			if(able_fall)
				rect.y++;
			if(!able_fall)
			{
				state = 0;
				break;
			}
		}
		break;
	case 4:
		dead_count--;
		if(dead_count <= 0)
		{
			state = 3;
			
			//DC NOTE: Put a -40 for safety at right border
			SetPos(rand() % SCREEN_W - 40, 20);
			lives--;
		}
		if(lives < 1)
		{
			//DC NOTE: Instead of exit, why don't put again 4 lifes? :)
			#ifdef DREAMCAST
				state = 3;
				SetPos(rand() % SCREEN_W - 40, 20);
				lives = 4;
			#else
				SDL_Delay(3000);
				exit(0);
			#endif
		}
		break;
	}
}

void Player::DrawP(void)
{
	switch(state)
	{
	case 0:
		Draw(0);
		break;
	case 1:
		if(walk_count < 2)
		{
			Draw(0);
			walk_count++;
		}
		else if(walk_count < 4)
		{
			Draw(1);
			walk_count++;
		}
		else
		{
			Draw(0);
			walk_count = 1;
		}
		break;
	case 2:
		Draw(2);
		break;
	case 3:
		Draw(3);
		break;
	case 4:
		Draw(4);
		break;
	}
}

void Player::Jump(void)
{
	if((state == 0) || (state == 1))
	{
		jump_power = JUMP_POWER;
		state = 2;
#ifndef NO_SOUND
		if(Mix_PlayChannel(0, jump_sound, 0) == -1)
			printf("Can't play jump sound: 'jump.wav'!");
#endif
	}
}

int Player::GetState(void)
{
	return state;
}

void Player::SetState(int newstate)
{
	state = newstate;
}

bool Player::HitOther(SDL_Rect *other)
{
	if(rect.x < other->x + other->w && rect.x + rect.w > other->x && rect.y+20 > other->y && rect.y+20 < other->y + other->h && state == 3)
	{
#ifndef NO_SOUND
		if(Mix_PlayChannel(0, kill_sound, 0) == -1)
			printf("Can't play kill sound: 'kill.wav'!");
#endif
		return true;
	}
	return false;
}

void Player::DrawLives(SDL_Surface *head, int posx, int posy)
{
	int i;
	SDL_Rect destrect;
	destrect.w = head->w;
	destrect.h = head->h;	
	destrect.y = posy;
	for(i=0; i<lives; i++)
	{
		destrect.x = i*destrect.w+posx;		
		SDL_BlitSurface(head, NULL, screen, &destrect);
	}
}

void Player::SetDeadCount(int ndeadcount)
{
	dead_count = ndeadcount;
}