/*****************************************************\
	CTux_Level.cpp	
	Author: Andr Schnabel
	Date: 30.10.02 - 31.10.02
	License: GPL
\*****************************************************/

#include "CTux_Global.h"
#include "CTux_Level.h"

SDL_Surface *tileimages[NUM_TILES];

int map[MAP_ROWS][MAP_COLS] = {
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2 },
	{ 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2 },
	{ 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2 },
	{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 },	
	{ 3, 0, 0, 0, 0, 5, 4, 4, 4, 4, 4, 6, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 4, 4, 4, 4, 6, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 5, 4, 6, 2, 2, 2, 2, 5, 4, 6, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 5, 4, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 6, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 4, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 4, 4, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 }	
};

void InitMap(void)
{
	int i;
	tileimages[0] = LoadBMP("images/tile1.bmp");
	tileimages[1] = LoadBMP("images/tile2.bmp");
	tileimages[2] = LoadBMP("images/tile3.bmp");
	tileimages[3] = LoadBMP("images/tile4.bmp");
	tileimages[4] = LoadBMP("images/tile5.bmp");
	tileimages[5] = LoadBMP("images/tile6.bmp");
	for(i=0; i<NUM_TILES; i++)
	{
		SDL_SetColorKey(tileimages[i], SDL_SRCCOLORKEY | SDL_RLEACCEL, magenta);
	}
}

void DrawMap(void)
{
	int row, col;
	SDL_Rect destrect;
	destrect.w = tileimages[0]->w;
	destrect.h = tileimages[0]->h;
	for(row=0; row<MAP_ROWS; row++)
	{
		for(col=0; col<MAP_COLS; col++)
		{
			if(map[row][col] != 0)
			{
				destrect.x = col * destrect.w;
				destrect.y = row * destrect.h;
				SDL_BlitSurface(tileimages[map[row][col]-1], NULL, screen, &destrect);
			}
		}
	}
}

void DeinitMap(void)
{
	if(tileimages[0] != NULL)
	{
		int i;
		for(i=0; i<NUM_TILES; i++)
		{
			SDL_FreeSurface(tileimages[i]);
		}
	}
}

void DetectCollisions(bool *able_jump, bool *able_fall, bool *able_right, bool *able_left, SDL_Rect *rect)
{
	*able_jump = true;
	if(map[(rect->y-1)/20][rect->x/20] != 0)
		*able_jump = false;
	if(map[(rect->y-1)/20][(rect->x+19)/20] != 0)
		*able_jump = false;

	*able_fall = true;
	if(map[(rect->y+20)/20][rect->x/20] != 0)
		*able_fall = false;
	if(map[(rect->y+20)/20][(rect->x+19)/20] != 0)
		*able_fall = false;

	*able_right = true;
	if(map[rect->y/20][(rect->x+20)/20] != 0)
		*able_right = false;
	if(map[(rect->y+19)/20][(rect->x+20)/20] != 0)
		*able_right = false;

	*able_left = true;
	if(map[rect->y/20][(rect->x-1)/20] != 0)
		*able_left = false;
	if(map[(rect->y+19)/20][(rect->x-1)/20] != 0)
		*able_left = false;
}