/*****************************************************\
	CTux_Duel.cpp	
	Author: Andr Schnabel
	Date: 30.10.02 - 31.10.02
	License: GPL
\*****************************************************/

#include "CTux_Global.h"
#include "CTux_Level.h"
#include "CTux_Player.h"
#include "CTux_Duel.h"

#ifdef DREAMCAST
	extern uint8 romdisk[];

	#include <kos.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
	KOS_INIT_ROMDISK(romdisk);
	
	#include <SDL/SDL_dreamcast.h>
#endif

SDL_Surface *screen;
bool done;

Uint32 magenta, bgcolor;

Uint8 *keys;

Player *player1, *player2;

SDL_Surface *heads[2];

#ifndef NO_SOUND
	Mix_Chunk *jump_sound, *kill_sound;
	Mix_Music *bg_music;
#endif

int main(int argc, char *argv[])
{
    #ifdef DREAMCAST
        printf("Starting...\n");
		fs_chdir("/rd");
    #endif

	StartGame();
	SDL_Event event;
	
	#ifdef DREAMCAST
 		SDL_DC_MapKey(0, SDL_DC_UP, SDLK_UP);
   		SDL_DC_MapKey(0, SDL_DC_DOWN, SDLK_DOWN);
   		SDL_DC_MapKey(0, SDL_DC_LEFT, SDLK_LEFT);
   		SDL_DC_MapKey(0, SDL_DC_RIGHT, SDLK_RIGHT);
   		SDL_DC_MapKey(0, SDL_DC_START, SDLK_RETURN);
   		SDL_DC_MapKey(0, SDL_DC_A, SDLK_UP);
   		SDL_DC_MapKey(0, SDL_DC_L, SDLK_ESCAPE);
   		
   		SDL_DC_MapKey(1, SDL_DC_UP, SDLK_w);
   		SDL_DC_MapKey(1, SDL_DC_DOWN, SDLK_s);
   		SDL_DC_MapKey(1, SDL_DC_LEFT, SDLK_a);
   		SDL_DC_MapKey(1, SDL_DC_RIGHT, SDLK_d);
   		SDL_DC_MapKey(1, SDL_DC_A, SDLK_w);
   		
   		SDL_JoystickOpen(0);
   		SDL_JoystickOpen(1);
		
        while(SDL_PollEvent(&event))
            SDL_Delay(20);
    #endif
	
	while(!done)
	{
		ProcessEvents(&event);
		ProcessInput();
		UpdateGame();
		CorrectFrameTime();
	}
	return 0;
}

SDL_Surface *LoadBMP(const char *filename)
{
	SDL_Surface *image, *temp;
	temp = SDL_LoadBMP(filename);
	image = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	return image;
}

void StartGame(void)
{
#ifndef NO_SOUND
	#define INIT_FLAGS SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK
#else
	#define INIT_FLAGS SDL_INIT_VIDEO | SDL_INIT_JOYSTICK
#endif
	if(SDL_Init(INIT_FLAGS) == -1)
	{
		printf("Can't init SDL!");
		exit(1);
	}
	atexit(ExitGame);

	screen = SDL_SetVideoMode(SCREEN_W, SCREEN_H, SCREEN_BPP, SCREEN_FLAGS);
	if(screen == NULL)
	{
		printf("Can't init screen-mode...");
		exit(1);
	}
	SDL_ShowCursor(SDL_DISABLE);
	SDL_WM_SetCaption(CAPTION, NULL);
	
	#ifndef NO_SOUND
	if(Mix_OpenAudio(22050, AUDIO_S16SYS, 1, 512) == -1)
	{
		printf("Can't open audio subsystem...");
		exit(1);
	}
	#endif
	
	magenta = SDL_MapRGB(screen->format, 255, 0, 255);
	bgcolor = SDL_MapRGB(screen->format, 150, 200, 225);
	InitMap();
	SDL_Rect p1rect;
	SDL_Rect p2rect;
	p1rect.x = 0;
	p1rect.y = 0;
	p1rect.w = 20;
	p1rect.h = 20;
	p2rect = p1rect;
	player1 = new Player("images/tux1.bmp", &p1rect);
	player2 = new Player("images/tux2.bmp", &p2rect);
	player1->SetPos(0, 40);
	player2->SetPos(SCREEN_W - 20, 40);
	heads[0] = LoadBMP("images/head1.bmp");
	heads[1] = LoadBMP("images/head2.bmp");
	SDL_SetColorKey(heads[0], SDL_SRCCOLORKEY | SDL_RLEACCEL, magenta);
	SDL_SetColorKey(heads[1], SDL_SRCCOLORKEY | SDL_RLEACCEL, magenta);
	/*SDL_SetAlpha(heads[0], SDL_SRCALPHA | SDL_RLEACCEL, 150);
	SDL_SetAlpha(heads[1], SDL_SRCALPHA | SDL_RLEACCEL, 150);*/
#ifndef NO_SOUND
	jump_sound = Mix_LoadWAV("sounds/jump.wav");
	kill_sound = Mix_LoadWAV("sounds/kill.wav");
	bg_music = Mix_LoadMUS("sounds/music.wav");
	if(Mix_PlayMusic(bg_music, -1) == -1)
		printf("Can't load the background music file: 'music.wav'!");
#endif
}

void ExitGame(void)
{
#ifndef NO_SOUND
	Mix_FreeChunk(jump_sound);
	Mix_FreeChunk(kill_sound);
	Mix_FreeMusic(bg_music);
	Mix_CloseAudio();
#endif
	SDL_FreeSurface(heads[0]);
	SDL_FreeSurface(heads[1]);
	if(player1)
		delete player1;
	if(player2)
		delete player2;
	DeinitMap();
	SDL_Quit();
}

void ProcessEvents(SDL_Event *event)
{
	while(SDL_PollEvent(event))
	{
		switch(event->type)
		{
		case SDL_QUIT:
			done = true;
			break;
		case SDL_KEYDOWN:
			switch(event->key.keysym.sym)
			{
			case SDLK_ESCAPE:
				done = true;
				break;
			case SDLK_F5:
				SDL_SaveBMP(screen, "screenshot.bmp");
				break;
			}
			break;
		}
	}
}

void ProcessInput(void)
{
	keys = SDL_GetKeyState(NULL);
	if(keys[SDLK_RIGHT])
	{
		player1->Walk(RIGHT);
	}
	if(keys[SDLK_LEFT])
	{
		player1->Walk(LEFT);
	}
	if(keys[SDLK_UP])
	{
		player1->Jump();
	}
	if(keys[SDLK_d])
	{
		player2->Walk(RIGHT);
	}
	if(keys[SDLK_a])
	{
		player2->Walk(LEFT);
	}
	if(keys[SDLK_w])
	{
		player2->Jump();
	}
	if((!keys[SDLK_RIGHT]) && (!keys[SDLK_LEFT]) && (player1->GetState() == 1))
		player1->SetState(0);
	else if((keys[SDLK_RIGHT]) || (keys[SDLK_LEFT]))
	{
		if(player1->GetState() == 0)
			player1->SetState(1);
	}
	if((!keys[SDLK_d]) && (!keys[SDLK_a]) && (player2->GetState() == 1))
		player2->SetState(0);
	else if((keys[SDLK_a]) || (keys[SDLK_d]))
	{
		if(player2->GetState() == 0)
			player2->SetState(1);
	}
}

void UpdateGame(void)
{
	player1->Update();	
	player2->Update();
	if(player1->HitOther(player2->GetRect()) && player2->GetState() != 4)
	{
		player2->SetState(4);
		player2->SetDeadCount(DEAD_TIME);
	}
	else if(player2->HitOther(player1->GetRect()) && player1->GetState() != 4)
	{
		player1->SetState(4);
		player2->SetDeadCount(DEAD_TIME);
	}
	SDL_FillRect(screen, NULL, bgcolor);
	DrawMap();
	player1->DrawP();
	player2->DrawP();
	player1->DrawLives(heads[0], 20, 1);
	player2->DrawLives(heads[1], SCREEN_W - 100, 1);
	SDL_Flip(screen);
}

void CorrectFrameTime(void)
{
	static Uint32 stime;	
	while(SDL_GetTicks() - stime < 40);
	stime = SDL_GetTicks();
}