/*****************************************************\
	CTux_Sprite.cpp	
	Author: Andr Schnabel
	Date: 30.10.02 - 31.10.02
	License: GPL
\*****************************************************/

#include "CTux_Sprite.h"

void Sprite::SetImage(SDL_Surface *newimageset, SDL_Rect *newsrcrect)
{
	imageset = newimageset;
	srcrect = *newsrcrect;
}

void Sprite::SetImage(const char *filename, SDL_Rect *newsrcrect)
{
	imageset = LoadBMP(filename);
	if(imageset == NULL)
	{
		printf("Can't load: ", filename);
		exit(1);
	}
	srcrect = *newsrcrect;
	rect.w = srcrect.w;
	rect.h = srcrect.h;
}

void Sprite::Draw(int imgnr)
{
	if(imgnr * srcrect.w < SCREEN_W)
	{
		srcrect.x = imgnr * srcrect.w;
		SDL_BlitSurface(imageset, &srcrect, screen, &rect);
	}
}

void Sprite::SetPos(int posx, int posy)
{
	rect.x = posx;
	rect.y = posy;
}

void Sprite::Move(int movx, int movy)
{
	rect.x += movx;
	rect.y += movy;
}

SDL_Rect *Sprite::GetRect(void)
{
	return &rect;
}