#ifndef VECTOROIDS_H
#define VECTOROIDS_H

/* Constraints: */
#define NUM_BULLETS 2
#define NUM_ASTEROIDS 20
#define NUM_BITS 50
#define AST_SIDES 6
#define AST_RADIUS 10
#define SHIP_RADIUS 20
#define ZOOM_START 40
#define ONEUP_SCORE 10000
#define FPS 60
#define WIDTH 640
#define HEIGHT 480

enum { FALSE, TRUE };

#define LEFT_EDGE   0x0001
#define RIGHT_EDGE  0x0002
#define TOP_EDGE    0x0004
#define BOTTOM_EDGE 0x0008

#define CHAN_THRUST 0

/* Types: */
typedef struct letter_type {
  int x, y;
  int xm, ym;
} letter_type;

typedef struct bullet_type {
  int timer;
  int x, y;
  int xm, ym;
} bullet_type;

typedef struct shape_type {
  int radius;
  int angle;
} shape_type;

typedef struct asteroid_type {
  int alive, size;
  int x, y;
  int xm, ym;
  int angle, angle_m;
  shape_type shape[AST_SIDES];
} asteroid_type;

typedef struct bit_type {
  int timer;
  int x, y;
  int xm, ym;
} bit_type;

typedef struct color_type {
  Uint8 r;
  Uint8 g;
  Uint8 b;
} color_type;

extern int char_vectors[36][5][4];

/* function prototypes: */
int title(void);
int game(void);
void finish(void);
void setup();
void seticon(void);
int fast_cos(int v);
int fast_sin(int v);
void draw_line(int x1, int y1, color_type c1,
	       int x2, int y2, color_type c2);
int clip(int * x1, int * y1, int * x2, int * y2);
color_type mkcolor(int r, int g, int b);
void sdl_drawline(int x1, int y1, color_type c1,
		  int x2, int y2, color_type c2);
unsigned char encode(float x, float y);
void drawvertline(int x, int y1, color_type c1,
                  int y2, color_type c2);
void putpixel(SDL_Surface * surface, int x, int y, Uint32 pixel);
void draw_segment(int r1, int a1,
		  color_type c1,
		  int r2, int a2,
		  color_type c2,
		  int cx, int cy, int ang);
void add_bullet(int x, int y, int a, int xm, int ym);
void add_asteroid(int x, int y, int xm, int ym, int size);
void add_bit(int x, int y, int xm, int ym);
void draw_asteroid(int size, int x, int y, int angle, shape_type * shape);
void playsound(int snd);
void hurt_asteroid(int j, int xm, int ym, int exp_size);
void add_score(int amount);
void draw_char(char c, int x, int y, int r, color_type cl);
void draw_text(char * str, int x, int y, int s, color_type c);
void draw_thick_line(int x1, int y1, color_type c1,
		     int x2, int y2, color_type c2);
void reset_level(void);
void show_version(void);
SDL_Surface * set_vid_mode(unsigned flags);
void draw_centered_text(char * str, int y, int s, color_type c);


#endif

