#include <kos.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_image.h>
#include "vectoroids.h"
#include "storm.h"

/* XPM */
static char *vmu_icon_xpm =
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"*********************************************..*"
"*******************************************....*"
"**......***********************************....*"
"*..********..******************************....*"
"*..********..****......**..****...........**..**"
"*..******......**..**..**....**..***..**..**..**"
"**.....**......**..**..**....**..***..**..**..**"
"******..***..****..**..**..****..***..**..**..**"
"******..***..****..**..**..****..***..**..******"
"******..***..****..**..**..****..***..**..**..**"
"*......****..****......**..****..***..**..**..**"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************"
"************************************************";

/* Fading surfaces */
SDL_Surface* intro_img1, * intro_img2, * intro_img3;
SDL_Surface* screen, *warning, *title_vdc;
SDL_Rect dest;

Mix_Music * stormfx;

void fade_screen( int type, int time )
{
	SDL_Surface *buffer = 0;
	float alpha;
	float alpha_change; /* per ms */
	int leave = 0;
	int ms;
	int cur_ticks, prev_ticks;

	/* get screen contents */
	buffer = SDL_CreateRGBSurface( 
			SDL_SWSURFACE, screen->w, screen->h,
			screen->format->BitsPerPixel,
			screen->format->Rmask, screen->format->Bmask,
			screen->format->Gmask, screen->format->Amask );
	if ( buffer == 0 ) return;
	SDL_BlitSurface( screen, 0, buffer, 0 );

	/* compute alpha and alpha change */
	if ( type == FADE_OUT ) {
		alpha = 255;
		alpha_change = -255.0 / time;
	}
	else {
		alpha = 0;
		alpha_change = 255.0 / time;
	}

	/* fade */
	cur_ticks = prev_ticks = SDL_GetTicks();
	while ( !leave ) {
		prev_ticks = cur_ticks;
		cur_ticks = SDL_GetTicks();
		ms = cur_ticks - prev_ticks;
		
		alpha += alpha_change * ms;
		if ( type == FADE_IN && alpha >= 255 ) break;
		if ( type == FADE_OUT && alpha <= 0 ) break;
		
		/* update */
		SDL_FillRect( screen, 0, 0x0 );
		SDL_SetAlpha( buffer, SDL_SRCALPHA | SDL_RLEACCEL, (int)alpha );
		SDL_BlitSurface( buffer, 0, screen, 0 );
		SDL_Flip(screen);
	}

	/* update screen */
	SDL_SetAlpha( buffer, 0, 0 );
	if ( type == FADE_IN )
		SDL_BlitSurface( buffer, 0, screen, 0 );
	else
		SDL_FillRect( screen, 0, 0x0 );
	SDL_Flip(screen);
	SDL_FreeSurface( buffer );
}

void do_intro()
{
  SDL_ShowCursor(SDL_DISABLE);

  SDL_BlitSurface(intro_img1, NULL, screen, NULL);
  SDL_UpdateRect(screen, 0, 0, 640, 480);
  SDL_Delay (4000) ;

  SDL_BlitSurface(intro_img2, NULL, screen, NULL);
  fade_screen( FADE_IN, 1000 );
  SDL_UpdateRect(screen, 0, 0, 640, 480);
  Mix_PlayMusic(stormfx, 0);
  SDL_Delay (3000) ;
  fade_screen( FADE_OUT, 1000 );

  SDL_BlitSurface(intro_img3, NULL, screen, NULL);
  fade_screen( FADE_IN, 1000 );
  SDL_UpdateRect(screen, 0, 0, 640, 480);
  SDL_Delay (3000);
  fade_screen( FADE_OUT, 1000 );
}

void vmu_lcd_update()
{
vmu_set_icon(vmu_icon_xpm);
}

/* Write to VMU */
//Adapted from code by Sam Steele....the man, the myth, the legend
void save_vdc(int score, int high) {

  SDL_BlitSurface(warning, NULL, screen, NULL);
  fade_screen( FADE_IN, 1000 );
  SDL_UpdateRect(screen, 0, 0, 640, 480);
  SDL_Delay (3000) ;
  fade_screen( FADE_OUT, 1000 );
  SDL_Delay (3000);

  file_t fd;
  int file_size=0;
  uint8 *data; //place to store the file in RAM  
  vmu_pkg_t pkg; //this is our VMU file header
  uint8 *pkg_out; //this will hold the file after the header is added
  int pkg_size; //this is the size of the file after the header is added 

    //create the file on /ram
  fd=fs_open("/ram/tempfile",O_WRONLY);
  fs_write(fd,&score,sizeof(int));
  fs_write(fd,&high,sizeof(int));
  fs_close(fd);

  //load the file into RAM
  fd=fs_open("/ram/tempfile",O_RDONLY);
 
  file_size=fs_total(fd); //get the length of the file
 
  data=malloc(file_size); //allocate room to store the file in RAM
  fs_read(fd,data,file_size); //read the file into RAM
  fs_close(fd); 

  //write the file to VMU
  strcpy(pkg.desc_short, "VECTORIODS DC"); //short description of the file
  strcpy(pkg.desc_long, "Save State & High Score"); //longer description of the file
  strcpy(pkg.app_id, "KOS"); //which app created this file
  pkg.icon_cnt = 0; //number of icons
  pkg.icon_anim_speed = 0; //speed the icons animate at
  //pkg.icon_data = VMU_load_icon("/rd/icon_vdc.bmp", pkg.icon_pal);      //damn you, KOS
  pkg.eyecatch_type = VMUPKG_EC_NONE; //which eyecatch to use
  pkg.data_len = file_size; //how big the file is without the header (from earlier)
  pkg.data = data; //data is our area in RAM where we stored our file
 
  vmu_pkg_build(&pkg, &pkg_out, &pkg_size); //tack on the header and compute the checksum.
 
  fd=fs_open("/vmu/a1/vdc.dat",O_WRONLY); //open our file on the VMU
  fs_write(fd,pkg_out,pkg_size); //write the file with the header added
  fs_close(fd);

  free(pkg_out);//clean up 
  free(data);
}

//thanks to Sam Steele for sheading some light on this
void load_vdc(int *score, int *high)
{
  SDL_BlitSurface(warning, NULL, screen, NULL);
  fade_screen( FADE_IN, 1000 );
  SDL_UpdateRect(screen, 0, 0, 640, 480);
  SDL_Delay (3000) ;
  fade_screen( FADE_OUT, 1000 );
  SDL_Delay (1000);

  uint8 data[200]; //some temporary scratch space
  file_t fd=fs_open("/vmu/a1/vdc.dat",O_RDONLY);

  fs_read(fd,data,128); //read and ignore the header :)
  fs_read(fd,score,sizeof(int));
  fs_read(fd,high,sizeof(int));
  fs_close(fd);
}

void storm_data()
{
  intro_img1 = SDL_DisplayFormat (IMG_Load("/rd/storm/disclaimer.png")) ;
  intro_img2 = SDL_DisplayFormat (IMG_Load("/rd/storm/storm_intro.png")) ;
  intro_img3 = SDL_DisplayFormat (IMG_Load ("/rd/storm/SDL_title.png")) ;
  warning = SDL_DisplayFormat (IMG_Load ("/rd/storm/warning.png")) ;
  title_vdc = SDL_DisplayFormat (IMG_Load ("/rd/storm/title.png")) ;
  stormfx = Mix_LoadMUS("/rd/storm/stormfx.wav");
}

int credits(){};


