/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * prompt.cpp -- Simple yes/no style prompt using Tsunami classes
 */

#include "copperswapper.h"

Prompt::Prompt(char *text)
{
	m_scene->setTranslate(Vector(320, 240, 10));

	m_promptText = new Label(baseFont, text, 24, true, true);
	m_promptText->setTranslate(Vector(0, 0, 15));
	m_scene->subAdd(m_promptText);
	m_instrText = new Label(baseFont, "Press A to accept, B to cancel", 24, true, true);
	m_instrText->setTranslate(Vector(0, 30, 15));
	m_scene->subAdd(m_instrText);
	m_result = 0;

}

void Prompt::inputEvent(const Event &evt)
{
	if(evt.key == Event::KeyCancel)
	{
		m_result = 0;
		startExit();
	}
	else if(evt.key == Event::KeySelect)
	{
		m_result = 1;
		startExit();
	}
	else
	{
		GenericMenu::inputEvent(evt);
	}
}

void Prompt::startExit()
{
	m_exiting = true;
	m_exitSpeed = 1.0f;
}
