/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * mainmenu.cpp -- Main Menu handler
 */

#include "copperswapper.h"

MainMenu::MainMenu()
{
	// Set screen center
	m_scene->setTranslate(Vector(320,240,10));
	
	m_bg = new Banner(PLX_LIST_TR_POLY, bgTitle);
	m_bg->setTranslate(Vector(0, 0, 10));
	m_bg->setSize(640.0f, 480.0f);

	m_bg2 = new Banner(PLX_LIST_TR_POLY, titleText);
	m_bg2->setTranslate(Vector(50, -100, 11));
	m_bg2->setSize(512.0f, 256.0f);

	m_bg3 = new Banner(PLX_LIST_TR_POLY, titleGoat);
	m_bg3->setTranslate(Vector(-225, -150, 11));
	m_bg3->setSize(256.0f, 128.0f);

	m_scene->subAdd(m_bg);
	m_scene->subAdd(m_bg2);
	m_scene->subAdd(m_bg3);
	
	m_cursel = 0;

	m_options[0] = new Label(baseFont, "New Game", 24, true, true);
	m_options[0]->setTranslate(Vector(0, 400, 15));
	m_options[0]->animAdd(new LogXYMover(0, 50));
	m_options[0]->setTint(colorMenuSelected);
	m_scene->subAdd(m_options[0]);

	m_options[1] = new Label(baseFont, "HighScores", 24, true, true);
	m_options[1]->setTranslate(Vector(0, 1200, 15));
	m_options[1]->animAdd(new LogXYMover(0, 80));
	m_options[1]->setTint(colorMenuDefault);
	m_scene->subAdd(m_options[1]);

	m_options[2] = new Label(baseFont, "Quit", 24, true, true);
	m_options[2]->setTranslate(Vector(0, 2000, 15));
	m_options[2]->animAdd(new LogXYMover(0, 110));
	m_options[2]->setTint(colorMenuDefault);
	m_scene->subAdd(m_options[2]);
}

void MainMenu::doMenu()
{
	GenericMenu::doMenu();
}

void MainMenu::inputEvent(const Event &evt)
{
	if(evt.type != Event::EvtKeypress)
	{
		return;
	}

	switch (evt.key) {
		case Event::KeyUp:
			m_cursel--;
			if (m_cursel < 0)
				m_cursel += 3;
			break;
		case Event::KeyDown:
			m_cursel++;
			if (m_cursel >= 3)
				m_cursel -= 3;
			break;
		case Event::KeySelect:
			switch(m_cursel)
			{
				case 0:	// new game menu
					ingame->setMode(m_cursel);
					ingame->newGame();
					ingame->doMenu();
					//newgameMenu->doMenu();
					break;
				case 1:
					highscoreMenu->update();
					highscoreMenu->doMenu();
					break;
				case 2:
					startExit();
					break;
			}
			break;
		default:
			break;	
	}

	for (int i=0; i<3; i++)
	{
		if (i == m_cursel)
		{
			m_options[i]->setTint(colorMenuSelected);
		}
		else
		{
			m_options[i]->setTint(colorMenuDefault);
		}
	}
	
}

