/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * ingame.h -- Defines the ingame handler class
 */


#ifndef _INGAME_H_
#define _INGAME_H_

typedef enum DIRECTION
{
	DIRECTION_HORIZ = 0,
	DIRECTION_VERT = 1,
};

class Alignment: public RefCnt
{
	public:
		Alignment(int x, int y, int count, DIRECTION dir)
		{
			m_x = x;
			m_y = y;
			m_count = count;
			m_dir = dir;
		}

		int getCount() { return m_count; }
		int getX() { return m_x; }
		int getY() { return m_y; }
		DIRECTION getDir() { return m_dir; }

	private:
		int m_x, m_y, m_count;
		DIRECTION m_dir;
};

class InGame : public GenericMenu
{
	public:
		InGame();
		virtual void inputEvent(const Event &evt);
		virtual void startExit();
		virtual void quitNow();
		void setMode(int mode);
		void newGame();
		void checkScore();
		virtual void visualPerFrame();

	private:
		typedef enum _BOARD_STATE
		{
			STATE_IDLE = 0,
			STATE_ROTATED,
			STATE_ILLEGAL_MOVE,
			STATE_MARK_ALIGNED,
			STATE_REFILLING,
			STATE_GAMEOVER,
		} BOARD_STATE;

		typedef enum _ROTATE_DIR
		{
			ROTATE_CLOCKWISE,
			ROTATE_COUNTERCLOCK,
		} ROTATE_DIR;

		uint32		m_nextLevel;
		uint32		m_levelUpTiles;

		uint32		m_tilesRemoved;
		uint32		m_level;
		uint32		m_score;
		uint32		m_tileCount[7];
		RefPtr<Texture>	m_tileset[7];
		RefPtr<Banner>	m_tileBanners[8][8];
		RefPtr<Banner>	m_cursor;
		int		m_tiles[8][8];
		List<Alignment>	m_align;
		Vector		m_tileSelOffset[8][8];

		int		m_selX, m_selY;
		int		m_oldselX, m_oldselY;
		int		m_rotateDir;
		int		m_frameCnt;
		int		m_selectFrameCnt;

		RefPtr<Label>	m_statusTxt;
		RefPtr<Label>	m_scoreLabel;
		RefPtr<Label>	m_scoreTxt;
		RefPtr<Label>	m_levelLabel;
		RefPtr<Label>	m_levelTxt;
		RefPtr<Label>	m_nextLevelLabel;
		RefPtr<Label>	m_nextLevelTxt;
		char		scoreText[25];
		char		levelText[25];
		char		nextLevelText[25];
		RefPtr<Banner>	m_bg;
		RefPtr<Banner>	m_bg2;
		RefPtr<Banner>	m_bg3;
		uint		m_mode;
		BOARD_STATE	m_boardState;

		void loadTiles();

		int getNextTile();
		void rotateTiles(int x,int y, ROTATE_DIR dir);
		void swapTiles(int x1, int y1, int x2, int y2);
		int checkAlignment(int x, int y);
		void removeAlignments();
		int checkForAlignments();
		void refillBoard();


};

#endif
