/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * highscoremenu.cpp -- Highscore table
 */

#include "copperswapper.h"
char scores[10][25];
char levels[10][25];

HighScoreMenu::HighScoreMenu()
{
	// Set screen center
	m_scene->setTranslate(Vector(320,240,10));
	
	m_bg[0] = new Banner(PLX_LIST_TR_POLY, bgTitle);
	m_bg[0]->setTranslate(Vector(0, 0, 10));
	m_bg[0]->setSize(640.0f, 480.0f);

	m_bg[1] = new Banner(PLX_LIST_TR_POLY, titleText);
	m_bg[1]->setTranslate(Vector(50, -150, 11));
	m_bg[1]->setSize(256.0f, 128.0f);

	m_scene->subAdd(m_bg[0]);
	m_scene->subAdd(m_bg[1]);

	m_columns[0] = new Label(baseFont, "Name", 24, true, true);
	m_columns[0]->setTranslate(Vector(0, 400, 15));
	m_columns[0]->animAdd(new LogXYMover(-225, -75));
	m_columns[0]->setTint(colorMenuDefault);
	m_scene->subAdd(m_columns[0]);

	m_columns[1] = new Label(baseFont, "Level", 24, true, true);
	m_columns[1]->setTranslate(Vector(0, 400, 15));
	m_columns[1]->animAdd(new LogXYMover(100, -75));
	m_columns[1]->setTint(colorMenuDefault);
	m_scene->subAdd(m_columns[1]);

	m_columns[2] = new Label(baseFont, "Score", 24, true, true);
	m_columns[2]->setTranslate(Vector(0, 400, 15));
	m_columns[2]->animAdd(new LogXYMover(200, -75));
	m_columns[2]->setTint(colorMenuDefault);
	m_scene->subAdd(m_columns[2]);

	for(int i = 0; i < 10; i++)
	{
		m_names[i] = new Label(baseFont, scoreTable->entries[i].name, 24, true, true);
		m_names[i]->setTranslate(Vector(0, 400, 15));
		m_names[i]->animAdd(new LogXYMover(-225, -45 + (i*27)));
		m_names[i]->setTint(colorMenuDefault);
		m_scene->subAdd(m_names[i]);
		sprintf((char *)scores[i], "%d", scoreTable->entries[i].score);
		m_scores[i] = new Label(baseFont, scores[i], 24, true, true);
		m_scores[i]->setTranslate(Vector(0, 400, 15));
		m_scores[i]->animAdd(new LogXYMover(200, -45 + (i*27)));
		m_scores[i]->setTint(colorMenuDefault);
		m_scene->subAdd(m_scores[i]);
		sprintf((char *)levels[i], "%d", scoreTable->entries[i].level_reached);
		m_levels[i] = new Label(baseFont, levels[i], 24, true, true);
		m_levels[i]->setTranslate(Vector(0, 400, 15));
		m_levels[i]->animAdd(new LogXYMover(100, -45 + (i*27)));
		m_levels[i]->setTint(colorMenuDefault);
		m_scene->subAdd(m_levels[i]);
	}
}

void HighScoreMenu::update()
{
	for(int i = 0; i < 10; i++)
	{
		m_names[i]->setText(scoreTable->entries[i].name);
		sprintf((char *)scores[i], "%d", scoreTable->entries[i].score);
		m_scores[i]->setText(scores[i]);
		sprintf((char *)levels[i], "%d", scoreTable->entries[i].level_reached);
		m_levels[i]->setText(levels[i]);
	}
}

void HighScoreMenu::inputEvent(const Event &evt)
{
	if(evt.type != Event::EvtKeypress)
	{
		return;
	}

	if(evt.key == Event::KeyMiscY)
	{
		initScoreTable();
		update();
	}
	else
	{
		startExit();
	}
}

void HighScoreMenu::doMenu()
{
	GenericMenu::doMenu();
}
