/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * copperswapper.h -- Global include file
 */

#include <kos.h>
#include <math.h>
#include <stdlib.h>
#include "tsu/font.h"
#include "tsu/sound.h"
#include "tsu/texture.h"

#include "tsu/drawables/banner.h"
#include "tsu/drawables/label.h"
#include "tsu/drawables/scene.h"

#include "tsu/anims/alphafader.h"
#include "tsu/anims/logxymover.h"

#include "tsu/triggers/death.h"

#include <dc/sound/sound.h>

#include <oggvorbis/sndoggvorbis.h>

#include "genmenu.h"
#include "prompt.h"
#include "mainmenu.h"
#include "highscoremenu.h"

#include "ingame.h"

#include "libmenu.h"

extern Font *baseFont;

extern MainMenu *mainMenu;
extern InGame *ingame;
extern HighScoreMenu *highscoreMenu;
extern Texture *bgTitle;
extern Texture *bgOverLay;
extern Texture *titleText;
extern Texture *titleGoat;
extern Texture *titleStart;
extern Texture *bgGameOverTxr;
extern Texture *selectorTileTxr[4];
extern Sound *selectSound;
extern Color colorMenuSelected;
extern Color colorMenuDefault;

extern score_table_t *scoreTable;

extern int musicVolume;

#define COPPER_SWAPPER_GAME_ID 0

typedef enum SONG_ID
{
	SONG_MENU = 0,
	SONG_NULL = 1
};

void initScoreTable();
SONG_ID getCurrentSong();
void switchMusic(SONG_ID song, int loop);
void switchMusic(SONG_ID song, int loop, int fade);
void loadTextures();
void loadSounds();
void loadMenus();
void intro();
void titleScreen();
void printScoreTable();

uint32 randomMT();
void seedMT(uint32 seed);

#define randnum(a) ((randomMT() & 0x7fffffff) % a)

